/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi.hexagon;

import de.gsi.chart.renderer.spi.hexagon.GridPosition;
import de.gsi.chart.renderer.spi.hexagon.Hexagon;
import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import de.gsi.chart.renderer.spi.hexagon.IPathInfoSupplier;
import de.gsi.chart.renderer.spi.hexagon.NoPathFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class GridCalculationsHelper {
    GridCalculationsHelper() {
    }

    public static ArrayList<Hexagon> getPathBetween(Hexagon start, Hexagon destination, IPathInfoSupplier pathInfoSupplier) throws NoPathFoundException {
        ArrayList<Hexagon> closedSet = new ArrayList<Hexagon>();
        ArrayList<Hexagon> openSet = new ArrayList<Hexagon>();
        openSet.add(start);
        start.aStarGscore = 0;
        start.aStarFscore = start.aStarGscore + GridPosition.getDistance(start.position, destination.position);
        while (!openSet.isEmpty()) {
            Hexagon currentHexagon = GridCalculationsHelper.findHexagonWithLowestFscore(openSet);
            if (currentHexagon.position.equals(destination.position)) {
                return GridCalculationsHelper.reconstructPath(start, destination);
            }
            openSet.remove((Object)currentHexagon);
            closedSet.add(currentHexagon);
            for (Hexagon neighbour : currentHexagon.getNeighbours()) {
                if (pathInfoSupplier.isBlockingPath(neighbour) && !destination.equals((Object)neighbour) || closedSet.contains((Object)neighbour)) continue;
                int tentativeGscore = currentHexagon.aStarGscore + pathInfoSupplier.getMovementCost(currentHexagon, neighbour);
                if (openSet.contains((Object)neighbour) && tentativeGscore >= neighbour.aStarGscore) continue;
                neighbour.aStarCameFrom = currentHexagon;
                neighbour.aStarGscore = tentativeGscore;
                neighbour.aStarFscore = neighbour.aStarGscore + GridPosition.getDistance(neighbour.position, destination.position);
                if (openSet.contains((Object)neighbour)) continue;
                openSet.add(neighbour);
            }
        }
        throw new NoPathFoundException("Can't find any path to the goal Hexagon");
    }

    private static Hexagon findHexagonWithLowestFscore(ArrayList<Hexagon> openSet) {
        Hexagon hexagonWithLowestFscore = openSet.get(0);
        int lowestFscore = hexagonWithLowestFscore.aStarFscore;
        for (Hexagon h : openSet) {
            if (h.aStarFscore >= lowestFscore) continue;
            hexagonWithLowestFscore = h;
            lowestFscore = h.aStarFscore;
        }
        return hexagonWithLowestFscore;
    }

    private static ArrayList<Hexagon> reconstructPath(Hexagon start, Hexagon goal) {
        ArrayList<Hexagon> path = new ArrayList<Hexagon>();
        Hexagon currentHexagon = goal;
        while (currentHexagon != start) {
            path.add(currentHexagon);
            currentHexagon = currentHexagon.aStarCameFrom;
        }
        Collections.reverse(path);
        return path;
    }

    public static List<Hexagon> getLine(GridPosition origin, GridPosition destination, HexagonMap map) {
        ArrayList<Hexagon> result = new ArrayList<Hexagon>();
        List<GridPosition> positions = origin.line(destination);
        for (GridPosition position : positions) {
            Hexagon h = map.getHexagon(position);
            if (h == null) continue;
            result.add(h);
        }
        return result;
    }

    public static List<Hexagon> getVisibleHexes(Hexagon origin, int visibleRange, HexagonMap map) {
        List<GridPosition> ringMembers = origin.position.getPositionsOnCircleEdge(visibleRange);
        ArrayList<Hexagon> result = new ArrayList<Hexagon>();
        block0: for (GridPosition ringMemberPosition : ringMembers) {
            List<Hexagon> line = GridCalculationsHelper.getLine(origin.position, ringMemberPosition, map);
            for (Hexagon hexagonInLine : line) {
                result.add(hexagonInLine);
                if (!hexagonInLine.isVisualObstacle()) continue;
                continue block0;
            }
        }
        return result;
    }

    public static ArrayList<Hexagon> getHexagonsOnRingEdge(Hexagon center, int radius, HexagonMap map) {
        ArrayList<Hexagon> result = new ArrayList<Hexagon>();
        for (GridPosition position : center.position.getPositionsOnCircleEdge(radius)) {
            Hexagon hexagon = map.getHexagon(position);
            if (hexagon == null) continue;
            result.add(hexagon);
        }
        return result;
    }

    public static ArrayList<Hexagon> getHexagonsInRingArea(Hexagon center, int radius, HexagonMap map) {
        ArrayList<Hexagon> result = new ArrayList<Hexagon>();
        for (GridPosition position : center.position.getPositionsInCircleArea(radius)) {
            Hexagon hexagon = map.getHexagon(position);
            if (hexagon == null) continue;
            result.add(hexagon);
        }
        return result;
    }
}

