/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.renderer.ErrorStyle;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.ErrorDataSetRenderer;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.canvas.GraphicsContext;

public class MountainRangeRenderer
extends ErrorDataSetRenderer
implements Renderer {
    protected DoubleProperty mountainRangeOffset = new SimpleDoubleProperty((Object)this, "mountainRangeOffset", 0.5);
    private final ObservableList<ErrorDataSetRenderer> renderers = FXCollections.observableArrayList();
    final ObservableList<DataSet> empty = FXCollections.observableArrayList();
    private final WeakHashMap<Double, Integer> xWeakIndexMap = new WeakHashMap();
    private final WeakHashMap<Double, Integer> yWeakIndexMap = new WeakHashMap();
    private double zRangeMin = 0.0;
    private double zRangeMax = 0.0;
    private double mountainRaingeExtra = 0.0;

    public MountainRangeRenderer(double mountainRangeOffset) {
        this();
        this.setMountainRangeOffset(mountainRangeOffset);
    }

    public MountainRangeRenderer() {
        this.setDrawMarker(false);
        this.setDrawBars(false);
        this.setErrorType(ErrorStyle.NONE);
        this.xWeakIndexMap.clear();
        this.yWeakIndexMap.clear();
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        if (!(xyChart.getYAxis() instanceof Axis)) {
            throw new InvalidParameterException("y Axis not a Axis derivative, yAxis = " + xyChart.getYAxis());
        }
        Axis yAxis = xyChart.getYAxis();
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)this.getDatasets());
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            if (!(dataSet instanceof DataSet3D)) continue;
            dataSet.lock();
            DataSet3D mData = (DataSet3D)dataSet;
            this.xWeakIndexMap.clear();
            this.yWeakIndexMap.clear();
            yAxis.setAutoGrowRanging(true);
            this.zRangeMin = mData.getZRange().getMin();
            this.zRangeMax = mData.getZRange().getMax();
            this.mountainRaingeExtra = this.getMountainRangeOffset();
            yAxis.setLowerBound(this.zRangeMin);
            yAxis.setUpperBound(this.zRangeMax * (1.0 + this.mountainRaingeExtra));
            yAxis.forceRedraw();
            int yCountMax = mData.getYDataCount();
            this.checkAndRecreateRenderer(yCountMax);
            for (int index = yCountMax - 1; index > 0; --index) {
                Demux3dTo2dDataSet dataSet2D = new Demux3dTo2dDataSet(mData, index);
                ((ErrorDataSetRenderer)this.renderers.get(index)).getDatasets().setAll((Object[])new DataSet[]{dataSet2D});
                ((ErrorDataSetRenderer)this.renderers.get(index)).render(gc, chart, 0, this.empty);
            }
            dataSet.unlock();
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    private void checkAndRecreateRenderer(int nRenderer) {
        if (this.renderers.size() == nRenderer) {
            return;
        }
        if (nRenderer > this.renderers.size()) {
            for (int i = this.renderers.size(); i < nRenderer; ++i) {
                ErrorDataSetRenderer newRenderer = new ErrorDataSetRenderer();
                newRenderer.bind(this);
                newRenderer.showInLegendProperty().unbind();
                newRenderer.setShowInLegend(false);
                this.renderers.add((Object)newRenderer);
            }
            return;
        }
        while (nRenderer < this.renderers.size()) {
            this.renderers.remove(0);
        }
    }

    public final double getMountainRangeOffset() {
        return this.mountainRangeOffset.get();
    }

    public final MountainRangeRenderer setMountainRangeOffset(double mountainRangeOffset) {
        AssertUtils.gtEqThanZero((String)"mountainRangeOffset", (double)mountainRangeOffset);
        this.mountainRangeOffset.setValue((Number)mountainRangeOffset);
        return this;
    }

    public final DoubleProperty mountainRangeOffsetProperty() {
        return this.mountainRangeOffset;
    }

    private class Demux3dTo2dDataSet
    implements DataSetError {
        private final DataSet3D dataSet;
        private final int yIndex;
        private final int yMax;
        private double yShift;
        private List<EventListener> updateListener = new ArrayList<EventListener>();

        public Demux3dTo2dDataSet(DataSet3D sourceDataSet, int selectedYIndex) {
            this.dataSet = sourceDataSet;
            this.yIndex = selectedYIndex;
            this.yMax = this.dataSet.getYDataCount();
            this.yShift = 0.0;
            this.getYMax();
        }

        public List<EventListener> updateEventListener() {
            return this.updateListener;
        }

        public String getName() {
            return this.dataSet.getName() + ":slice#" + this.yIndex;
        }

        public DataSet lock() {
            return this;
        }

        public DataSet unlock() {
            return this;
        }

        public DataSet setAutoNotifaction(boolean flag) {
            return this.dataSet.setAutoNotifaction(flag);
        }

        public boolean isAutoNotification() {
            return this.dataSet.isAutoNotification();
        }

        public int getDataCount() {
            return this.dataSet.getXDataCount();
        }

        public int getDataCount(double xmin, double xmax) {
            return this.dataSet.getDataCount(xmin, xmax);
        }

        public double getX(int i) {
            return this.dataSet.getX(i);
        }

        public double getY(int i) {
            return this.dataSet.getZ(i, this.yIndex) + this.yShift;
        }

        public Double getUndefValue() {
            return this.dataSet.getUndefValue();
        }

        public int getXIndex(double x) {
            Integer ret = MountainRangeRenderer.this.xWeakIndexMap.get(x);
            if (ret == null) {
                ret = this.dataSet.getXIndex(x);
                MountainRangeRenderer.this.xWeakIndexMap.put(x, ret);
            }
            return ret;
        }

        public int getYIndex(double y) {
            Integer ret = MountainRangeRenderer.this.yWeakIndexMap.get(y);
            if (ret == null) {
                ret = this.dataSet.getYIndex(y);
                MountainRangeRenderer.this.yWeakIndexMap.put(y, ret);
            }
            return ret;
        }

        public double getXMin() {
            return this.dataSet.getXMin();
        }

        public double getXMax() {
            return this.dataSet.getXMax();
        }

        public double getYMin() {
            return this.dataSet.getZRange().getMin();
        }

        public double getYMax() {
            this.yShift = MountainRangeRenderer.this.mountainRaingeExtra * MountainRangeRenderer.this.zRangeMax * (double)this.yIndex / (double)this.yMax;
            return MountainRangeRenderer.this.zRangeMax * (1.0 + MountainRangeRenderer.this.mountainRaingeExtra);
        }

        public String getDataLabel(int index) {
            return this.dataSet.getDataLabel(index);
        }

        public String getStyle() {
            return this.dataSet.getStyle();
        }

        public DataSet setStyle(String style) {
            return this.dataSet.setStyle(style);
        }

        public DataSetError.ErrorType getErrorType() {
            return DataSetError.ErrorType.Y;
        }

        public double getXErrorNegative(int index) {
            return 0.0;
        }

        public double getXErrorPositive(int index) {
            return 0.0;
        }

        public double getYErrorNegative(int index) {
            return 0.0;
        }

        public double getYErrorPositive(int index) {
            return 0.0;
        }

        public String getStyle(int index) {
            return null;
        }
    }
}

