/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.CategoryAxis;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import javafx.collections.ObservableList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

@Deprecated
public class LineRenderer
extends AbstractDataSetManagement<LineRenderer>
implements Renderer {
    private static final Color[] COLORS = new Color[]{Color.BLACK, Color.BLUE, Color.GREEN, Color.RED};

    @Override
    protected LineRenderer getThis() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        long start = ProcessingProfiler.getTimeStamp();
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        double xAxisWidth = xAxis.getWidth();
        double xmin = xAxis.getValueForDisplay(0.0);
        double xmax = xAxis.getValueForDisplay(xAxisWidth);
        int index = 0;
        for (DataSet dataset : datasets) {
            try {
                dataset.lock();
                if (index == 0) {
                    CategoryAxis axis;
                    if (xyChart.getXAxis() instanceof CategoryAxis) {
                        axis = (CategoryAxis)xyChart.getXAxis();
                        axis.updateCategories(dataset);
                    }
                    if (xyChart.getYAxis() instanceof CategoryAxis) {
                        axis = (CategoryAxis)xyChart.getYAxis();
                        axis.updateCategories(dataset);
                    }
                }
                if (dataset.getDataCount() <= 0) continue;
                gc.setStroke((Paint)COLORS[index++ % 4]);
                int i = dataset.getXIndex(xmin);
                if (i < 0) {
                    i = 0;
                }
                double x0 = xAxis.getDisplayPosition(dataset.getX(i));
                double y0 = yAxis.getDisplayPosition(dataset.getY(i));
                ++i;
                int maxIndex = Math.min(dataset.getXIndex(xmax) + 1, dataset.getDataCount());
                while (i < maxIndex) {
                    double x1 = xAxis.getDisplayPosition(dataset.getX(i));
                    double y1 = yAxis.getDisplayPosition(dataset.getY(i));
                    gc.strokeLine(x0, y0, x1, y1);
                    x0 = x1;
                    y0 = y1;
                    ++i;
                }
            }
            finally {
                dataset.unlock();
            }
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }
}

