/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.renderer.ContourType;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.renderer.spi.AbstractDataSetManagement;
import de.gsi.chart.renderer.spi.hexagon.Hexagon;
import de.gsi.chart.renderer.spi.hexagon.HexagonMap;
import de.gsi.chart.renderer.spi.marchingsquares.GeneralPath;
import de.gsi.chart.renderer.spi.marchingsquares.MarchingSquares;
import de.gsi.chart.renderer.spi.utils.ColorGradient;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet3D;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;

public class ContourDataSetRenderer
extends AbstractDataSetManagement<ContourDataSetRenderer>
implements Renderer {
    private final Cache localCache = new Cache();
    private Axis zAxis;
    protected final Rectangle gradientRect = new Rectangle();
    private final IntegerProperty quantisationLevels = new SimpleIntegerProperty(this, "quantisationLevels", 20){

        public void set(int newValue) {
            super.set(Math.max(2, newValue));
        }
    };
    private final IntegerProperty minHexTileSize = new SimpleIntegerProperty(this, "minHexTileSize", 5){

        public void set(int newValue) {
            super.set(Math.max(2, newValue));
        }
    };
    private final IntegerProperty maxContourSegments = new SimpleIntegerProperty(this, "maxContourSegments", 500){

        public void set(int newValue) {
            super.set(Math.max(2, newValue));
        }
    };
    private final ObjectProperty<ColorGradient> colorGradient = new SimpleObjectProperty((Object)this, "colorGradient", (Object)ColorGradient.RAINBOW);
    private final BooleanProperty smooth = new SimpleBooleanProperty(this, "smooth", false){

        protected void invalidated() {
        }
    };
    private final BooleanProperty computeLocalRange = new SimpleBooleanProperty((Object)this, "computeLocalRange", true);
    private final ObjectProperty<ContourType> contourType = new SimpleObjectProperty((Object)this, "contourType", (Object)ContourType.HEATMAP);

    @Override
    protected ContourDataSetRenderer getThis() {
        return this;
    }

    public Axis getZAxis() {
        ArrayList<Axis> localAxesList = new ArrayList<Axis>((Collection<Axis>)this.getAxes());
        localAxesList.remove(this.getFirstAxis(Orientation.HORIZONTAL));
        localAxesList.remove(this.getFirstAxis(Orientation.VERTICAL));
        if (localAxesList.isEmpty()) {
            this.zAxis = new DefaultNumericAxis("z-Axis");
            this.zAxis.setAnimated(false);
            this.zAxis.setSide(Side.RIGHT);
            this.getAxes().add((Object)this.zAxis);
        } else {
            this.zAxis = localAxesList.get(0);
            if (this.zAxis.getSide() == null) {
                this.zAxis.setSide(Side.RIGHT);
            }
        }
        this.shiftZAxisToRight();
        return this.zAxis;
    }

    public void shiftZAxisToRight() {
        this.gradientRect.toFront();
        if (this.zAxis != null && this.zAxis instanceof Node) {
            ((Node)this.zAxis).toFront();
        }
    }

    public void shiftZAxisToLeft() {
        this.gradientRect.toBack();
        if (this.zAxis != null && this.zAxis instanceof Node) {
            ((Node)this.zAxis).toBack();
        }
    }

    @Override
    public void render(GraphicsContext gc, Chart chart, int dataSetOffset, ObservableList<DataSet> datasets) {
        long start = ProcessingProfiler.getTimeStamp();
        if (!(chart instanceof XYChart)) {
            throw new InvalidParameterException("must be derivative of XYChart for renderer - " + this.getClass().getSimpleName());
        }
        XYChart xyChart = (XYChart)chart;
        ArrayList<DataSet> localDataSetList = new ArrayList<DataSet>((Collection<DataSet>)datasets);
        localDataSetList.addAll((Collection<DataSet>)this.getDatasets());
        if (localDataSetList.isEmpty()) {
            return;
        }
        if (!(xyChart.getXAxis() instanceof Axis)) {
            throw new InvalidParameterException("x-Axis must be a derivative of Axis, axis is = " + xyChart.getXAxis());
        }
        Axis xAxis = xyChart.getXAxis();
        double xAxisWidth = xAxis.getWidth();
        double xMin = xAxis.getValueForDisplay(0.0);
        double xMax = xAxis.getValueForDisplay(xAxisWidth);
        long stop = ProcessingProfiler.getTimeDiff((long)start, (String)"init");
        for (int dataSetIndex = localDataSetList.size() - 1; dataSetIndex >= 0; --dataSetIndex) {
            DataSet dataSet = (DataSet)localDataSetList.get(dataSetIndex);
            dataSet.lock();
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)"dataSet.lock()");
            int indexMin = Math.max(0, dataSet.getXIndex(xMin));
            int indexMax = Math.min(dataSet.getXIndex(xMax), dataSet.getDataCount());
            if (indexMax - indexMin <= 0) {
                dataSet.unlock();
                continue;
            }
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)("get min/max" + String.format(" from:%d to:%d", indexMin, indexMax)));
            stop = ProcessingProfiler.getTimeDiff((long)start, (String)"get CachedPoints");
            stop = ProcessingProfiler.getTimeDiff((long)stop, (String)"computeScreenCoordinates()");
            this.paintHeatChart(gc, xyChart, dataSet);
            dataSet.unlock();
            ProcessingProfiler.getTimeDiff((long)stop, (String)"finished drawing");
        }
        ProcessingProfiler.getTimeDiff((long)start);
    }

    private void updateCachedVariables(GraphicsContext gc, XYChart chart, DataSet dataSet) {
        DataSet3D dataSet3D;
        Axis xAxis = chart.getXAxis();
        Axis yAxis = chart.getYAxis();
        Axis zAxis = this.getZAxis();
        this.localCache.dataSet3D = dataSet3D = (DataSet3D)dataSet;
        this.localCache.xAxisWidth = xAxis.getWidth();
        this.localCache.xMin = xAxis.getValueForDisplay(0.0);
        this.localCache.xMax = xAxis.getValueForDisplay(this.localCache.xAxisWidth);
        this.localCache.indexXMin = Math.max(0, dataSet3D.getXIndex(this.localCache.xMin));
        this.localCache.indexXMax = Math.min(dataSet3D.getXIndex(this.localCache.xMax), dataSet3D.getXDataCount() - 1);
        this.localCache.yAxisHeight = yAxis.getHeight();
        this.localCache.yMin = yAxis.getValueForDisplay(0.0);
        this.localCache.yMax = yAxis.getValueForDisplay(this.localCache.yAxisHeight);
        this.localCache.indexYMin = Math.max(0, dataSet3D.getYIndex(this.localCache.yMax));
        this.localCache.indexYMax = Math.min(dataSet3D.getYIndex(this.localCache.yMin), dataSet3D.getYDataCount() - 1);
        this.localCache.xSize = Math.abs(this.localCache.indexXMax - this.localCache.indexXMin);
        this.localCache.ySize = Math.abs(this.localCache.indexYMax - this.localCache.indexYMin);
        if (this.computeLocalRange()) {
            ContourDataSetRenderer.computeZrange(zAxis, dataSet3D, this.localCache.indexXMin, this.localCache.indexXMax, this.localCache.indexYMin, this.localCache.indexYMax);
        } else {
            ContourDataSetRenderer.computeZrange(zAxis, dataSet3D, 0, dataSet3D.getXDataCount() - 1, 0, dataSet3D.getYDataCount() - 1);
        }
        this.localCache.zMin = zAxis.getLowerBound();
        this.localCache.zMax = zAxis.getUpperBound();
        this.localCache.zInverted = zAxis.isInvertedAxis();
        this.layoutZAxis(this.getZAxis(), this.localCache);
    }

    private void paintHeatChart(GraphicsContext gc, XYChart chart, DataSet dataSet) {
        if (!(dataSet instanceof DataSet3D)) {
            return;
        }
        if (!(chart.getXAxis() instanceof Axis)) {
            throw new InvalidParameterException("x Axis not a Axis derivative, xAxis = " + chart.getXAxis());
        }
        if (!(chart.getYAxis() instanceof Axis)) {
            throw new InvalidParameterException("y Axis not a Axis derivative, yAxis = " + chart.getYAxis());
        }
        DataSet3D dataSet3D = (DataSet3D)dataSet;
        if (dataSet3D.getXDataCount() == 0 || dataSet3D.getYDataCount() == 0) {
            return;
        }
        this.updateCachedVariables(gc, chart, dataSet);
        if (this.localCache.xSize == 0 || this.localCache.ySize == 0) {
            return;
        }
        Axis zAxis = this.getZAxis();
        AxisTransform axisTransform = zAxis.getAxisTransform();
        zAxis.getAxisTransform();
        switch (this.getContourType()) {
            case CONTOUR: {
                this.drawContour(gc, axisTransform, this.localCache);
                break;
            }
            case CONTOUR_FAST: {
                this.drawContourFast(gc, axisTransform, this.localCache);
                break;
            }
            case CONTOUR_HEXAGON: {
                this.drawHexagonMapContourAlt(gc, axisTransform, this.localCache, true);
                break;
            }
            case HEATMAP_HEXAGON: {
                this.drawHexagonHeatMap(gc, axisTransform, this.localCache, true);
                break;
            }
            default: {
                this.drawHeatMap(gc, axisTransform, this.localCache);
            }
        }
    }

    private void drawContour(GraphicsContext gc, AxisTransform axisTransform, Cache lCache) {
        double scaleX = Math.max(lCache.xAxisWidth / (double)lCache.xSize, 1.0);
        double scaleY = Math.max(lCache.yAxisHeight / (double)lCache.ySize, 1.0);
        double zMin = axisTransform.forward(lCache.zMin);
        double zMax = axisTransform.forward(lCache.zMax);
        int indexXMin = lCache.indexXMin;
        int indexYMax = lCache.indexYMax;
        DataSet3D dataSet = lCache.dataSet3D;
        double[] levels = new double[this.getNumberQuantisationLevels()];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = (double)(i + 1) / (double)levels.length;
        }
        double[][] data = new double[lCache.ySize][lCache.xSize];
        for (int xIndex = lCache.indexXMin; xIndex < lCache.indexXMax; ++xIndex) {
            for (int yIndex = lCache.indexYMin; yIndex < lCache.indexYMax; ++yIndex) {
                double offset;
                double z = dataSet.getZ(xIndex, yIndex);
                data[indexYMax - 1 - yIndex][xIndex - indexXMin] = offset = (axisTransform.forward(z) - zMin) / (zMax - zMin);
            }
        }
        MarchingSquares marchingSquares = new MarchingSquares();
        try {
            gc.save();
            gc.scale(scaleX, scaleY);
            GeneralPath[] isolines = marchingSquares.buildContours(data, levels);
            int levelCount = 0;
            for (GeneralPath path : isolines) {
                if (path.size() > this.getMaxContourSegments()) {
                    ++levelCount;
                    continue;
                }
                Color color = lCache.zInverted ? this.getColor(1.0 - levels[levelCount++]) : this.getColor(levels[levelCount++]);
                gc.setStroke((Paint)color);
                gc.setLineDashes(new double[]{1.0});
                gc.setMiterLimit(10.0);
                gc.setFill((Paint)color);
                gc.setLineWidth(0.5);
                path.draw(gc);
            }
            gc.restore();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void drawContourFast(GraphicsContext gc, AxisTransform axisTransform, Cache lCache) {
        long start = ProcessingProfiler.getTimeStamp();
        int scaleX = this.isSmooth() ? 1 : Math.max((int)this.localCache.xAxisWidth / this.localCache.xSize, 1);
        int scaleY = this.isSmooth() ? 1 : Math.max((int)this.localCache.yAxisHeight / this.localCache.ySize, 1);
        int xSize = lCache.xSize;
        int ySize = lCache.ySize;
        double zMin = axisTransform.forward(lCache.zMin);
        double zMax = axisTransform.forward(lCache.zMax);
        int indexXMin = lCache.indexXMin;
        int indexXMax = lCache.indexXMax;
        int indexYMin = lCache.indexYMin;
        int indexYMax = lCache.indexYMax;
        DataSet3D dataSet = lCache.dataSet3D;
        this.getNumberQuantisationLevels();
        double[][] input = new double[xSize][ySize];
        double[][] output = new double[xSize][ySize];
        double[][] output2 = new double[xSize][ySize];
        double[] levels = new double[this.getNumberQuantisationLevels()];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = (double)(i + 1) / (double)levels.length;
        }
        for (int xIndex = indexXMin; xIndex < indexXMax; ++xIndex) {
            for (int yIndex = indexYMin; yIndex < indexYMax; ++yIndex) {
                double offset;
                double z = dataSet.getZ(xIndex, yIndex);
                int x = xIndex - indexXMin;
                int y = indexYMax - 1 - yIndex;
                input[x][y] = offset = (axisTransform.forward(z) - zMin) / (zMax - zMin);
            }
        }
        WritableImage image = new WritableImage(xSize * scaleX, ySize * scaleY);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (double level : levels) {
            ContourDataSetRenderer.sobelOperator(input, output2, zMin, zMax, level);
            ContourDataSetRenderer.erosionOperator(output2, output, zMin, zMax, level);
            for (int xIndex = indexXMin; xIndex < indexXMax; ++xIndex) {
                for (int yIndex = indexYMin; yIndex < indexYMax; ++yIndex) {
                    Color color;
                    double z = output[xIndex - indexXMin][yIndex - indexYMin];
                    Color color2 = color = lCache.zInverted ? this.getColor(1.0 - z) : this.getColor(z);
                    if (!(z > 0.0)) {
                        color = Color.TRANSPARENT;
                        continue;
                    }
                    color = lCache.zInverted ? this.getColor(1.0 - level) : this.getColor(level);
                    for (int dx = 0; dx < scaleX; ++dx) {
                        for (int dy = 0; dy < scaleY; ++dy) {
                            int x = (xIndex - indexXMin) * scaleX;
                            int y = (indexYMax - 1 - yIndex) * scaleY;
                            pixelWriter.setColor(x + dx, y + dy, color);
                        }
                    }
                }
            }
        }
        gc.drawImage((Image)image, 0.0, 0.0, lCache.xAxisWidth, lCache.yAxisHeight);
        ProcessingProfiler.getTimeDiff((long)start, (String)"sobel");
    }

    private void drawHexagonHeatMap(GraphicsContext gc, AxisTransform axisTransform, Cache lCache, boolean test) {
        long start = ProcessingProfiler.getTimeStamp();
        int xSize = lCache.xSize;
        int ySize = lCache.ySize;
        double zMin = axisTransform.forward(lCache.zMin);
        double zMax = axisTransform.forward(lCache.zMax);
        int indexXMin = lCache.indexXMin;
        int indexXMax = lCache.indexXMax;
        int indexYMin = lCache.indexYMin;
        int indexYMax = lCache.indexYMax;
        DataSet3D dataSet = lCache.dataSet3D;
        int nQuant = this.getNumberQuantisationLevels();
        WritableImage image = new WritableImage(xSize, ySize);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (int xIndex = indexXMin; xIndex < indexXMax; ++xIndex) {
            for (int yIndex = indexYMin; yIndex < indexYMax; ++yIndex) {
                double z = dataSet.getZ(xIndex, yIndex);
                double offset = (axisTransform.forward(z) - zMin) / (zMax - zMin);
                Color color = lCache.zInverted ? this.getColor(ContourDataSetRenderer.quantize(1.0 - offset, nQuant)) : this.getColor(ContourDataSetRenderer.quantize(offset, nQuant));
                int x = xIndex - indexXMin;
                int y = indexYMax - 1 - yIndex;
                pixelWriter.setColor(x, y, color);
            }
        }
        int targetWidth = (int)this.localCache.xAxisWidth;
        int targetHeight = (int)this.localCache.yAxisHeight;
        Image image2 = test ? this.scale((Image)image, targetWidth, targetHeight, false) : this.resample((Image)image, targetWidth, targetHeight);
        int tileSize = Math.max(this.getMinHexTileSizeProperty(), (int)lCache.xAxisWidth / lCache.xSize);
        int nWidthInTiles = (int)(lCache.xAxisWidth / ((double)tileSize * Math.sqrt(3.0))) + 1;
        HexagonMap map2 = new HexagonMap(tileSize, image2, nWidthInTiles, (q, r, imagePixelColor, map) -> {
            Hexagon h = new Hexagon(q, r);
            h.setFill((Paint)imagePixelColor);
            h.setStroke((Paint)imagePixelColor);
            h.setStrokeWidth(0.5);
            map.addHexagon(h);
        });
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMap - prepare");
        map2.render(gc.getCanvas());
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMap");
    }

    private Image scale(Image source, int targetWidth, int targetHeight, boolean preserveRatio) {
        ImageView imageView = new ImageView(source);
        imageView.setPreserveRatio(preserveRatio);
        imageView.setSmooth(false);
        imageView.setFitWidth((double)targetWidth);
        imageView.setFitHeight((double)targetHeight);
        return imageView.snapshot(null, null);
    }

    private Image resample(Image input, int targetWidth, int targetHeight) {
        if (input.getWidth() == 0.0 || input.getHeight() == 0.0) {
            return input;
        }
        int width = (int)input.getWidth();
        int height = (int)input.getHeight();
        double scalingX = targetWidth / width;
        double scalingY = targetHeight / height;
        WritableImage output = new WritableImage((int)((double)width * scalingX), (int)((double)height * scalingY));
        PixelReader reader = input.getPixelReader();
        PixelWriter writer = output.getPixelWriter();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = reader.getArgb(x, y);
                int dy = 0;
                while ((double)dy < scalingY) {
                    int dx = 0;
                    while ((double)dx < scalingX) {
                        int targetX = (int)((double)x * scalingX + (double)dx);
                        int targetY = (int)((double)y * scalingY + (double)dy);
                        writer.setArgb(targetX, targetY, argb);
                        ++dx;
                    }
                    ++dy;
                }
            }
        }
        return output;
    }

    private void drawHexagonMapContour(GraphicsContext gc, AxisTransform axisTransform, Cache lCache, boolean test) {
        long start = ProcessingProfiler.getTimeStamp();
        this.isSmooth();
        Math.max((int)lCache.xAxisWidth / lCache.xSize, 1);
        this.isSmooth();
        Math.max((int)lCache.yAxisHeight / lCache.ySize, 1);
        int xSize = lCache.xSize;
        int ySize = lCache.ySize;
        double zMin = axisTransform.forward(lCache.zMin);
        double zMax = axisTransform.forward(lCache.zMax);
        int indexXMin = lCache.indexXMin;
        int indexXMax = lCache.indexXMax;
        int indexYMin = lCache.indexYMin;
        int indexYMax = lCache.indexYMax;
        DataSet3D dataSet = lCache.dataSet3D;
        int nQuant = this.getNumberQuantisationLevels();
        WritableImage image = new WritableImage(xSize, ySize);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (int xIndex = indexXMin; xIndex < indexXMax; ++xIndex) {
            for (int yIndex = indexYMin; yIndex < indexYMax; ++yIndex) {
                double z = dataSet.getZ(xIndex, yIndex);
                double offset = (axisTransform.forward(z) - zMin) / (zMax - zMin);
                Color color = lCache.zInverted ? this.getColor(ContourDataSetRenderer.quantize(1.0 - offset, nQuant)) : this.getColor(ContourDataSetRenderer.quantize(offset, nQuant));
                int x = xIndex - indexXMin;
                int y = indexYMax - 1 - yIndex;
                pixelWriter.setColor(x, y, color);
            }
        }
        int targetWidth = (int)this.localCache.xAxisWidth;
        int targetHeight = (int)this.localCache.yAxisHeight;
        Image image2 = test ? this.scale((Image)image, targetWidth, targetHeight, false) : this.resample((Image)image, targetWidth, targetHeight);
        int tileSize = Math.max(this.getMinHexTileSizeProperty(), (int)lCache.xAxisWidth / lCache.xSize);
        int nWidthInTiles = (int)(lCache.xAxisWidth / ((double)tileSize * Math.sqrt(3.0)));
        HexagonMap hexMap = new HexagonMap(tileSize, image2, nWidthInTiles, (q, r, imagePixelColor, map) -> {
            Hexagon h = new Hexagon(q, r);
            h.setFill((Paint)Color.TRANSPARENT);
            h.setStroke((Paint)imagePixelColor);
            h.setStrokeType(StrokeType.CENTERED);
            h.setStrokeWidth(1.0);
            map.addHexagon(h);
        });
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMapContour - prepare");
        hexMap.renderContour(gc.getCanvas());
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMapContour");
    }

    private int clamp(int value, int range) {
        return Math.max(Math.min(value, range), 0);
    }

    private void drawHexagonMapContourAlt(GraphicsContext gc, AxisTransform axisTransform, Cache lCache, boolean test) {
        long start = ProcessingProfiler.getTimeStamp();
        int xSize = lCache.xSize;
        int ySize = lCache.ySize;
        double zMin = axisTransform.forward(lCache.zMin);
        double zMax = axisTransform.forward(lCache.zMax);
        int indexXMin = lCache.indexXMin;
        int indexYMax = lCache.indexYMax;
        DataSet3D dataSet = lCache.dataSet3D;
        int nQuant = this.getNumberQuantisationLevels();
        double imageWidth = lCache.xAxisWidth;
        double imageHeight = lCache.yAxisHeight;
        int tileSize = Math.max(this.getMinHexTileSizeProperty(), (int)lCache.xAxisWidth / lCache.xSize);
        HexagonMap map = new HexagonMap(tileSize);
        double w = map.getGraphicsHorizontalDistanceBetweenHexagons();
        double h = map.getGraphicsverticalDistanceBetweenHexagons();
        int mapWidth = (int)(lCache.xAxisWidth / w) + 1;
        double hexagonMapWidthInPixels = map.getGraphicsHorizontalDistanceBetweenHexagons() * (double)mapWidth;
        double horizontalRelation = imageWidth / hexagonMapWidthInPixels;
        double estimatedHexMapHeightInPixels = imageHeight / horizontalRelation;
        int mapHeight = (int)(estimatedHexMapHeightInPixels / map.getGraphicsverticalDistanceBetweenHexagons()) + 1;
        for (int x = 0; x < mapWidth; ++x) {
            for (int y = 0; y < mapHeight; ++y) {
                int axialQ = x - (y - (y & 1)) / 2;
                int axialR = y;
                Hexagon hex = new Hexagon(axialQ, axialR);
                map.addHexagon(hex);
                int xMin = (int)(((double)hex.getGraphicsXoffset() - map.getPaddingX() - w / 2.0) / imageWidth * (double)xSize);
                int xMax = (int)(((double)hex.getGraphicsXoffset() - map.getPaddingX() + w / 2.0) / imageWidth * (double)xSize);
                int yMin = (int)(((double)hex.getGraphicsYoffset() - map.getPaddingY() - h / 2.0) / imageHeight * (double)ySize);
                int yMax = (int)(((double)hex.getGraphicsYoffset() - map.getPaddingY() + h / 2.0) / imageHeight * (double)ySize);
                int count = 0;
                double z = 0.0;
                for (int i = xMin; i < xMax; ++i) {
                    for (int j = yMin; j < yMax; ++j) {
                        z += dataSet.getZ(indexXMin + this.clamp(i, xSize), indexYMax - this.clamp(j, ySize));
                        ++count;
                    }
                }
                if (count > 0) {
                    z /= (double)count;
                }
                double offset = (axisTransform.forward(z) - zMin) / (zMax - zMin);
                double quant = lCache.zInverted ? ContourDataSetRenderer.quantize(1.0 - offset, nQuant) : ContourDataSetRenderer.quantize(offset, nQuant);
                Color color = this.getColor(quant);
                hex.setStroke((Paint)color);
                hex.setFill((Paint)Color.TRANSPARENT);
                hex.setUserData(quant);
            }
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMapContour - prepare");
        for (Hexagon hexagon : map.getAllHexagons()) {
            gc.save();
            Paint stroke = hexagon.getStroke();
            gc.setStroke(stroke);
            gc.setLineWidth(hexagon.getStrokeWidth());
            gc.setFill(hexagon.getFill());
            double z = (Double)hexagon.getUserData();
            ArrayList<HexagonMap.Direction> list = new ArrayList<HexagonMap.Direction>();
            for (HexagonMap.Direction direction : HexagonMap.Direction.values()) {
                Hexagon neighbour = hexagon.getNeighbour(direction);
                if (neighbour == null) continue;
                double neighbourZ = (Double)neighbour.getUserData();
                if (stroke == null || !(z > neighbourZ)) continue;
                list.add(direction);
            }
            hexagon.drawHexagon(gc, list.toArray(new HexagonMap.Direction[list.size()]));
            gc.restore();
        }
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHexagonMapContour");
    }

    private void drawHeatMap(GraphicsContext gc, AxisTransform axisTransform, Cache lCache) {
        long start = ProcessingProfiler.getTimeStamp();
        int scaleX = this.isSmooth() ? 1 : Math.max((int)lCache.xAxisWidth / lCache.xSize, 1);
        int scaleY = this.isSmooth() ? 1 : Math.max((int)lCache.yAxisHeight / lCache.ySize, 1);
        int xSize = lCache.xSize;
        int ySize = lCache.ySize;
        double zMin = axisTransform.forward(lCache.zMin);
        double zMax = axisTransform.forward(lCache.zMax);
        int indexXMin = lCache.indexXMin;
        int indexXMax = lCache.indexXMax;
        int indexYMin = lCache.indexYMin;
        int indexYMax = lCache.indexYMax;
        DataSet3D dataSet = lCache.dataSet3D;
        int nQuant = this.getNumberQuantisationLevels();
        WritableImage image = new WritableImage(xSize * scaleX, ySize * scaleY);
        PixelWriter pixelWriter = image.getPixelWriter();
        for (int xIndex = indexXMin; xIndex < indexXMax; ++xIndex) {
            for (int yIndex = indexYMin; yIndex < indexYMax; ++yIndex) {
                double z = dataSet.getZ(xIndex, yIndex);
                double offset = (axisTransform.forward(z) - zMin) / (zMax - zMin);
                Color color = lCache.zInverted ? this.getColor(ContourDataSetRenderer.quantize(1.0 - offset, nQuant)) : this.getColor(ContourDataSetRenderer.quantize(offset, nQuant));
                int x = (xIndex - indexXMin) * scaleX;
                int y = (indexYMax - 1 - yIndex) * scaleY;
                for (int dx = 0; dx < scaleX; ++dx) {
                    for (int dy = 0; dy < scaleY; ++dy) {
                        pixelWriter.setColor(x + dx, y + dy, color);
                    }
                }
            }
        }
        gc.drawImage((Image)image, 0.0, 0.0, lCache.xAxisWidth, lCache.yAxisHeight);
        ProcessingProfiler.getTimeDiff((long)start, (String)"drawHeatMap");
    }

    private static void computeZrange(Axis zAxis, DataSet3D dataSet3D, int indexXMin, int indexXMax, int indexYMin, int indexYMax) {
        if (!zAxis.isAutoRanging() && !zAxis.isAutoGrowRanging()) {
            return;
        }
        double zMin = Double.MAX_VALUE;
        double zMax = -1.7976931348623157E308;
        for (int xIndex = indexXMin; xIndex < indexXMax; ++xIndex) {
            for (int yIndex = indexYMin; yIndex < indexYMax; ++yIndex) {
                double z = dataSet3D.getZ(xIndex, yIndex);
                zMin = Math.min(zMin, z);
                zMax = Math.max(zMax, z);
            }
        }
        if (zAxis.isAutoRanging()) {
            zAxis.setLowerBound(zMin);
            zAxis.setUpperBound(zMax);
        }
        if (zAxis.isAutoGrowRanging()) {
            zAxis.setLowerBound(Math.min(zMin, zAxis.getLowerBound()));
            zAxis.setUpperBound(Math.max(zMax, zAxis.getUpperBound()));
        }
    }

    private static double quantize(double value, int nLevels) {
        return (double)Math.round(value * (double)nLevels) / (double)nLevels;
    }

    private static void sobelOperator(double[][] input, double[][] output, double zMin, double zMax, double level) {
        int width = input.length;
        int height = input[0].length;
        double[][] gX = new double[width][height];
        double[][] gY = new double[width][height];
        double[][] pixelMatrix = new double[3][3];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (i == 0 || i == width - 1 || j == 0 || j == height - 1) {
                    output[i][j] = 0.0;
                    gY[i][j] = 0.0;
                    gX[i][j] = 0.0;
                    continue;
                }
                gX[i][j] = -1.0 * input[i][j - 1] - 0.0 * input[i][j] + 0.0 * input[i][j + 1];
                double[] dArray = gX[i];
                int n = j;
                dArray[n] = dArray[n] + (0.0 * input[i][j - 1] + 1.0 * input[i][j] + 0.0 * input[i + 1][j + 1]);
                gY[i][j] = 0.0 * input[i][j - 1] - 1.0 * input[i][j] + 0.0 * input[i][j + 1];
                double[] dArray2 = gY[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + (1.0 * input[i][j - 1] - 0.0 * input[i][j] + 0.0 * input[i + 1][j + 1]);
                double zNorm = Math.abs(gX[i][j]) + Math.abs(gY[i][j]);
                pixelMatrix[0][0] = input[i - 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[0][1] = input[i - 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[0][2] = input[i - 1][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][0] = input[i][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][2] = input[i][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][0] = input[i + 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][1] = input[i + 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[2][2] = input[i + 1][j + 1] > level ? 1.0 : 0.0;
                output[i][j] = zNorm = ContourDataSetRenderer.convolution(pixelMatrix);
            }
        }
    }

    private static void erosionOperator(double[][] input, double[][] output, double zMin, double zMax, double level) {
        int width = input.length;
        int height = input[0].length;
        double[][] gX = new double[width][height];
        double[][] gY = new double[width][height];
        double[][] pixelMatrix = new double[3][3];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                if (i == 0 || i == width - 1 || j == 0 || j == height - 1) {
                    output[i][j] = 0.0;
                    gY[i][j] = 0.0;
                    gX[i][j] = 0.0;
                    continue;
                }
                pixelMatrix[0][0] = input[i - 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[0][1] = input[i - 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[0][2] = input[i - 1][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][0] = input[i][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[1][2] = input[i][j + 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][0] = input[i + 1][j - 1] > level ? 1.0 : 0.0;
                pixelMatrix[2][1] = input[i + 1][j] > level ? 1.0 : 0.0;
                pixelMatrix[2][2] = input[i + 1][j + 1] > level ? 1.0 : 0.0;
                double zNorm = ContourDataSetRenderer.erosionConvolution(pixelMatrix);
                output[i][j] = zNorm > 4.0 ? 1.0 : 0.0;
            }
        }
    }

    public static double convolution(double[][] pixelMatrix) {
        double gy = pixelMatrix[0][0] * -1.0 + pixelMatrix[0][1] * -2.0 + pixelMatrix[0][2] * -1.0 + pixelMatrix[2][0] + pixelMatrix[2][1] * 2.0 + pixelMatrix[2][2] * 1.0;
        double gx = pixelMatrix[0][0] + pixelMatrix[0][2] * -1.0 + pixelMatrix[1][0] * 2.0 + pixelMatrix[1][2] * -2.0 + pixelMatrix[2][0] + pixelMatrix[2][2] * -1.0;
        return Math.sqrt(Math.pow(gy, 2.0) + Math.pow(gx, 2.0));
    }

    public static double erosionConvolution(double[][] pixelMatrix) {
        double sum = 0.0;
        sum += pixelMatrix[0][0];
        sum += pixelMatrix[0][1];
        sum += pixelMatrix[0][2];
        sum += pixelMatrix[1][0];
        sum += pixelMatrix[1][1];
        sum += pixelMatrix[1][2];
        sum += pixelMatrix[2][0];
        sum += pixelMatrix[2][1];
        return sum += pixelMatrix[2][2];
    }

    public static double erosionConvolution2(double[][] pixelMatrix) {
        double sum = 0.0;
        sum += pixelMatrix[0][0];
        sum += pixelMatrix[0][2];
        sum += pixelMatrix[1][1];
        sum += pixelMatrix[2][0];
        return sum += pixelMatrix[2][2];
    }

    private Color getColor(double offset) {
        double lowerOffset = 0.0;
        double upperOffset = 1.0;
        Color lowerColor = Color.TRANSPARENT;
        Color upperColor = Color.TRANSPARENT;
        for (Stop stop : this.getColorGradient().getStops()) {
            double currentOffset = stop.getOffset();
            if (currentOffset == offset) {
                return stop.getColor();
            }
            if (currentOffset < offset) {
                lowerOffset = currentOffset;
                lowerColor = stop.getColor();
                continue;
            }
            upperOffset = currentOffset;
            upperColor = stop.getColor();
            break;
        }
        double interpolationOffset = (offset - lowerOffset) / (upperOffset - lowerOffset);
        return lowerColor.interpolate(upperColor, interpolationOffset);
    }

    public IntegerProperty quantisationLevelsProperty() {
        return this.quantisationLevels;
    }

    public ContourDataSetRenderer setNumberQuantisationLevels(int nQuantisation) {
        this.quantisationLevelsProperty().set(nQuantisation);
        return this;
    }

    public int getNumberQuantisationLevels() {
        return this.quantisationLevelsProperty().get();
    }

    public IntegerProperty minHexTileSizeProperty() {
        return this.minHexTileSize;
    }

    public ContourDataSetRenderer setMinHexTileSizeProperty(int minSize) {
        this.minHexTileSizeProperty().set(minSize);
        return this;
    }

    public int getMinHexTileSizeProperty() {
        return this.minHexTileSizeProperty().get();
    }

    public IntegerProperty maxContourSegmentsProperty() {
        return this.maxContourSegments;
    }

    public ContourDataSetRenderer setMaxContourSegments(int nSegments) {
        this.maxContourSegmentsProperty().set(nSegments);
        return this;
    }

    public int getMaxContourSegments() {
        return this.maxContourSegmentsProperty().get();
    }

    public ObjectProperty<ColorGradient> colorGradientProperty() {
        return this.colorGradient;
    }

    public void setColorGradient(ColorGradient value) {
        this.colorGradientProperty().set((Object)value);
    }

    public ColorGradient getColorGradient() {
        return (ColorGradient)this.colorGradientProperty().get();
    }

    public BooleanProperty smoothProperty() {
        return this.smooth;
    }

    public boolean isSmooth() {
        return this.smoothProperty().get();
    }

    public void setSmooth(boolean value) {
        this.smoothProperty().set(value);
    }

    public BooleanProperty computeLocalRangeProperty() {
        return this.computeLocalRange;
    }

    public boolean computeLocalRange() {
        return this.computeLocalRangeProperty().get();
    }

    public void setComputeLocalRange(boolean value) {
        this.computeLocalRangeProperty().set(value);
    }

    public ObjectProperty<ContourType> contourTypeProperty() {
        return this.contourType;
    }

    public ContourType getContourType() {
        return (ContourType)((Object)this.contourTypeProperty().get());
    }

    public void setContourType(ContourType value) {
        this.contourTypeProperty().set((Object)value);
    }

    protected void layoutZAxis(Axis zAxis, Cache lCache) {
        if (zAxis.getSide() == null || !(zAxis instanceof Node)) {
            return;
        }
        boolean isHorizontal = zAxis.getSide().isHorizontal();
        Node zAxisNode = (Node)zAxis;
        if (isHorizontal) {
            zAxisNode.setLayoutX(50.0);
            this.gradientRect.setX(0.0);
            this.gradientRect.setWidth(zAxis.getWidth());
            this.gradientRect.setHeight(20.0);
            zAxisNode.setLayoutX(0.0);
            this.gradientRect.setFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
            if (zAxisNode.getParent() == null || !(zAxisNode.getParent() instanceof VBox)) {
                return;
            }
            VBox parent = (VBox)zAxisNode.getParent();
            if (!parent.getChildren().contains((Object)this.gradientRect)) {
                parent.getChildren().add((Object)this.gradientRect);
            }
        } else {
            zAxisNode.setLayoutY(50.0);
            this.gradientRect.setWidth(20.0);
            this.gradientRect.setHeight(zAxis.getHeight());
            this.gradientRect.setFill((Paint)new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
            this.gradientRect.setLayoutX(10.0);
            if (zAxisNode.getParent() == null || !(zAxisNode.getParent() instanceof HBox)) {
                return;
            }
            HBox parent = (HBox)zAxisNode.getParent();
            if (!parent.getChildren().contains((Object)this.gradientRect)) {
                parent.getChildren().add(0, (Object)this.gradientRect);
            }
        }
        if (zAxis instanceof Region) {
            ((Region)zAxisNode).requestLayout();
        }
    }

    @Override
    public Canvas drawLegendSymbol(DataSet dataSet, int dsIndex, int width, int height) {
        return null;
    }

    private class Cache {
        protected DataSet3D dataSet3D;
        protected double xAxisWidth;
        protected double xMin;
        protected double xMax;
        protected int indexXMin;
        protected int indexXMax;
        protected double yAxisHeight;
        protected double yMin;
        protected double yMax;
        protected int indexYMin;
        protected int indexYMax;
        protected int xSize;
        protected int ySize;
        protected double zMin;
        protected double zMax;
        protected boolean zInverted;

        private Cache() {
        }
    }
}

