/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.spi;

import de.gsi.chart.renderer.spi.utils.ChartIconFactory;
import java.security.InvalidParameterException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public abstract class AbstractMetaDataRendererParameter<R extends AbstractMetaDataRendererParameter<R>> {
    protected static final String STYLE_CLASS_LABELLED_MARKER = "chart-meta-data";
    protected static final String DEFAULT_FONT = "Helvetia";
    protected static final int DEFAULT_FONT_SIZE = 18;
    protected static final Color DEFAULT_GRID_LINE_COLOR = Color.GREEN;
    protected static final double DEFAULT_GRID_LINE_WIDTH = 1.0;
    protected static final double[] DEFAULT_GRID_DASH_PATTERM = new double[]{3.0, 3.0};
    protected final StringProperty style = new SimpleStringProperty((Object)this, "style", null);
    protected Paint strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
    protected double strokeLineWidthMarker = 1.0;
    protected double[] strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
    protected Image imgIconInfo = ChartIconFactory.getInfoIcon();
    protected Image imgIconWarning = ChartIconFactory.getWarningIcon();
    protected Image imgIconError = ChartIconFactory.getErrorIcon();
    protected final DoubleProperty iconSize = new SimpleDoubleProperty(this, "drawOnPane", 10.0){

        public void set(double newSize) {
            if (newSize <= 0.0) {
                throw new InvalidParameterException("size should be >= 0, requested = " + newSize);
            }
            super.set(newSize);
            AbstractMetaDataRendererParameter.this.imgIconInfo = ChartIconFactory.getInfoIcon(newSize, newSize);
            AbstractMetaDataRendererParameter.this.imgIconWarning = ChartIconFactory.getWarningIcon(newSize, newSize);
            AbstractMetaDataRendererParameter.this.imgIconError = ChartIconFactory.getErrorIcon(newSize, newSize);
        }
    };
    protected final BooleanProperty showInfoMessages = new SimpleBooleanProperty((Object)this, "showInfoMessages", true);
    protected final BooleanProperty showWarningMessages = new SimpleBooleanProperty((Object)this, "showWarningMessages", true);
    protected final BooleanProperty showErrorMessages = new SimpleBooleanProperty((Object)this, "showErrorMessages", true);

    protected abstract R getThis();

    public boolean isShowInfoMessages() {
        return this.showInfoMessages.get();
    }

    public void setshowInfoMessages(boolean state) {
        this.showInfoMessages.set(state);
    }

    public BooleanProperty showInfoMessagesProperty() {
        return this.showInfoMessages;
    }

    public boolean isShowWarningMessages() {
        return this.showWarningMessages.get();
    }

    public void setshowWarningMessages(boolean state) {
        this.showWarningMessages.set(state);
    }

    public BooleanProperty showWarningMessagesProperty() {
        return this.showWarningMessages;
    }

    public boolean isShowErrorMessages() {
        return this.showErrorMessages.get();
    }

    public void setshowErrorMessages(boolean state) {
        this.showErrorMessages.set(state);
    }

    public BooleanProperty showErrorMessagesProperty() {
        return this.showErrorMessages;
    }

    public StringProperty styleProperty() {
        return this.style;
    }

    public String getStyle() {
        return (String)this.style.get();
    }

    public R setStyle(String newStyle) {
        this.style.set((Object)newStyle);
        return this.getThis();
    }

    public final R updateCSS() {
        this.strokeColorMarker = DEFAULT_GRID_LINE_COLOR;
        this.strokeLineWidthMarker = 1.0;
        this.strokeDashPattern = DEFAULT_GRID_DASH_PATTERM;
        if (this.getStyle() != null) {
            // empty if block
        }
        return this.getThis();
    }
}

