/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.renderer.datareduction;

import de.gsi.chart.renderer.RendererDataReducer;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.ProcessingProfiler;
import java.security.InvalidParameterException;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class DefaultDataReducer
implements RendererDataReducer {
    protected IntegerProperty minPointPixelDistance = new SimpleIntegerProperty(this, "minPixelDistance", 6){

        public void set(int value) {
            if (value < 0) {
                throw new InvalidParameterException("minPointPixelDistance " + value + " must be greater than zero");
            }
            super.set(value);
        }
    };

    public final int getMinPointPixelDistance() {
        return this.minPointPixelDistanceProperty().get();
    }

    public final void setMinPointPixelDistance(int minPixelDistance) {
        this.minPointPixelDistanceProperty().setValue((Number)minPixelDistance);
    }

    public final IntegerProperty minPointPixelDistanceProperty() {
        return this.minPointPixelDistance;
    }

    @Override
    public int reducePoints(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        boolean yErrorNeg;
        AssertUtils.nonEmptyArray((String)"xValues", (double[])xValues);
        int defaultDataLength = xValues.length;
        AssertUtils.checkArrayDimension((String)"yValues", (double[])yValues, (int)defaultDataLength);
        AssertUtils.checkArrayDimension((String)"pointSelected", (boolean[])pointSelected, (int)defaultDataLength);
        AssertUtils.gtEqThanZero((String)"indexMax", (int)indexMin);
        AssertUtils.gtThanZero((String)"indexMax", (int)indexMax);
        boolean xErrorPos = xPointErrorsPos != null;
        boolean xErrorNeg = xPointErrorsNeg != null;
        boolean yErrorPos = yPointErrorsPos != null;
        boolean bl = yErrorNeg = yPointErrorsNeg != null;
        if (xErrorPos && xErrorNeg && yErrorPos && yErrorNeg) {
            AssertUtils.checkArrayDimension((String)"xPointErrorsPos", (double[])xPointErrorsPos, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"xPointErrorsNeg", (double[])xPointErrorsNeg, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"yPointErrorsPos", (double[])yPointErrorsPos, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"yPointErrorsNeg", (double[])yPointErrorsNeg, (int)defaultDataLength);
            return this.reducePointsInternal(xValues, yValues, xPointErrorsPos, xPointErrorsNeg, yPointErrorsPos, yPointErrorsNeg, styles, pointSelected, indexMin, indexMax);
        }
        if (yErrorPos && yErrorNeg) {
            AssertUtils.checkArrayDimension((String)"yPointErrorsPos", (double[])yPointErrorsPos, (int)defaultDataLength);
            AssertUtils.checkArrayDimension((String)"yPointErrorsNeg", (double[])yPointErrorsNeg, (int)defaultDataLength);
            return this.reducePointsInternal(xValues, yValues, yPointErrorsPos, yPointErrorsNeg, styles, pointSelected, indexMin, indexMax);
        }
        return this.reducePointsInternal(xValues, yValues, styles, pointSelected, indexMin, indexMax);
    }

    private int reducePointsInternal(double[] xValues, double[] yValues, double[] xPointErrorsPos, double[] xPointErrorsNeg, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        long start = ProcessingProfiler.getTimeStamp();
        int count = 0;
        int ncount = 0;
        double meanX = 0.0;
        double meanY = 0.0;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        int minX = Integer.MAX_VALUE;
        int maxX = -2147483647;
        String style = null;
        boolean sel = false;
        double xold = xValues[indexMin];
        double yold = yValues[indexMin];
        int minPixelDistance = this.getMinPointPixelDistance();
        xValues[count] = xValues[indexMin];
        yValues[count] = yValues[indexMin];
        xPointErrorsNeg[count] = xPointErrorsNeg[indexMin];
        xPointErrorsPos[count] = xPointErrorsPos[indexMin];
        yPointErrorsNeg[count] = yPointErrorsNeg[indexMin];
        yPointErrorsPos[count] = yPointErrorsPos[indexMin];
        pointSelected[count] = pointSelected[indexMin];
        styles[count] = styles[indexMin];
        ++count;
        for (int i = indexMin + 1; i < indexMax - 1; ++i) {
            double newXValue = xValues[i];
            double newYValue = yValues[i];
            int differenceInX = (int)Math.abs(xold - newXValue);
            int differenceInY = (int)Math.abs(yold - newYValue);
            if (differenceInX > minPixelDistance || differenceInY > minPixelDistance) {
                if (ncount == 0) {
                    xValues[count] = newXValue;
                    yValues[count] = newYValue;
                    xPointErrorsNeg[count] = xPointErrorsNeg[i];
                    xPointErrorsPos[count] = xPointErrorsPos[i];
                    yPointErrorsNeg[count] = yPointErrorsNeg[i];
                    yPointErrorsPos[count] = yPointErrorsPos[i];
                    pointSelected[count] = pointSelected[i];
                    styles[count] = styles[i];
                    xold = xValues[count];
                    yold = yValues[count];
                    meanX = 0.0;
                    meanY = 0.0;
                    minY = Integer.MAX_VALUE;
                    maxY = -2147483647;
                    minX = Integer.MAX_VALUE;
                    maxX = -2147483647;
                    sel = false;
                    ncount = 0;
                    ++count;
                    continue;
                }
                meanX += newXValue;
                meanY += newYValue;
                minX = Math.min(minX, (int)xPointErrorsPos[i]);
                maxX = Math.max(maxX, (int)xPointErrorsNeg[i]);
                minY = Math.min(minY, (int)yPointErrorsPos[i]);
                maxY = Math.max(maxY, (int)yPointErrorsNeg[i]);
                sel |= pointSelected[i];
                style = styles[i];
                xValues[count] = (int)(meanX / (double)(++ncount));
                yValues[count] = (int)(meanY / (double)ncount);
                xPointErrorsNeg[count] = minX;
                xPointErrorsPos[count] = maxX;
                yPointErrorsNeg[count] = maxY;
                yPointErrorsPos[count] = minY;
                pointSelected[count] = sel;
                styles[count] = style;
                xold = xValues[count];
                yold = yValues[count];
                ++count;
                meanX = 0.0;
                meanY = 0.0;
                minY = Integer.MAX_VALUE;
                maxY = -2147483647;
                minX = Integer.MAX_VALUE;
                maxX = -2147483647;
                sel = false;
                ncount = 0;
                continue;
            }
            meanX += newXValue;
            meanY += newYValue;
            minY = Math.min(minY, (int)yPointErrorsPos[i]);
            maxY = Math.max(maxY, (int)yPointErrorsNeg[i]);
            minX = Math.min(minX, (int)xPointErrorsPos[i]);
            maxX = Math.max(maxX, (int)xPointErrorsNeg[i]);
            sel |= pointSelected[i];
            ++ncount;
        }
        minX = Math.min(minX, (int)xPointErrorsPos[indexMax - 1]);
        maxX = Math.max(maxX, (int)xPointErrorsNeg[indexMax - 1]);
        minY = Math.min(minY, (int)yPointErrorsPos[indexMax - 1]);
        maxY = Math.max(maxY, (int)yPointErrorsNeg[indexMax - 1]);
        xValues[count] = xValues[indexMax - 1];
        yValues[count] = yValues[indexMax - 1];
        xPointErrorsNeg[count] = minX;
        xPointErrorsPos[count] = maxX;
        yPointErrorsNeg[count] = minY;
        yPointErrorsPos[count] = maxY;
        pointSelected[count] = pointSelected[indexMax - 1];
        styles[count] = styles[indexMax - 1];
        ProcessingProfiler.getTimeDiff((long)start, (String)String.format("data reduction (from %d to %d)", indexMax - indexMin, ++count));
        return count;
    }

    private int reducePointsInternal(double[] xValues, double[] yValues, double[] yPointErrorsPos, double[] yPointErrorsNeg, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        long start = ProcessingProfiler.getTimeStamp();
        int count = 0;
        int ncount = 0;
        double meanX = 0.0;
        double meanY = 0.0;
        int minY = Integer.MAX_VALUE;
        int maxY = -2147483647;
        String style = null;
        boolean sel = false;
        double xold = xValues[indexMin];
        double yold = yValues[indexMin];
        int minPixelDistance = this.getMinPointPixelDistance();
        xValues[count] = xValues[indexMin];
        yValues[count] = yValues[indexMin];
        yPointErrorsNeg[count] = yPointErrorsNeg[indexMin];
        yPointErrorsPos[count] = yPointErrorsPos[indexMin];
        pointSelected[count] = pointSelected[indexMin];
        styles[count] = styles[indexMin];
        ++count;
        for (int i = indexMin + 1; i < indexMax - 1; ++i) {
            double newXValue = xValues[i];
            double newYValue = yValues[i];
            int differenceInX = (int)Math.abs(xold - newXValue);
            int differenceInY = (int)Math.abs(yold - newYValue);
            if (differenceInX > minPixelDistance || differenceInY > minPixelDistance) {
                if (ncount == 0) {
                    xValues[count] = newXValue;
                    yValues[count] = newYValue;
                    yPointErrorsNeg[count] = yPointErrorsNeg[i];
                    yPointErrorsPos[count] = yPointErrorsPos[i];
                    pointSelected[count] = pointSelected[i];
                    styles[count] = styles[i];
                    xold = xValues[count];
                    yold = yValues[count];
                    meanX = 0.0;
                    meanY = 0.0;
                    minY = Integer.MAX_VALUE;
                    maxY = -2147483647;
                    sel = false;
                    ncount = 0;
                    ++count;
                    continue;
                }
                meanX += newXValue;
                meanY += newYValue;
                minY = Math.min(minY, (int)yPointErrorsPos[i]);
                maxY = Math.max(maxY, (int)yPointErrorsNeg[i]);
                sel |= pointSelected[i];
                style = styles[i];
                xValues[count] = (int)(meanX / (double)(++ncount));
                yValues[count] = (int)(meanY / (double)ncount);
                yPointErrorsNeg[count] = maxY;
                yPointErrorsPos[count] = minY;
                pointSelected[count] = sel;
                styles[count] = style;
                xold = xValues[count];
                yold = yValues[count];
                ++count;
                meanX = 0.0;
                meanY = 0.0;
                minY = Integer.MAX_VALUE;
                maxY = -2147483647;
                sel = false;
                ncount = 0;
                continue;
            }
            meanX += newXValue;
            meanY += newYValue;
            minY = Math.min(minY, (int)yPointErrorsNeg[i]);
            maxY = Math.max(maxY, (int)yPointErrorsPos[i]);
            sel |= pointSelected[i];
            style = styles[i];
            ++ncount;
        }
        minY = Math.min(minY, (int)yPointErrorsPos[indexMax - 1]);
        maxY = Math.max(maxY, (int)yPointErrorsNeg[indexMax - 1]);
        xValues[count] = xValues[indexMax - 1];
        yValues[count] = yValues[indexMax - 1];
        yPointErrorsNeg[count] = minY;
        yPointErrorsPos[count] = maxY;
        pointSelected[count] = pointSelected[indexMax - 1];
        styles[count] = styles[indexMax - 1];
        ProcessingProfiler.getTimeDiff((long)start, (String)String.format("data reduction (from %d to %d)", indexMax - indexMin, ++count));
        return count;
    }

    private int reducePointsInternal(double[] xValues, double[] yValues, String[] styles, boolean[] pointSelected, int indexMin, int indexMax) {
        long start = ProcessingProfiler.getTimeStamp();
        int count = 0;
        int ncount = 0;
        double meanX = 0.0;
        double meanY = 0.0;
        String style = null;
        boolean sel = false;
        double xold = xValues[indexMin];
        double yold = yValues[indexMin];
        int minPixelDistance = this.getMinPointPixelDistance();
        xValues[count] = xValues[indexMin];
        yValues[count] = yValues[indexMin];
        pointSelected[count] = pointSelected[indexMin];
        styles[count] = styles[indexMin];
        ++count;
        for (int i = indexMin + 1; i < indexMax - 1; ++i) {
            double newXValue = xValues[i];
            double newYValue = yValues[i];
            int differenceInX = (int)Math.abs(xold - newXValue);
            int differenceInY = (int)Math.abs(yold - newYValue);
            if (differenceInX > minPixelDistance || differenceInY > minPixelDistance) {
                if (ncount == 0) {
                    xValues[count] = newXValue;
                    yValues[count] = newYValue;
                    pointSelected[count] = pointSelected[i];
                    styles[count] = styles[i];
                    xold = xValues[count];
                    yold = yValues[count];
                    meanX = 0.0;
                    meanY = 0.0;
                    sel = false;
                    ncount = 0;
                    ++count;
                    continue;
                }
                style = styles[i];
                xValues[count] = (int)((meanX += newXValue) / (double)(++ncount));
                yValues[count] = (int)((meanY += newYValue) / (double)ncount);
                pointSelected[count] = sel |= pointSelected[i];
                styles[count] = style;
                xold = xValues[count];
                yold = yValues[count];
                ++count;
                meanX = 0.0;
                meanY = 0.0;
                sel = false;
                ncount = 0;
                continue;
            }
            meanX += newXValue;
            meanY += newYValue;
            sel |= pointSelected[i];
            ++ncount;
        }
        xValues[count] = xValues[indexMax - 1];
        yValues[count] = yValues[indexMax - 1];
        pointSelected[count] = pointSelected[indexMax - 1];
        styles[count] = styles[indexMax - 1];
        ProcessingProfiler.getTimeDiff((long)start, (String)String.format("data reduction (from %d to %d)", indexMax - indexMin, ++count));
        return count;
    }
}

