/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.Axes;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.MouseEventsHelper;
import de.gsi.dataset.spi.utils.Tuple;
import java.security.InvalidParameterException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Button;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.controlsfx.control.RangeSlider;
import org.controlsfx.glyphfont.Glyph;

public class Zoomer
extends ChartPlugin {
    private static final String FONT_AWESOME = "FontAwesome";
    public static final String STYLE_CLASS_ZOOM_RECT = "chart-zoom-rect";
    private static final int ZOOM_RECT_MIN_SIZE = 5;
    private static final Duration DEFAULT_ZOOM_DURATION = Duration.millis((double)500.0);
    private static final int FONT_SIZE = 20;
    public final Predicate<MouseEvent> defaultZoomInMouseFilter = event -> MouseEventsHelper.isOnlyPrimaryButtonDown(event) && MouseEventsHelper.modifierKeysUp(event) && this.isMouseEventWithinCanvas((MouseEvent)event);
    public final Predicate<MouseEvent> defaultZoomOutMouseFilter = event -> MouseEventsHelper.isOnlySecondaryButtonDown(event) && MouseEventsHelper.modifierKeysUp(event) && this.isMouseEventWithinCanvas((MouseEvent)event);
    public final Predicate<MouseEvent> defaultZoomOriginFilter = event -> MouseEventsHelper.isOnlySecondaryButtonDown(event) && MouseEventsHelper.isOnlyCtrlModifierDown(event) && this.isMouseEventWithinCanvas((MouseEvent)event);
    public final Predicate<ScrollEvent> defaultScrollFilter = event -> this.isMouseEventWithinCanvas((ScrollEvent)event);
    private Predicate<MouseEvent> zoomInMouseFilter = this.defaultZoomInMouseFilter;
    private Predicate<MouseEvent> zoomOutMouseFilter = this.defaultZoomOutMouseFilter;
    private Predicate<MouseEvent> zoomOriginMouseFilter = this.defaultZoomOriginFilter;
    private Predicate<ScrollEvent> zoomScrollFilter = this.defaultScrollFilter;
    private final Rectangle zoomRectangle = new Rectangle();
    private Point2D zoomStartPoint = null;
    private Point2D zoomEndPoint = null;
    private final Deque<ZoomState> zoomStacks = new ArrayDeque<ZoomState>();
    private final HBox zoomButtons = this.getZoomInteractorBar();
    private ZoomRangeSlider xRangeSlider;
    private boolean xRangeSliderInit;
    private final ObjectProperty<AxisMode> axisMode = new SimpleObjectProperty<AxisMode>((Object)this, "axisMode", AxisMode.XY){

        protected void invalidated() {
            Objects.requireNonNull((AxisMode)((Object)this.get()), "The " + this.getName() + " must not be null");
        }
    };
    private Cursor originalCursor;
    private final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor");
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    private final ObjectProperty<Duration> zoomDuration = new SimpleObjectProperty<Duration>((Object)this, "zoomDuration", DEFAULT_ZOOM_DURATION){

        protected void invalidated() {
            Objects.requireNonNull((Duration)this.get(), "The " + this.getName() + " must not be null");
        }
    };
    private final BooleanProperty updateTickUnit = new SimpleBooleanProperty((Object)this, "updateTickUnit", true);
    private final BooleanProperty sliderVisible = new SimpleBooleanProperty((Object)this, "sliderVisible", true);
    private final EventHandler<MouseEvent> zoomInStartHandler = event -> {
        if (this.getZoomInMouseFilter() == null || this.getZoomInMouseFilter().test((MouseEvent)event)) {
            this.zoomInStarted((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomInDragHandler = event -> {
        if (this.zoomOngoing()) {
            this.zoomInDragged((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomInEndHandler = event -> {
        if (this.zoomOngoing()) {
            this.zoomInEnded();
            event.consume();
        }
    };
    private final EventHandler<ScrollEvent> zoomScrollHandler = event -> {
        if (this.getZoomScrollFilter() == null || this.getZoomScrollFilter().test((ScrollEvent)event)) {
            AxisMode mode = this.getAxisMode();
            if (this.zoomStacks.isEmpty()) {
                this.makeSnapshotOfView();
            }
            for (Axis axis : this.getChart().getAxes()) {
                if (axis.getSide() == null) continue;
                if (axis.getSide().isHorizontal()) {
                    if (!mode.allowsX()) continue;
                } else if (!mode.allowsY()) continue;
                Zoomer.zoomOnAxis(axis, event);
            }
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomOutHandler = event -> {
        boolean zoomOutPerformed;
        if ((this.getZoomOutMouseFilter() == null || this.getZoomOutMouseFilter().test((MouseEvent)event)) && (zoomOutPerformed = this.zoomOut())) {
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> zoomOriginHandler = event -> {
        boolean zoomOutPerformed;
        if ((this.getZoomOriginMouseFilter() == null || this.getZoomOriginMouseFilter().test((MouseEvent)event)) && (zoomOutPerformed = this.zoomOrigin())) {
            event.consume();
        }
    };

    public Zoomer() {
        this(AxisMode.XY);
    }

    public Zoomer(AxisMode zoomMode) {
        this(zoomMode, false);
    }

    public Zoomer(boolean animated) {
        this(AxisMode.XY, animated);
    }

    public Zoomer(AxisMode zoomMode, boolean animated) {
        this.setAxisMode(zoomMode);
        this.setAnimated(animated);
        this.setDragCursor(Cursor.CROSSHAIR);
        this.zoomRectangle.setManaged(false);
        this.zoomRectangle.getStyleClass().add((Object)STYLE_CLASS_ZOOM_RECT);
        this.getChartChildren().add((Object)this.zoomRectangle);
        this.registerMouseHandlers();
        this.chartProperty().addListener((change, o, n) -> {
            if (o != null) {
                o.getToolBar().getChildren().remove((Object)this.zoomButtons);
                o.getPlotArea().setBottom(null);
                this.xRangeSlider.prefWidthProperty().unbind();
            }
            if (n != null) {
                if (this.isAddButtonsToToolBar()) {
                    n.getToolBar().getChildren().add((Object)this.zoomButtons);
                }
                ZoomRangeSlider slider = new ZoomRangeSlider((Chart)((Object)n));
                if (this.isSliderVisible()) {
                    n.getPlotArea().setBottom((Node)slider);
                    this.xRangeSlider.prefWidthProperty().bind((ObservableValue)n.getCanvasForeground().widthProperty());
                }
            }
        });
    }

    private void registerMouseHandlers() {
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_PRESSED, this.zoomInStartHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_DRAGGED, this.zoomInDragHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_RELEASED, this.zoomInEndHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_CLICKED, this.zoomOutHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_CLICKED, this.zoomOriginHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)ScrollEvent.SCROLL, this.zoomScrollHandler);
    }

    public HBox getZoomInteractorBar() {
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        HBox buttonBar = new HBox();
        buttonBar.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        Button zoomOut = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf0b2").size(20.0));
        zoomOut.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomOut.setTooltip(new Tooltip("zooms to origin and enables auto-ranging"));
        Button zoomModeXY = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf047").size(20.0));
        zoomModeXY.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomModeXY.setTooltip(new Tooltip("set zoom-mode to X & Y range (N.B. disables auto-ranging)"));
        Button zoomModeX = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf07e").size(20.0));
        zoomModeX.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomModeX.setTooltip(new Tooltip("set zoom-mode to X range (N.B. disables auto-ranging)"));
        Button zoomModeY = new Button(null, (Node)new Glyph(FONT_AWESOME, (Object)"\uf07d").size(20.0));
        zoomModeY.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        zoomModeY.setTooltip(new Tooltip("set zoom-mode to Y range (N.B. disables auto-ranging)"));
        zoomOut.setOnAction(evt -> {
            this.zoomOrigin();
            for (Axis axis : this.getChart().getAxes()) {
                axis.setAutoRanging(true);
            }
        });
        zoomModeXY.setOnAction(evt -> this.setAxisMode(AxisMode.XY));
        zoomModeX.setOnAction(evt -> this.setAxisMode(AxisMode.X));
        zoomModeY.setOnAction(evt -> this.setAxisMode(AxisMode.Y));
        buttonBar.getChildren().addAll((Object[])new Node[]{separator, zoomOut, zoomModeXY, zoomModeX, zoomModeY});
        return buttonBar;
    }

    public Predicate<MouseEvent> getZoomInMouseFilter() {
        return this.zoomInMouseFilter;
    }

    public void setZoomInMouseFilter(Predicate<MouseEvent> zoomInMouseFilter) {
        this.zoomInMouseFilter = zoomInMouseFilter;
    }

    public Predicate<MouseEvent> getZoomOutMouseFilter() {
        return this.zoomOutMouseFilter;
    }

    public void setZoomOutMouseFilter(Predicate<MouseEvent> zoomOutMouseFilter) {
        this.zoomOutMouseFilter = zoomOutMouseFilter;
    }

    public Predicate<MouseEvent> getZoomOriginMouseFilter() {
        return this.zoomOriginMouseFilter;
    }

    public void setZoomOriginMouseFilter(Predicate<MouseEvent> zoomOriginMouseFilter) {
        this.zoomOriginMouseFilter = zoomOriginMouseFilter;
    }

    public Predicate<ScrollEvent> getZoomScrollFilter() {
        return this.zoomScrollFilter;
    }

    public void setZoomScrollFilter(Predicate<ScrollEvent> zoomScrollFilter) {
        this.zoomScrollFilter = zoomScrollFilter;
    }

    public final ObjectProperty<AxisMode> axisModeProperty() {
        return this.axisMode;
    }

    public final void setAxisMode(AxisMode mode) {
        this.axisModeProperty().set((Object)mode);
    }

    public final AxisMode getAxisMode() {
        return (AxisMode)((Object)this.axisModeProperty().get());
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    private void installCursor() {
        Chart chart = this.getChart();
        this.originalCursor = chart.getCursor();
        if (this.getDragCursor() != null) {
            chart.setCursor(this.getDragCursor());
        }
    }

    private void uninstallCursor() {
        this.getChart().setCursor(this.originalCursor);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final void setAnimated(boolean value) {
        this.animatedProperty().set(value);
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final ObjectProperty<Duration> zoomDurationProperty() {
        return this.zoomDuration;
    }

    public final void setZoomDuration(Duration duration) {
        this.zoomDurationProperty().set((Object)duration);
    }

    public final Duration getZoomDuration() {
        return (Duration)this.zoomDurationProperty().get();
    }

    public final BooleanProperty updateTickUnitProperty() {
        return this.updateTickUnit;
    }

    public final void setUpdateTickUnit(boolean value) {
        this.updateTickUnitProperty().set(value);
    }

    public final boolean isUpdateTickUnit() {
        return this.updateTickUnitProperty().get();
    }

    private boolean isMouseEventWithinCanvas(MouseEvent mouseEvent) {
        Canvas canvas = this.getChart().getCanvas();
        Point2D mouseLoc = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
        Bounds screenBounds = canvas.localToScreen(canvas.getBoundsInLocal());
        return screenBounds.contains(mouseLoc);
    }

    private boolean isMouseEventWithinCanvas(ScrollEvent mouseEvent) {
        Canvas canvas = this.getChart().getCanvas();
        Point2D mouseLoc = new Point2D(mouseEvent.getScreenX(), mouseEvent.getScreenY());
        Bounds screenBounds = canvas.localToScreen(canvas.getBoundsInLocal());
        return screenBounds.contains(mouseLoc);
    }

    public RangeSlider getRangeSlider() {
        return this.xRangeSlider;
    }

    public final BooleanProperty sliderVisibleProperty() {
        return this.sliderVisible;
    }

    public final void setSliderVisible(boolean state) {
        this.sliderVisibleProperty().set(state);
    }

    public final boolean isSliderVisible() {
        return this.sliderVisibleProperty().get();
    }

    private static void zoomOnAxis(Axis axis, ScrollEvent event) {
        if (axis.lowerBoundProperty().isBound() || axis.upperBoundProperty().isBound()) {
            return;
        }
        boolean isZoomIn = event.getDeltaY() > 0.0;
        boolean isHorizontal = axis.getSide().isHorizontal();
        double mousePos = isHorizontal ? event.getX() : event.getY();
        double posOnAxis = axis.getValueForDisplay(mousePos);
        double max = axis.getUpperBound();
        double min = axis.getLowerBound();
        Math.abs(max - min);
        double scaling = isZoomIn ? 0.9 : 1.1111111111111112;
        double diffHalf1 = scaling * Math.abs(posOnAxis - min);
        double diffHalf2 = scaling * Math.abs(max - posOnAxis);
        axis.setLowerBound(posOnAxis - diffHalf1);
        axis.setUpperBound(posOnAxis + diffHalf2);
        if (axis instanceof AbstractAxis) {
            axis.setTickUnit(((AbstractAxis)axis).computePreferredTickUnit(axis.getSide().isHorizontal() ? axis.getWidth() : axis.getHeight()));
        }
        axis.forceRedraw();
    }

    private boolean zoomOngoing() {
        return this.zoomStartPoint != null;
    }

    private void zoomInStarted(MouseEvent event) {
        this.zoomStartPoint = new Point2D(event.getX(), event.getY());
        this.zoomRectangle.setX(this.zoomStartPoint.getX());
        this.zoomRectangle.setY(this.zoomStartPoint.getY());
        this.zoomRectangle.setWidth(0.0);
        this.zoomRectangle.setHeight(0.0);
        this.zoomRectangle.setVisible(true);
        this.installCursor();
    }

    private void zoomInDragged(MouseEvent event) {
        Bounds plotAreaBounds = this.getChart().getPlotArea().getBoundsInLocal();
        this.zoomEndPoint = this.limitToPlotArea(event, plotAreaBounds);
        double zoomRectX = plotAreaBounds.getMinX();
        double zoomRectY = plotAreaBounds.getMinY();
        double zoomRectWidth = plotAreaBounds.getWidth();
        double zoomRectHeight = plotAreaBounds.getHeight();
        if (this.getAxisMode().allowsX()) {
            zoomRectX = Math.min(this.zoomStartPoint.getX(), this.zoomEndPoint.getX());
            zoomRectWidth = Math.abs(this.zoomEndPoint.getX() - this.zoomStartPoint.getX());
        }
        if (this.getAxisMode().allowsY()) {
            zoomRectY = Math.min(this.zoomStartPoint.getY(), this.zoomEndPoint.getY());
            zoomRectHeight = Math.abs(this.zoomEndPoint.getY() - this.zoomStartPoint.getY());
        }
        this.zoomRectangle.setX(zoomRectX);
        this.zoomRectangle.setY(zoomRectY);
        this.zoomRectangle.setWidth(zoomRectWidth);
        this.zoomRectangle.setHeight(zoomRectHeight);
    }

    private Point2D limitToPlotArea(MouseEvent event, Bounds plotBounds) {
        double limitedX = Math.max(Math.min(event.getX() - plotBounds.getMinX(), plotBounds.getMaxX()), plotBounds.getMinX());
        double limitedY = Math.max(Math.min(event.getY() - plotBounds.getMinY(), plotBounds.getMaxY()), plotBounds.getMinY());
        return new Point2D(limitedX, limitedY);
    }

    private void zoomInEnded() {
        this.zoomRectangle.setVisible(false);
        if (this.zoomRectangle.getWidth() > 5.0 && this.zoomRectangle.getHeight() > 5.0) {
            this.performZoomIn();
        }
        this.zoomEndPoint = null;
        this.zoomStartPoint = null;
        this.uninstallCursor();
    }

    private void performZoomIn() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        this.pushCurrentZoomWindows();
        this.performZoom(this.getZoomDataWindows(), true);
    }

    private void pushCurrentZoomWindows() {
        this.pushCurrentZoomWindow(this.getChart());
    }

    private void pushCurrentZoomWindow(Chart chart) {
        if (!(chart instanceof XYChart)) {
            return;
        }
        XYChart xyChart = (XYChart)chart;
        if (!(xyChart.getXAxis() instanceof Axis) || !(xyChart.getYAxis() instanceof Axis)) {
            throw new InvalidParameterException("non-Number chart axis not yet implemented in zoomer");
        }
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        Rectangle2D zoomRect = new Rectangle2D(xAxis.getLowerBound(), yAxis.getLowerBound(), Math.abs(xAxis.getUpperBound() - xAxis.getLowerBound()), Math.abs(yAxis.getUpperBound() - yAxis.getLowerBound()));
        boolean autoRangingX = xAxis.isAutoRanging();
        boolean autoRangingY = yAxis.isAutoRanging();
        boolean autoGrowX = xAxis.isAutoGrowRanging();
        boolean autoGrowY = yAxis.isAutoGrowRanging();
        ZoomState zoomState = new ZoomState(zoomRect, autoRangingX, autoRangingY, autoGrowX, autoGrowY);
        this.zoomStacks.addFirst(zoomState);
    }

    private Map<Chart, ZoomState> getZoomDataWindows() {
        ConcurrentHashMap<Chart, ZoomState> zoomWindows = new ConcurrentHashMap<Chart, ZoomState>();
        zoomWindows.put(this.getChart(), this.getZoomDataWindow(this.getChart()));
        return zoomWindows;
    }

    private ZoomState getZoomDataWindow(Chart chart) {
        if (!(chart instanceof XYChart)) {
            return null;
        }
        XYChart xyChart = (XYChart)chart;
        double minX = this.zoomRectangle.getX();
        double minY = this.zoomRectangle.getY() + this.zoomRectangle.getHeight();
        double maxX = this.zoomRectangle.getX() + this.zoomRectangle.getWidth();
        double maxY = this.zoomRectangle.getY();
        Tuple<Number, Number> dataMin = this.toDataPoint(xyChart.getYAxis(), this.getChart().toPlotArea(minX, minY));
        Tuple<Number, Number> dataMax = this.toDataPoint(xyChart.getYAxis(), this.getChart().toPlotArea(maxX, maxY));
        Axis numericAxisX = xyChart.getXAxis();
        Axis numericAxisY = xyChart.getYAxis();
        double dataMinX = ((Number)dataMin.getXValue()).doubleValue();
        double dataMaxX = ((Number)dataMax.getXValue()).doubleValue();
        double dataMinY = ((Number)dataMin.getYValue()).doubleValue();
        double dataMaxY = ((Number)dataMax.getYValue()).doubleValue();
        double dataRectWidth = Math.abs(dataMaxX - dataMinX);
        double dataRectHeight = Math.abs(dataMaxY - dataMinY);
        boolean autoRangingX = numericAxisX.isAutoRanging();
        boolean autoRangingY = numericAxisY.isAutoRanging();
        boolean autoGrowX = numericAxisX.isAutoGrowRanging();
        boolean autoGrowY = numericAxisY.isAutoGrowRanging();
        return new ZoomState(new Rectangle2D(dataMinX, dataMinY, dataRectWidth, dataRectHeight), autoRangingX, autoRangingY, autoGrowX, autoGrowY);
    }

    private void makeSnapshotOfView() {
        Bounds bounds = this.getChart().getBoundsInLocal();
        double minX = bounds.getMinX();
        double minY = bounds.getMinY();
        double maxX = bounds.getMaxX();
        double maxY = bounds.getMaxY();
        this.zoomRectangle.setX(bounds.getMinX());
        this.zoomRectangle.setY(bounds.getMinY());
        this.zoomRectangle.setWidth(maxX - minX);
        this.zoomRectangle.setHeight(maxY - minY);
        this.pushCurrentZoomWindows();
        this.performZoom(this.getZoomDataWindows(), true);
        this.zoomRectangle.setVisible(false);
    }

    private void performZoom(Map<Chart, ZoomState> zoomWindows, boolean isZoomIn) {
        for (Map.Entry<Chart, ZoomState> entry : zoomWindows.entrySet()) {
            this.performZoom(entry.getKey(), entry.getValue(), isZoomIn);
        }
        for (Axis a : this.getChart().getAxes()) {
            a.forceRedraw();
        }
    }

    private void performZoom(Chart chart, ZoomState zoomState, boolean isZoomIn) {
        if (!(chart instanceof XYChart)) {
            return;
        }
        XYChart xyChart = (XYChart)chart;
        if (!(xyChart.getXAxis() instanceof Axis) || !(xyChart.getYAxis() instanceof Axis)) {
            throw new InvalidParameterException("non-Number chart axis not yet implemented in zoomer");
        }
        Axis xAxis = xyChart.getXAxis();
        Axis yAxis = xyChart.getYAxis();
        if (isZoomIn) {
            if (this.getAxisMode().allowsX()) {
                xAxis.setAutoRanging(false);
                xAxis.setAutoGrowRanging(false);
            }
            if (this.getAxisMode().allowsY()) {
                yAxis.setAutoRanging(false);
                yAxis.setAutoGrowRanging(false);
            }
        }
        Rectangle2D zoomWindow = zoomState.zoomRectangle;
        if (this.isAnimated()) {
            if (!Axes.hasBoundedRange(xAxis)) {
                Timeline xZoomAnimation = new Timeline();
                xZoomAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)xAxis.lowerBoundProperty(), (Object)xAxis.getLowerBound()), new KeyValue((WritableValue)xAxis.upperBoundProperty(), (Object)xAxis.getUpperBound())}), new KeyFrame(this.getZoomDuration(), new KeyValue[]{new KeyValue((WritableValue)xAxis.lowerBoundProperty(), (Object)zoomWindow.getMinX()), new KeyValue((WritableValue)xAxis.upperBoundProperty(), (Object)zoomWindow.getMaxX())})});
                xZoomAnimation.play();
            }
            if (!Axes.hasBoundedRange(yAxis)) {
                Timeline yZoomAnimation = new Timeline();
                yZoomAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)yAxis.lowerBoundProperty(), (Object)yAxis.getLowerBound()), new KeyValue((WritableValue)yAxis.upperBoundProperty(), (Object)yAxis.getUpperBound())}), new KeyFrame(this.getZoomDuration(), new KeyValue[]{new KeyValue((WritableValue)yAxis.lowerBoundProperty(), (Object)zoomWindow.getMinY()), new KeyValue((WritableValue)yAxis.upperBoundProperty(), (Object)zoomWindow.getMaxY())})});
                yZoomAnimation.play();
            }
        } else {
            if (!Axes.hasBoundedRange(xAxis)) {
                xAxis.setLowerBound(zoomWindow.getMinX());
                xAxis.setUpperBound(zoomWindow.getMaxX());
            }
            if (!Axes.hasBoundedRange(yAxis)) {
                yAxis.setLowerBound(zoomWindow.getMinY());
                yAxis.setUpperBound(zoomWindow.getMaxY());
            }
        }
        if (this.isUpdateTickUnit()) {
            if (xAxis instanceof AbstractAxis) {
                xAxis.setTickUnit(((AbstractAxis)xAxis).computePreferredTickUnit(xAxis.getWidth()));
            }
            if (yAxis instanceof AbstractAxis) {
                yAxis.setTickUnit(((AbstractAxis)yAxis).computePreferredTickUnit(yAxis.getHeight()));
            }
        }
        if (!isZoomIn) {
            xAxis.setAutoRanging(zoomState.wasAutoRangingX);
            yAxis.setAutoRanging(zoomState.wasAutoRangingY);
            xAxis.setAutoGrowRanging(zoomState.wasAutoGrowRangingX);
            yAxis.setAutoGrowRanging(zoomState.wasAutoGrowRangingY);
        }
    }

    private boolean zoomOut() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        Map<Chart, ZoomState> zoomWindows = this.getZoomWindows(Deque::pollFirst);
        if (zoomWindows.isEmpty()) {
            return this.zoomOrigin();
        }
        this.performZoom(zoomWindows, false);
        return true;
    }

    public boolean zoomOrigin() {
        this.clearZoomStackIfAxisAutoRangingIsEnabled();
        Map<Chart, ZoomState> zoomWindows = this.getZoomWindows(Deque::peekLast);
        if (zoomWindows.isEmpty()) {
            return false;
        }
        this.clear();
        this.performZoom(zoomWindows, false);
        if (this.xRangeSlider != null) {
            this.xRangeSlider.reset();
        }
        for (Axis axis : this.getChart().getAxes()) {
            axis.forceRedraw();
        }
        return true;
    }

    private void clearZoomStackIfAxisAutoRangingIsEnabled() {
        Chart chart = this.getChart();
        if (chart == null || !(chart instanceof XYChart)) {
            return;
        }
        XYChart xyChart = (XYChart)chart;
        if (this.getAxisMode().allowsX() && xyChart.getXAxis().isAutoRanging() || this.getAxisMode().allowsY() && xyChart.getYAxis().isAutoRanging()) {
            this.clear();
            return;
        }
    }

    private Map<Chart, ZoomState> getZoomWindows(Function<Deque<ZoomState>, ZoomState> extractor) {
        ConcurrentHashMap<Chart, ZoomState> zoomWindows = new ConcurrentHashMap<Chart, ZoomState>();
        if (this.zoomStacks.isEmpty()) {
            return Collections.emptyMap();
        }
        zoomWindows.put(this.getChart(), extractor.apply(this.zoomStacks));
        return zoomWindows;
    }

    public void clear() {
        this.zoomStacks.clear();
    }

    private class ZoomRangeSlider
    extends RangeSlider {
        private final BooleanProperty invertedSlide = new SimpleBooleanProperty((Object)this, "invertedSlide", false);
        private boolean isUpdating = false;
        private final ChangeListener<Boolean> sliderResetHandler = (ch, o, n) -> {
            if (Zoomer.this.getChart() == null) {
                return;
            }
            Axis rawXaxis = Zoomer.this.getChart().getFirstAxis(Orientation.HORIZONTAL);
            if (!(rawXaxis instanceof Axis)) {
                return;
            }
            Axis xAxisNumeric = rawXaxis;
            if (n.booleanValue()) {
                double minBound = xAxisNumeric.getLowerBound();
                double maxBound = xAxisNumeric.getUpperBound();
                this.setMin(minBound);
                this.setMax(maxBound);
            }
        };

        public ZoomRangeSlider(Chart chart) {
            Axis rawXaxis = chart.getFirstAxis(Orientation.HORIZONTAL);
            if (!(rawXaxis instanceof Axis)) {
                throw new InvalidParameterException("non-Number chart axis not yet implemented in zoomer");
            }
            Axis xAxis = rawXaxis;
            Zoomer.this.xRangeSlider = this;
            this.setPrefWidth(-1.0);
            this.setMaxWidth(Double.MAX_VALUE);
            xAxis.invertAxisProperty().bindBidirectional((Property)this.invertedSlide);
            this.invertedSlide.addListener((ch, o, n) -> this.setRotate(n != false ? 180.0 : 0.0));
            xAxis.autoRangingProperty().addListener(this.sliderResetHandler);
            xAxis.autoGrowRangingProperty().addListener(this.sliderResetHandler);
            ChangeListener rangeChangeListener = (ch, o, n) -> {
                if (this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                xAxis.getUpperBound();
                xAxis.getLowerBound();
                double minBound = Math.min(xAxis.getLowerBound(), this.getMin());
                double maxBound = Math.max(xAxis.getUpperBound(), this.getMax());
                if (Zoomer.this.xRangeSliderInit) {
                    this.setMin(minBound);
                    this.setMax(maxBound);
                }
                this.isUpdating = false;
            };
            xAxis.lowerBoundProperty().addListener(rangeChangeListener);
            xAxis.upperBoundProperty().addListener(rangeChangeListener);
            ChangeListener sliderValueChanged = (ch, o, n) -> {
                if (!Zoomer.this.isSliderVisible() || n == null || this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                if (xAxis.isAutoRanging() || xAxis.isAutoGrowRanging()) {
                    this.setMin(xAxis.getLowerBound());
                    this.setMax(xAxis.getUpperBound());
                    this.isUpdating = false;
                    return;
                }
                this.isUpdating = false;
            };
            this.lowValueProperty().addListener(sliderValueChanged);
            this.highValueProperty().addListener(sliderValueChanged);
            this.setOnMouseReleased(event -> {
                if (Zoomer.this.zoomStacks.isEmpty()) {
                    Zoomer.this.makeSnapshotOfView();
                }
                xAxis.setAutoRanging(false);
                xAxis.setAutoGrowRanging(false);
                xAxis.setLowerBound(this.getLowValue());
                xAxis.setUpperBound(this.getHighValue());
            });
            this.lowValueProperty().bindBidirectional((Property)xAxis.lowerBoundProperty());
            this.highValueProperty().bindBidirectional((Property)xAxis.upperBoundProperty());
            Zoomer.this.sliderVisibleProperty().addListener((ch, o, n) -> {
                if (Zoomer.this.getChart() == null || o == n || this.isUpdating) {
                    return;
                }
                this.isUpdating = true;
                if (n.booleanValue()) {
                    Zoomer.this.getChart().getPlotArea().setBottom((Node)Zoomer.this.xRangeSlider);
                    this.prefWidthProperty().bind((ObservableValue)Zoomer.this.getChart().getCanvasForeground().widthProperty());
                } else {
                    Zoomer.this.getChart().getPlotArea().setBottom(null);
                    this.prefWidthProperty().unbind();
                }
                this.isUpdating = false;
            });
            Zoomer.this.addButtonsToToolBarProperty().addListener((ch, o, n) -> {
                Chart chartLocal = Zoomer.this.getChart();
                if (chartLocal == null || o == n) {
                    return;
                }
                if (n.booleanValue()) {
                    chartLocal.getToolBar().getChildren().add((Object)Zoomer.this.zoomButtons);
                } else {
                    chartLocal.getToolBar().getChildren().remove((Object)Zoomer.this.zoomButtons);
                }
            });
            Zoomer.this.xRangeSliderInit = true;
        }

        public void reset() {
            this.sliderResetHandler.changed(null, (Object)false, (Object)true);
        }
    }

    private class ZoomState {
        protected Rectangle2D zoomRectangle;
        protected boolean wasAutoRangingX;
        protected boolean wasAutoRangingY;
        protected boolean wasAutoGrowRangingX;
        protected boolean wasAutoGrowRangingY;

        ZoomState(Rectangle2D zoomRectangle, boolean isAutoRangingX, boolean isAutoRangingY, boolean isAutoGrowRangingX, boolean isAutoGrowRangingY) {
            this.zoomRectangle = zoomRectangle;
            this.wasAutoRangingX = isAutoRangingX;
            this.wasAutoRangingY = isAutoRangingY;
            this.wasAutoGrowRangingX = isAutoGrowRangingX;
            this.wasAutoGrowRangingY = isAutoGrowRangingY;
        }
    }
}

