/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class YValueIndicator
extends AbstractSingleValueIndicator {
    public YValueIndicator(Axis axis, double value) {
        this(axis, value, null);
    }

    public YValueIndicator(Axis axis, double value, String text) {
        super(axis, value, text);
        this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, 8.0, 8.0, 8.0, -8.0});
        this.setLabelHorizontalAnchor(HPos.RIGHT);
        this.setLabelPosition(0.975);
        this.pickLine.setOnMouseDragged(this::handleDragMouseEvent);
        this.triangle.setOnMouseDragged(this::handleDragMouseEvent);
        this.label.setOnMouseDragged(this::handleDragMouseEvent);
    }

    protected void handleDragMouseEvent(MouseEvent mouseEvent) {
        Point2D c = this.getChart().getPlotArea().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        double yPosData = this.getNumericAxis().getValueForDisplay(c.getY() - this.dragDelta.y);
        if (this.getNumericAxis().isValueOnAxis(yPosData)) {
            this.valueProperty().set(yPosData);
        }
        mouseEvent.consume();
    }

    @Override
    void updateStyleClass() {
        this.setStyleClasses((Node)this.label, "y-", "value-indicator-label");
        this.setStyleClasses((Node)this.line, "y-", "value-indicator-line");
        this.setStyleClasses((Node)this.triangle, "x-", "value-indicator-marker");
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null) {
            return;
        }
        Bounds plotAreaBounds = this.getChart().getCanvas().getBoundsInLocal();
        double minX = plotAreaBounds.getMinX();
        double maxX = plotAreaBounds.getMaxX();
        double minY = plotAreaBounds.getMinY();
        double maxY = plotAreaBounds.getMaxY();
        double yPos = minY + this.getNumericAxis().getDisplayPosition(this.getValue());
        if (yPos < minY || yPos > maxY) {
            this.getChartChildren().clear();
        } else {
            this.layoutLine(minX, yPos, maxX, yPos);
            this.layoutMarker(maxX - 1.5 * AbstractSingleValueIndicator.triangleHalfWidth, yPos, minX, yPos);
            this.layoutLabel((Bounds)new BoundingBox(minX, yPos, maxX - minX, 0.0), this.getLabelPosition(), 0.5);
        }
    }
}

