/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.EventListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableViewer
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableViewer.class);
    protected static final String FONT_AWESOME = "FontAwesome";
    protected static final int FONT_SIZE = 20;
    private final Glyph tableView = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.TABLE).size(20.0);
    private final Glyph graphView = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.LINE_CHART).size(20.0);
    private final Glyph saveIcon = new Glyph("FontAwesome", (Object)"\uf0c7").size(20.0);
    private final Glyph clipBoardIcon = new Glyph("FontAwesome", (Object)FontAwesome.Glyph.CLIPBOARD).size(20.0);
    private final HBox interactorButtons = this.getInteractorBar();
    private final TableView<DataSetsRow> table = new TableView();
    private final DataSetsModel dsModel = new DataSetsModel();
    protected boolean editable = false;

    public TableViewer() {
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.table.getSelectionModel().setCellSelectionEnabled(true);
        this.table.setEditable(true);
        this.table.setItems((ObservableList)this.dsModel);
        this.table.getColumns().addAll(this.dsModel.getColumns());
        this.dsModel.getColumns().addListener(change -> this.table.getColumns().setAll(this.dsModel.getColumns()));
        this.dsModel.setRefreshFunction(() -> {
            FXUtils.runFX(() -> {
                ObservableList tmp = this.table.getItems();
                this.table.setItems(FXCollections.emptyObservableList());
                this.table.setItems(tmp);
            });
            return null;
        });
        this.chartProperty().addListener((change, oldChart, newChart) -> {
            if (oldChart != null) {
                oldChart.getToolBar().getChildren().remove((Object)this.interactorButtons);
                oldChart.getPlotForeground().getChildren().remove(this.table);
                oldChart.getPlotArea().setBottom(null);
                this.table.prefWidthProperty().unbind();
                this.table.prefHeightProperty().unbind();
            }
            if (newChart != null) {
                if (this.isAddButtonsToToolBar()) {
                    newChart.getToolBar().getChildren().add((Object)this.interactorButtons);
                }
                newChart.getPlotForeground().getChildren().add(this.table);
                this.table.toFront();
                this.table.setVisible(false);
                this.table.prefWidthProperty().bind((ObservableValue)newChart.getPlotForeground().widthProperty());
                this.table.prefHeightProperty().bind((ObservableValue)newChart.getPlotForeground().heightProperty());
            }
            this.dsModel.chartChanged((Chart)((Object)oldChart), (Chart)((Object)newChart));
        });
        this.addButtonsToToolBarProperty().addListener((ch, o, n) -> {
            Chart chartLocal = this.getChart();
            if (chartLocal == null || o.equals(n)) {
                return;
            }
            if (n.booleanValue()) {
                chartLocal.getToolBar().getChildren().add((Object)this.interactorButtons);
            } else {
                chartLocal.getToolBar().getChildren().remove((Object)this.interactorButtons);
            }
        });
    }

    protected HBox getInteractorBar() {
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        HBox buttonBar = new HBox();
        buttonBar.setPadding(new Insets(1.0, 1.0, 1.0, 1.0));
        Button switchTableView = new Button(null, (Node)this.tableView);
        switchTableView.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        switchTableView.setTooltip(new Tooltip("switches between graph and table view"));
        Button copyToClipBoard = new Button(null, (Node)this.clipBoardIcon);
        copyToClipBoard.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        copyToClipBoard.setTooltip(new Tooltip("copy selected content top system clipboard"));
        copyToClipBoard.setOnAction(e -> this.copySelectedToClipboard());
        Button saveTableView = new Button(null, (Node)this.saveIcon);
        saveTableView.setPadding(new Insets(3.0, 3.0, 3.0, 3.0));
        saveTableView.setTooltip(new Tooltip("store actively shown content as .csv file"));
        saveTableView.setOnAction(e -> this.exportGridToCSV());
        switchTableView.setOnAction(evt -> {
            switchTableView.setGraphic((Node)(this.table.isVisible() ? this.tableView : this.graphView));
            this.table.setVisible(!this.table.isVisible());
            this.getChart().getPlotForeground().setMouseTransparent(!this.table.isVisible());
            this.table.setMouseTransparent(!this.table.isVisible());
            this.dsModel.refresh();
        });
        buttonBar.getChildren().addAll((Object[])new Node[]{separator, switchTableView, copyToClipBoard, saveTableView});
        return buttonBar;
    }

    public TableView<?> getTable() {
        return this.table;
    }

    public void exportGridToCSV() {
        FileChooser chooser = new FileChooser();
        File save = chooser.showSaveDialog(this.getChart().getScene().getWindow());
        if (save == null) {
            return;
        }
        String data = this.dsModel.getSelectedData((TableView.TableViewSelectionModel<DataSetsRow>)this.table.getSelectionModel());
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(save.getPath() + ".csv", new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(data);
        }
        catch (IOException ex) {
            LOGGER.error("error while exporting data to csv", (Throwable)ex);
        }
    }

    public void copySelectedToClipboard() {
        ClipboardContent content = new ClipboardContent();
        content.putString(this.dsModel.getSelectedData((TableView.TableViewSelectionModel<DataSetsRow>)this.table.getSelectionModel()));
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    protected class DataSetsRow {
        private int row = 0;
        private DataSetsModel model;

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.model.hashCode();
            hash = 31 * hash + this.row;
            return hash;
        }

        public boolean equals(Object o) {
            if (o instanceof DataSetsRow) {
                DataSetsRow dsr = (DataSetsRow)o;
                return dsr.getRow() == this.row && this.model.equals((Object)dsr.getModel());
            }
            return false;
        }

        private DataSetsRow(int row, DataSetsModel model) {
            this.row = row;
            this.model = model;
        }

        protected DataSetsModel getModel() {
            return this.model;
        }

        public int getRow() {
            return this.row;
        }

        public double getValue(DataSet ds, ColumnType type) {
            return this.model.getValue(this.row, ds, type);
        }
    }

    protected static enum ColumnType {
        X,
        Y,
        EXN,
        EXP,
        EYN,
        EYP;

    }

    protected class DataSetsModel
    extends ObservableListBase<DataSetsRow> {
        private int nRows = 0;
        private final ObservableList<TableColumn<DataSetsRow, ?>> columns = FXCollections.observableArrayList();
        private Callable<Void> refreshFunction;
        private final ListChangeListener<Renderer> rendererChangeListener = this::rendererChanged;
        private final ListChangeListener<DataSet> datasetChangeListener = this::datasetsChanged;
        private final EventListener dataSetDataUpdateListener = evt -> {
            this.nRows = 0;
            for (TableColumn col : this.columns) {
                if (!(col instanceof DataSetTableColumns)) continue;
                DataSetTableColumns dataSetColumn = (DataSetTableColumns)col;
                this.nRows = Math.max(this.nRows, dataSetColumn.dataSet.getDataCount());
                for (TableColumn subColumn : dataSetColumn.getColumns()) {
                    if (!(subColumn instanceof DataSetTableColumn)) continue;
                    ((DataSetTableColumn)subColumn).updateEditableState();
                }
            }
            this.refresh();
        };

        public DataSetsModel() {
            this.columns.add((Object)new RowIndexHeaderTableColumn());
        }

        public void setRefreshFunction(Callable<Void> refreshFunction) {
            this.refreshFunction = refreshFunction;
        }

        protected void datasetsChanged(ListChangeListener.Change<? extends DataSet> change) {
            boolean dataSetChanges = false;
            while (change.next()) {
                for (DataSet set : change.getRemoved()) {
                    set.removeListener(this.dataSetDataUpdateListener);
                    this.columns.removeIf(col -> col instanceof DataSetTableColumns && ((DataSetTableColumns)col).dataSet == set);
                    this.nRows = 0;
                    for (TableColumn col2 : this.columns) {
                        if (!(col2 instanceof DataSetTableColumn)) continue;
                        this.nRows = Math.max(this.nRows, ((DataSetTableColumn)col2).ds.getDataCount());
                    }
                    dataSetChanges = true;
                }
                for (DataSet set : change.getAddedSubList()) {
                    set.addListener(this.dataSetDataUpdateListener);
                    this.columns.add((Object)new DataSetTableColumns(set));
                    this.nRows = Math.max(this.nRows, set.getDataCount());
                    dataSetChanges = true;
                }
            }
            if (dataSetChanges) {
                this.refresh();
            }
        }

        private void refresh() {
            try {
                this.refreshFunction.call();
            }
            catch (Exception e) {
                LOGGER.error("Error refreshing table model", (Throwable)e);
            }
        }

        public void chartChanged(Chart oldChart, Chart newChart) {
            if (oldChart != null) {
                oldChart.getDatasets().removeListener(this.datasetChangeListener);
                oldChart.getDatasets().forEach(dataSet -> dataSet.removeListener(this.dataSetDataUpdateListener));
                oldChart.getRenderers().removeListener(this.rendererChangeListener);
                newChart.getRenderers().forEach(renderer -> renderer.getDatasets().removeListener(this.datasetChangeListener));
            }
            if (newChart != null) {
                newChart.getDatasets().addListener(this.datasetChangeListener);
                newChart.getDatasets().forEach(dataSet -> dataSet.addListener(this.dataSetDataUpdateListener));
                newChart.getRenderers().addListener(this.rendererChangeListener);
                newChart.getRenderers().forEach(renderer -> renderer.getDatasets().addListener(this.datasetChangeListener));
            }
        }

        protected void rendererChanged(ListChangeListener.Change<? extends Renderer> change) {
            boolean dataSetChanges = false;
            while (change.next()) {
                change.getAddedSubList().forEach(renderer -> renderer.getDatasets().addListener(this.datasetChangeListener));
                if (!change.getAddedSubList().isEmpty()) {
                    dataSetChanges = true;
                }
                change.getRemoved().forEach(renderer -> renderer.getDatasets().removeListener(this.datasetChangeListener));
                if (change.getRemoved().isEmpty()) continue;
                dataSetChanges = true;
            }
            if (dataSetChanges) {
                this.refresh();
            }
        }

        public DataSetsRow get(int row) {
            return new DataSetsRow(row, this);
        }

        public int size() {
            return this.nRows;
        }

        public boolean isEmpty() {
            return this.nRows >= 0;
        }

        public boolean contains(Object o) {
            if (o instanceof DataSetsRow) {
                return this.nRows > ((DataSetsRow)o).getRow();
            }
            return false;
        }

        public int indexOf(Object o) {
            if (o instanceof DataSetsRow) {
                int row = ((DataSetsRow)o).row;
                return row < this.nRows ? row : -1;
            }
            return -1;
        }

        public ObservableList<TableColumn<DataSetsRow, ?>> getColumns() {
            return this.columns;
        }

        protected String getSelectedData(TableView.TableViewSelectionModel<DataSetsRow> selModel) {
            ObservableList selected = selModel.getSelectedCells();
            if (selected.isEmpty()) {
                return this.getAllData();
            }
            TreeSet<Integer> rows = new TreeSet<Integer>();
            TreeMap<Integer, TableColumn> cols = new TreeMap<Integer, TableColumn>();
            for (TablePosition cell : selected) {
                cols.put(cell.getColumn(), cell.getTableColumn());
                rows.add(cell.getRow());
            }
            StringBuilder sb = new StringBuilder();
            sb.append('#');
            for (Map.Entry col : cols.entrySet()) {
                sb.append(((TableColumn)col.getValue()).getText()).append(", ");
            }
            sb.setCharAt(sb.length() - 2, '\n');
            sb.deleteCharAt(sb.length() - 1);
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                int r = (Integer)((Object)iterator.next());
                for (Map.Entry col : cols.entrySet()) {
                    if (col.getValue() instanceof DataSetTableColumn) {
                        sb.append(((DataSetTableColumn)((Object)col.getValue())).getValue(r)).append(", ");
                        continue;
                    }
                    sb.append(((TableColumn)col.getValue()).getCellData(r)).append(", ");
                }
                sb.setCharAt(sb.length() - 2, '\n');
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        protected String getAllData() {
            StringBuilder sb = new StringBuilder();
            sb.append('#');
            for (TableColumn col : this.columns) {
                sb.append(col.getText()).append(", ");
            }
            sb.setCharAt(sb.length() - 2, '\n');
            sb.deleteCharAt(sb.length() - 1);
            for (int r = 0; r < this.nRows; ++r) {
                for (TableColumn col : this.columns) {
                    if (col instanceof DataSetTableColumn) {
                        sb.append(((DataSetTableColumn)col).getValue(r)).append(", ");
                        continue;
                    }
                    sb.append(col.getCellData(r)).append(", ");
                }
                sb.setCharAt(sb.length() - 2, '\n');
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        public double getValue(int row, DataSet ds, ColumnType type) {
            if (row >= ds.getDataCount()) {
                return 0.0;
            }
            switch (type) {
                case X: {
                    return ds.getX(row);
                }
                case Y: {
                    return ds.getY(row);
                }
            }
            if (ds instanceof DataSetError) {
                return 0.0;
            }
            DataSetError eds = (DataSetError)ds;
            switch (type) {
                case EXN: {
                    return eds.getXErrorNegative(row);
                }
                case EXP: {
                    return eds.getXErrorPositive(row);
                }
                case EYN: {
                    return eds.getYErrorNegative(row);
                }
                case EYP: {
                    return eds.getYErrorPositive(row);
                }
            }
            return 0.0;
        }

        protected class DataSetTableColumn
        extends TableColumn<DataSetsRow, Double> {
            private final DataSet ds;
            private final ColumnType type;

            public DataSetTableColumn(String text, DataSet dataSet, ColumnType type) {
                super(text);
                this.ds = dataSet;
                this.type = type;
                this.setCellValueFactory(dataSetsRowFeature -> new ReadOnlyObjectWrapper((Object)((DataSetsRow)dataSetsRowFeature.getValue()).getValue(this.ds, type)));
                if (TableViewer.this.editable) {
                    this.updateEditableState();
                }
            }

            private void updateEditableState() {
                this.setEditable(false);
                this.setOnEditCommit(null);
                if (!(this.ds instanceof EditableDataSet) || this.type != ColumnType.X && this.type != ColumnType.Y) {
                    return;
                }
                EditableDataSet editableDataSet = (EditableDataSet)this.ds;
                EditConstraints editConstraints = editableDataSet.getEditConstraints();
                if (this.type == ColumnType.X && editConstraints != null && !editConstraints.isXEditable()) {
                    return;
                }
                if (this.type == ColumnType.Y && editConstraints != null && !editConstraints.isYEditable()) {
                    return;
                }
                this.setEditable(true);
                this.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new DoubleStringConverter()));
                this.setOnEditCommit(e -> {
                    int row = ((DataSetsRow)e.getRowValue()).getRow();
                    double oldX = editableDataSet.getX(row);
                    double oldY = editableDataSet.getY(row);
                    double newVal = (Double)e.getNewValue();
                    if (editConstraints != null && !editConstraints.canChange(row)) {
                        editableDataSet.set(row, oldX, oldY);
                        return;
                    }
                    switch (this.type) {
                        case X: {
                            if (editConstraints != null && !editConstraints.isAcceptable(row, newVal, oldY)) {
                                editableDataSet.set(row, oldX, oldY);
                                break;
                            }
                            editableDataSet.set(row, newVal, oldY);
                            break;
                        }
                        case Y: {
                            if (editConstraints != null && !editConstraints.isAcceptable(row, oldX, newVal)) {
                                editableDataSet.set(row, oldX, oldY);
                                break;
                            }
                            editableDataSet.set(row, oldX, newVal);
                            break;
                        }
                        default: {
                            editableDataSet.set(row, oldX, oldY);
                        }
                    }
                });
            }

            public double getValue(int row) {
                return TableViewer.this.dsModel.getValue(row, this.ds, this.type);
            }
        }

        protected class DataSetTableColumns
        extends TableColumn<DataSetsRow, Double> {
            private final DataSet dataSet;

            public DataSetTableColumns(DataSet dataSet) {
                super(dataSet.getName());
                this.dataSet = dataSet;
                this.addSubcolumns();
            }

            private void addSubcolumns() {
                this.getColumns().add((Object)new DataSetTableColumn("x", this.dataSet, ColumnType.X));
                this.getColumns().add((Object)new DataSetTableColumn("y", this.dataSet, ColumnType.Y));
                if (!(this.dataSet instanceof DataSetError)) {
                    return;
                }
                DataSetError eDs = (DataSetError)this.dataSet;
                if (eDs.getErrorType() == DataSetError.ErrorType.X || eDs.getErrorType() == DataSetError.ErrorType.XY) {
                    this.getColumns().add((Object)new DataSetTableColumn("e_x", this.dataSet, ColumnType.EXN));
                }
                if (eDs.getErrorType() == DataSetError.ErrorType.X_ASYMMETRIC || eDs.getErrorType() == DataSetError.ErrorType.XY_ASYMMETRIC) {
                    this.getColumns().add((Object)new DataSetTableColumn("-e_x", this.dataSet, ColumnType.EXN));
                    this.getColumns().add((Object)new DataSetTableColumn("+e_x", this.dataSet, ColumnType.EXP));
                }
                if (eDs.getErrorType() == DataSetError.ErrorType.Y || eDs.getErrorType() == DataSetError.ErrorType.XY) {
                    this.getColumns().add((Object)new DataSetTableColumn("e_y", this.dataSet, ColumnType.EYN));
                }
                if (eDs.getErrorType() == DataSetError.ErrorType.Y_ASYMMETRIC || eDs.getErrorType() == DataSetError.ErrorType.XY_ASYMMETRIC) {
                    this.getColumns().add((Object)new DataSetTableColumn("-e_y", this.dataSet, ColumnType.EYN));
                    this.getColumns().add((Object)new DataSetTableColumn("+e_y", this.dataSet, ColumnType.EYP));
                }
            }
        }

        protected class RowIndexHeaderTableColumn
        extends TableColumn<DataSetsRow, Integer> {
            public RowIndexHeaderTableColumn() {
                this.setCellValueFactory(dataSetsRow -> new ReadOnlyObjectWrapper((Object)((DataSetsRow)dataSetsRow.getValue()).getRow()));
                this.getStyleClass().add((Object)"column-header");
                this.setEditable(false);
            }
        }
    }
}

