/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.Axes;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.plugins.MouseEventsHelper;
import de.gsi.chart.ui.geometry.Side;
import java.util.Objects;
import java.util.function.Predicate;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;

public class Panner
extends ChartPlugin {
    public static final Predicate<MouseEvent> DEFAULT_MOUSE_FILTER = event -> MouseEventsHelper.isOnlyMiddleButtonDown(event);
    private Predicate<MouseEvent> mouseFilter = DEFAULT_MOUSE_FILTER;
    private Point2D previousMouseLocation = null;
    private final ObjectProperty<AxisMode> axisMode = new SimpleObjectProperty<AxisMode>((Object)this, "axisMode", AxisMode.XY){

        protected void invalidated() {
            Objects.requireNonNull((AxisMode)((Object)this.get()), "The " + this.getName() + " must not be null");
        }
    };
    private Cursor originalCursor;
    private final ObjectProperty<Cursor> dragCursor = new SimpleObjectProperty((Object)this, "dragCursor");
    private final EventHandler<MouseEvent> panStartHandler = event -> {
        if (this.mouseFilter == null || this.mouseFilter.test((MouseEvent)event)) {
            this.panStarted((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> panDragHandler = event -> {
        if (this.panOngoing()) {
            this.panDragged((MouseEvent)event);
            event.consume();
        }
    };
    private final EventHandler<MouseEvent> panEndHandler = event -> {
        if (this.panOngoing()) {
            this.panEnded();
            event.consume();
        }
    };

    public Panner() {
        this(AxisMode.XY);
    }

    public Panner(AxisMode panMode) {
        this.setAxisMode(panMode);
        this.setDragCursor(Cursor.CLOSED_HAND);
        this.registerMouseHandlers();
    }

    private void registerMouseHandlers() {
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_PRESSED, this.panStartHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_DRAGGED, this.panDragHandler);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_RELEASED, this.panEndHandler);
    }

    public Predicate<MouseEvent> getMouseFilter() {
        return this.mouseFilter;
    }

    public void setMouseFilter(Predicate<MouseEvent> mouseFilter) {
        this.mouseFilter = mouseFilter;
    }

    public final ObjectProperty<AxisMode> axisModeProperty() {
        return this.axisMode;
    }

    public final void setAxisMode(AxisMode mode) {
        this.axisModeProperty().set((Object)mode);
    }

    public final AxisMode getAxisMode() {
        return (AxisMode)((Object)this.axisModeProperty().get());
    }

    public final ObjectProperty<Cursor> dragCursorProperty() {
        return this.dragCursor;
    }

    public final void setDragCursor(Cursor cursor) {
        this.dragCursorProperty().set((Object)cursor);
    }

    public final Cursor getDragCursor() {
        return (Cursor)this.dragCursorProperty().get();
    }

    private void installCursor() {
        this.originalCursor = this.getChart().getCursor();
        if (this.getDragCursor() != null) {
            this.getChart().setCursor(this.getDragCursor());
        }
    }

    private void uninstallCursor() {
        this.getChart().setCursor(this.originalCursor);
    }

    private boolean panOngoing() {
        return this.previousMouseLocation != null;
    }

    private void panStarted(MouseEvent event) {
        this.previousMouseLocation = this.getLocationInPlotArea(event);
        this.installCursor();
    }

    private void panDragged(MouseEvent event) {
        Point2D mouseLocation = this.getLocationInPlotArea(event);
        this.panChart(this.getChart(), mouseLocation);
        this.previousMouseLocation = mouseLocation;
    }

    private void panChart(Chart chart, Point2D mouseLocation) {
        if (!(chart instanceof XYChart)) {
            return;
        }
        for (Axis axis : chart.getAxes()) {
            boolean allowsShift;
            if (!Axes.isNumericAxis(axis) || axis.getSide() == null) continue;
            Axis nAxis = Axes.toNumericAxis(axis);
            Side side = axis.getSide();
            double prevData = axis.getValueForDisplay(side.isHorizontal() ? this.previousMouseLocation.getX() : this.previousMouseLocation.getY());
            double newData = axis.getValueForDisplay(side.isHorizontal() ? mouseLocation.getX() : mouseLocation.getY());
            double offset = prevData - newData;
            boolean bl = allowsShift = side.isHorizontal() ? this.getAxisMode().allowsX() : this.getAxisMode().allowsY();
            if (Axes.hasBoundedRange(nAxis) || !allowsShift) continue;
            nAxis.setAutoRanging(false);
            this.shiftBounds(nAxis, offset);
        }
    }

    private void shiftBounds(Axis axis, double offset) {
        if (offset < 0.0) {
            axis.setLowerBound(axis.getLowerBound() + offset);
            axis.setUpperBound(axis.getUpperBound() + offset);
        } else {
            axis.setUpperBound(axis.getUpperBound() + offset);
            axis.setLowerBound(axis.getLowerBound() + offset);
        }
    }

    private void panEnded() {
        this.previousMouseLocation = null;
        this.uninstallCursor();
    }
}

