/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.plugins.ChartPlugin;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.controlsfx.control.PopOver;
import org.controlsfx.glyphfont.Glyph;

public class EditAxis
extends ChartPlugin {
    private static final String FONT_AWESOME = "FontAwesome";
    public static final String STYLE_CLASS_AXIS_EDITOR = "chart-axis-editor";
    protected static final int DEFAULT_SHUTDOWN_PERIOD = 5000;
    protected static final int DEFAULT_UPDATE_PERIOD = 100;
    protected static final int DEFAULT_PREFERRED_WIDTH = 700;
    protected static final int DEFAULT_PREFERRED_HEIGHT = 200;
    private static final Duration DEFAULT_ANIMATION_DURATION = Duration.millis((double)500.0);
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", false);
    private final List<MyPopOver> popUpList = new ArrayList<MyPopOver>();
    private final ObjectProperty<Duration> fadeDuration = new SimpleObjectProperty<Duration>((Object)this, "fadeDuration", DEFAULT_ANIMATION_DURATION){

        protected void invalidated() {
            Objects.requireNonNull((Duration)this.get(), "The " + this.getName() + " must not be null");
        }
    };
    private final ObjectProperty<AxisMode> axisMode = new SimpleObjectProperty<AxisMode>((Object)this, "axisMode", AxisMode.XY){

        protected void invalidated() {
            Objects.requireNonNull((AxisMode)((Object)this.get()), "The " + this.getName() + " must not be null");
        }
    };

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final void setAnimated(boolean value) {
        this.animatedProperty().set(value);
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final ObjectProperty<Duration> zoomDurationProperty() {
        return this.fadeDuration;
    }

    public final void setZoomDuration(Duration duration) {
        this.zoomDurationProperty().set((Object)duration);
    }

    public final Duration getZoomDuration() {
        return (Duration)this.zoomDurationProperty().get();
    }

    public final ObjectProperty<AxisMode> axisModeProperty() {
        return this.axisMode;
    }

    public final void setAxisMode(AxisMode mode) {
        this.axisModeProperty().set((Object)mode);
    }

    public final AxisMode getAxisMode() {
        return (AxisMode)((Object)this.axisModeProperty().get());
    }

    public EditAxis() {
        this(AxisMode.XY);
    }

    public EditAxis(AxisMode editMode) {
        this(editMode, false);
    }

    public EditAxis(boolean animated) {
        this(AxisMode.XY, animated);
    }

    public EditAxis(AxisMode editMode, boolean animated) {
        this.setAxisMode(editMode);
        this.setAnimated(animated);
        this.chartProperty().addListener((obs, oldChart, newChart) -> {
            if (oldChart != null) {
                this.removeMouseEventHandlers((Chart)((Object)oldChart));
            }
            this.addMouseEventHandlers((Chart)((Object)newChart));
        });
    }

    private void addMouseEventHandlers(Chart newChart) {
        newChart.getAxes().forEach(axis -> this.popUpList.add(new MyPopOver((Axis)axis, axis.getSide().isHorizontal())));
    }

    private void removeMouseEventHandlers(Chart oldChart) {
        this.popUpList.forEach(popOver -> {
            popOver.deregisterMouseEvents();
            this.popUpList.remove(popOver);
        });
    }

    private class AxisEditor
    extends BorderPane {
        AxisEditor(Axis axis, boolean isHorizontal) {
            this.setTop(this.getLabelEditor(axis, isHorizontal));
            HBox box = isHorizontal ? new HBox() : new VBox();
            this.setCenter((Node)box);
            if (isHorizontal) {
                box.setPrefWidth(700.0);
            } else {
                box.setPrefHeight(200.0);
            }
            box.getChildren().add((Object)this.getMinMaxButtons(axis, isHorizontal, true));
            box.getChildren().add((Object)this.getBoundField(axis, isHorizontal));
            box.getChildren().add((Object)this.createSpacer());
            box.getChildren().add((Object)this.getLogCheckBoxes(axis));
            box.getChildren().add((Object)this.getRangeChangeButtons(axis, isHorizontal));
            box.getChildren().add((Object)this.getAutoRangeCheckBoxes(axis));
            box.getChildren().add((Object)this.createSpacer());
            box.getChildren().add((Object)this.getBoundField(axis, !isHorizontal));
            box.getChildren().add((Object)this.getMinMaxButtons(axis, isHorizontal, false));
        }

        private Node getLabelEditor(Axis axis, boolean isHorizontal) {
            GridPane header = new GridPane();
            header.setAlignment(Pos.BASELINE_LEFT);
            TextField axisLabelTextField = new TextField(axis.getLabel());
            axisLabelTextField.textProperty().bindBidirectional((Property)axis.labelProperty());
            header.addRow(0, new Node[]{new Label(" axis label: "), axisLabelTextField});
            TextField axisUnitTextField = new TextField(axis.getUnit());
            axisUnitTextField.setPrefWidth(50.0);
            axisUnitTextField.textProperty().bindBidirectional(axis.unitProperty());
            header.addRow(isHorizontal ? 0 : 1, new Node[]{new Label(" unit: "), axisUnitTextField});
            TextField unitScaling = new TextField();
            unitScaling.setPrefWidth(80.0);
            CheckBox autoUnitScaling = new CheckBox(" auto");
            if (axis instanceof DefaultNumericAxis) {
                autoUnitScaling.selectedProperty().bindBidirectional((Property)((DefaultNumericAxis)axis).autoUnitScalingProperty());
                unitScaling.textProperty().bindBidirectional((Property)((DefaultNumericAxis)axis).unitScalingProperty(), (StringConverter)new NumberStringConverter((NumberFormat)new DecimalFormat("0.0####E0")));
                unitScaling.disableProperty().bind((ObservableValue)autoUnitScaling.selectedProperty());
            } else {
                autoUnitScaling.setDisable(true);
                unitScaling.setDisable(true);
            }
            HBox unitScalingBox = new HBox(new Node[]{unitScaling, autoUnitScaling});
            unitScalingBox.setAlignment(Pos.BASELINE_LEFT);
            header.addRow(isHorizontal ? 0 : 2, new Node[]{new Label(" unit scale:"), unitScalingBox});
            return header;
        }

        private Pane getMinMaxButtons(Axis axis, boolean isHorizontal, boolean isMin) {
            Button incMaxButton = new Button("", (Node)new Glyph(EditAxis.FONT_AWESOME, (Object)"\uf077"));
            incMaxButton.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)incMaxButton, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)incMaxButton, (Priority)Priority.ALWAYS);
            incMaxButton.setOnAction(evt -> {
                axis.setAutoRanging(false);
                this.changeAxisRangeLimit(axis, isHorizontal ? isMin : !isMin, true);
            });
            Button decMaxButton = new Button("", (Node)new Glyph(EditAxis.FONT_AWESOME, (Object)"\uf078"));
            decMaxButton.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)decMaxButton, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)decMaxButton, (Priority)Priority.ALWAYS);
            decMaxButton.setOnAction(evt -> {
                axis.setAutoRanging(false);
                this.changeAxisRangeLimit(axis, isHorizontal ? isMin : !isMin, false);
            });
            VBox box = isHorizontal ? new VBox() : new HBox();
            box.getChildren().addAll((Object[])new Node[]{incMaxButton, decMaxButton});
            return box;
        }

        private Pane getLogCheckBoxes(Axis axis) {
            VBox boxMax = new VBox();
            VBox.setVgrow((Node)boxMax, (Priority)Priority.ALWAYS);
            CheckBox logAxis = new CheckBox("log axis");
            HBox.setHgrow((Node)logAxis, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)logAxis, (Priority)Priority.ALWAYS);
            logAxis.setMaxWidth(Double.MAX_VALUE);
            logAxis.setSelected(axis.isLogAxis());
            boxMax.getChildren().add((Object)logAxis);
            if (axis instanceof DefaultNumericAxis) {
                logAxis.selectedProperty().bindBidirectional((Property)((DefaultNumericAxis)axis).logAxisProperty());
            } else {
                logAxis.setDisable(true);
            }
            CheckBox invertedAxis = new CheckBox("inverted");
            HBox.setHgrow((Node)invertedAxis, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)invertedAxis, (Priority)Priority.ALWAYS);
            invertedAxis.setMaxWidth(Double.MAX_VALUE);
            invertedAxis.setSelected(axis.isInvertedAxis());
            boxMax.getChildren().add((Object)invertedAxis);
            if (axis instanceof DefaultNumericAxis) {
                invertedAxis.selectedProperty().bindBidirectional((Property)((DefaultNumericAxis)axis).invertAxisProperty());
            } else {
                invertedAxis.setDisable(true);
            }
            CheckBox timeAxis = new CheckBox("time axis");
            HBox.setHgrow((Node)timeAxis, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)timeAxis, (Priority)Priority.ALWAYS);
            timeAxis.setMaxWidth(Double.MAX_VALUE);
            timeAxis.setSelected(axis.isTimeAxis());
            boxMax.getChildren().add((Object)timeAxis);
            if (axis instanceof DefaultNumericAxis) {
                timeAxis.selectedProperty().bindBidirectional((Property)((DefaultNumericAxis)axis).timeAxisProperty());
            } else {
                timeAxis.setDisable(true);
            }
            return boxMax;
        }

        private Pane getAutoRangeCheckBoxes(Axis axis) {
            VBox boxMax = new VBox();
            VBox.setVgrow((Node)boxMax, (Priority)Priority.ALWAYS);
            CheckBox autoRanging = new CheckBox("auto ranging");
            HBox.setHgrow((Node)autoRanging, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)autoRanging, (Priority)Priority.ALWAYS);
            autoRanging.setMaxWidth(Double.MAX_VALUE);
            autoRanging.setSelected(axis.isAutoRanging());
            autoRanging.selectedProperty().bindBidirectional((Property)axis.autoRangingProperty());
            boxMax.getChildren().add((Object)autoRanging);
            CheckBox autoGrow = new CheckBox("auto grow");
            HBox.setHgrow((Node)autoGrow, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)autoGrow, (Priority)Priority.ALWAYS);
            autoGrow.setMaxWidth(Double.MAX_VALUE);
            autoGrow.setSelected(axis.isAutoGrowRanging());
            autoGrow.selectedProperty().bindBidirectional((Property)axis.autoGrowRangingProperty());
            boxMax.getChildren().add((Object)autoGrow);
            return boxMax;
        }

        private Pane getRangeChangeButtons(Axis axis, boolean isHorizontal) {
            Button incMaxButton = new Button("", (Node)new Glyph(EditAxis.FONT_AWESOME, (Object)"expand"));
            incMaxButton.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)incMaxButton, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)incMaxButton, (Priority)Priority.NEVER);
            incMaxButton.setOnAction(evt -> {
                axis.setAutoRanging(false);
                this.changeAxisRange(axis, true);
            });
            Button decMaxButton = new Button("", (Node)new Glyph(EditAxis.FONT_AWESOME, (Object)"compress"));
            decMaxButton.setMaxWidth(Double.MAX_VALUE);
            VBox.setVgrow((Node)decMaxButton, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)decMaxButton, (Priority)Priority.NEVER);
            decMaxButton.setOnAction(evt -> {
                axis.setAutoRanging(false);
                this.changeAxisRange(axis, false);
            });
            VBox boxMax = isHorizontal ? new VBox() : new HBox();
            boxMax.getChildren().addAll((Object[])new Node[]{incMaxButton, decMaxButton});
            return boxMax;
        }

        private Node createSpacer() {
            Region spacer = new Region();
            VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            return spacer;
        }

        private final TextField getBoundField(Axis axis, boolean isLowerBound) {
            TextField textField = new TextField();
            Runnable lambda = () -> {
                boolean isInverted = axis.isInvertedAxis();
                double value = isLowerBound ? (isInverted ? axis.getUpperBound() : axis.getLowerBound()) : (isInverted ? axis.getLowerBound() : axis.getUpperBound());
                textField.setText(Double.toString(value));
            };
            axis.invertAxisProperty().addListener((ch, o, n) -> lambda.run());
            axis.lowerBoundProperty().addListener((ch, o, n) -> lambda.run());
            axis.upperBoundProperty().addListener((ch, o, n) -> lambda.run());
            textField.snappedTopInset();
            textField.snappedBottomInset();
            textField.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null && !newValue.matches("\\d*")) {
                    double val;
                    try {
                        val = Double.parseDouble(newValue);
                    }
                    catch (NullPointerException | NumberFormatException e) {
                        textField.setText(oldValue);
                        return;
                    }
                    if (axis.isLogAxis() && val <= 0.0) {
                        textField.setText(oldValue);
                        return;
                    }
                    textField.setText(Double.toString(val));
                }
            });
            textField.setOnKeyPressed(ke -> {
                if (ke.getCode().equals((Object)KeyCode.ENTER)) {
                    double presentValue = Double.parseDouble(textField.getText());
                    if (isLowerBound && !axis.isInvertedAxis()) {
                        axis.setLowerBound(presentValue);
                    } else {
                        axis.setUpperBound(presentValue);
                    }
                    axis.setAutoRanging(false);
                    if (axis instanceof AbstractAxis) {
                        axis.setTickUnit(((AbstractAxis)axis).computePreferredTickUnit(axis.getLength()));
                        System.err.println("recompute axis tick unit to " + ((AbstractAxis)axis).computePreferredTickUnit(axis.getLength()));
                    }
                }
            });
            HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)textField, (Priority)Priority.ALWAYS);
            return textField;
        }

        private void changeAxisRange(Axis axis, boolean isIncrease) {
            double width = Math.abs(axis.getUpperBound() - axis.getLowerBound());
            this.changeAxisRangeLinearScale(width, axis.lowerBoundProperty(), !isIncrease);
            this.changeAxisRangeLinearScale(width, axis.upperBoundProperty(), isIncrease);
        }

        private void changeAxisRangeLimit(Axis axis, boolean isHorizontal, boolean isIncrease) {
            boolean isInverted = axis.isInvertedAxis();
            DoubleProperty prop = isHorizontal ? (isInverted ? axis.upperBoundProperty() : axis.lowerBoundProperty()) : (isInverted ? axis.lowerBoundProperty() : axis.upperBoundProperty());
            double minTickDistance = Double.MAX_VALUE;
            ArrayList tickList = new ArrayList();
            axis.getTickMarks().forEach(tickMark -> tickList.add(tickMark.getValue()));
            if (!axis.isLogAxis()) {
                axis.getMinorTickMarks().forEach(minorTick -> tickList.add(Double.valueOf(minorTick.getPosition())));
            }
            for (Number check1 : tickList) {
                for (Number check2 : tickList) {
                    minTickDistance = Math.min(Math.abs(check1.doubleValue() - check2.doubleValue()), minTickDistance);
                }
            }
            if (axis.isLogAxis()) {
                minTickDistance *= 0.1;
            }
            if (minTickDistance == Double.MAX_VALUE || minTickDistance <= 0.0) {
                minTickDistance = 0.05 * Math.abs(axis.getUpperBound() - axis.getLowerBound());
            }
            if (axis.getTickUnit() > 0.0) {
                minTickDistance = axis.getTickUnit();
            }
            this.changeAxisRangeLinearScale(minTickDistance, prop, isIncrease);
            if (axis instanceof AbstractAxis) {
                axis.setTickUnit(((AbstractAxis)axis).computePreferredTickUnit(axis.getLength()));
            }
        }

        private void changeAxisRangeLinearScale(double minTickDistance, DoubleProperty property, boolean isIncrease) {
            double value = property.doubleValue();
            double diff = minTickDistance;
            if (isIncrease) {
                property.set(value + diff);
            } else {
                property.set(value - diff);
            }
        }
    }

    private class MyPopOver
    extends PopOver {
        private long popOverShowStartTime;
        private boolean isMouseInPopOver;
        private Axis axis;
        private final EventHandler<? super MouseEvent> axisClickEventHandler;

        MyPopOver(Axis axis, boolean isHorizontal) {
            super((Node)new AxisEditor(axis, isHorizontal));
            this.axis = null;
            this.axisClickEventHandler = evt -> {
                if (evt.getButton() == MouseButton.SECONDARY) {
                    double x = evt.getScreenX();
                    double y = evt.getScreenY();
                    if (this.axis != null) {
                        this.show((Node)this.axis, x, y);
                    }
                }
            };
            this.axis = axis;
            this.popOverShowStartTime = 0L;
            super.setAutoHide(true);
            super.setAnimated(true);
            this.setFadeInDuration(Duration.millis((double)1000.0));
            this.setFadeOutDuration(Duration.millis((double)500.0));
            switch (axis.getSide()) {
                case TOP: {
                    this.setArrowLocation(PopOver.ArrowLocation.TOP_CENTER);
                    break;
                }
                case LEFT: {
                    this.setArrowLocation(PopOver.ArrowLocation.LEFT_CENTER);
                    break;
                }
                case RIGHT: {
                    this.setArrowLocation(PopOver.ArrowLocation.RIGHT_CENTER);
                    break;
                }
                default: {
                    this.setArrowLocation(PopOver.ArrowLocation.BOTTOM_CENTER);
                }
            }
            this.setOpacity(0.0);
            this.getRoot().setBackground(Background.EMPTY);
            this.getScene().getStylesheets().add((Object)"plugin/editaxis.css");
            this.getStyleClass().add((Object)"axis-editor-view-pane");
            Timeline checkMouseInsidePopUp = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), event -> {
                if (!this.isShowing()) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (this.isMouseInPopOver) {
                    this.popOverShowStartTime = System.currentTimeMillis();
                }
                if (Math.abs(now - this.popOverShowStartTime) > 5000L) {
                    this.hide();
                }
            }, new KeyValue[0])});
            checkMouseInsidePopUp.setCycleCount(-1);
            checkMouseInsidePopUp.play();
            this.registerMouseEvents();
        }

        public final void registerMouseEvents() {
            this.setOnShowing(evt -> {
                this.popOverShowStartTime = System.currentTimeMillis();
            });
            this.getContentNode().setOnMouseEntered(mevt -> {
                this.isMouseInPopOver = true;
            });
            this.getContentNode().setOnMouseExited(mevt -> {
                this.isMouseInPopOver = false;
            });
            ((Node)this.axis).setOnMouseClicked(this.axisClickEventHandler);
        }

        public void deregisterMouseEvents() {
            ((Node)this.axis).removeEventHandler(MouseEvent.MOUSE_CLICKED, this.axisClickEventHandler);
        }
    }
}

