/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractDataFormattingPlugin;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class CrosshairIndicator
extends AbstractDataFormattingPlugin {
    public static final String STYLE_CLASS_PATH = "chart-crosshair-path";
    public static final String STYLE_CLASS_LABEL = "chart-crosshair-label";
    private static final int LABEL_X_OFFSET = 15;
    private static final int LABEL_Y_OFFSET = 5;
    private final Path crosshairPath = new Path();
    private final Label coordinatesLabel = new Label();
    private final EventHandler<MouseEvent> mouseMoveHandler = event -> {
        Bounds plotAreaBounds = this.getChart().getBoundsInLocal();
        if (!plotAreaBounds.contains(event.getX(), event.getY())) {
            this.getChartChildren().clear();
            return;
        }
        this.updatePath((MouseEvent)event, plotAreaBounds);
        this.updateLabel((MouseEvent)event, plotAreaBounds);
        if (!this.getChartChildren().contains((Object)this.crosshairPath)) {
            this.getChartChildren().addAll((Object[])new Node[]{this.crosshairPath, this.coordinatesLabel});
        }
    };

    public CrosshairIndicator() {
        this.crosshairPath.getStyleClass().add((Object)STYLE_CLASS_PATH);
        this.crosshairPath.setManaged(false);
        this.coordinatesLabel.getStyleClass().add((Object)STYLE_CLASS_LABEL);
        this.coordinatesLabel.setManaged(false);
        this.registerInputEventHandler((EventType<? extends InputEvent>)MouseEvent.MOUSE_MOVED, this.mouseMoveHandler);
    }

    private void updatePath(MouseEvent event, Bounds plotAreaBounds) {
        ObservableList path = this.crosshairPath.getElements();
        path.clear();
        path.add((Object)new MoveTo(plotAreaBounds.getMinX() + 1.0, event.getY()));
        path.add((Object)new LineTo(plotAreaBounds.getMaxX(), event.getY()));
        path.add((Object)new MoveTo(event.getX(), plotAreaBounds.getMinY() + 1.0));
        path.add((Object)new LineTo(event.getX(), plotAreaBounds.getMaxY()));
    }

    private void updateLabel(MouseEvent event, Bounds plotAreaBounds) {
        this.coordinatesLabel.setText(this.formatLabelText(this.getLocationInPlotArea(event)));
        double width = this.coordinatesLabel.prefWidth(-1.0);
        double height = this.coordinatesLabel.prefHeight(width);
        double xLocation = event.getX() + 15.0;
        double yLocation = event.getY() + 5.0;
        if (xLocation + width > plotAreaBounds.getMaxX()) {
            xLocation = event.getX() - 15.0 - width;
        }
        if (yLocation + height > plotAreaBounds.getMaxY()) {
            yLocation = event.getY() - 5.0 - height;
        }
        this.coordinatesLabel.resizeRelocate(xLocation, yLocation, width, height);
    }

    private String formatLabelText(Point2D displayPointInPlotArea) {
        Axis yAxis = this.getChart().getFirstAxis(Orientation.VERTICAL);
        return this.formatData(this.getChart(), this.toDataPoint(yAxis, displayPointInPlotArea));
    }
}

