/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.dataset.spi.utils.Tuple;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Pair;

public abstract class ChartPlugin {
    private final ObservableList<Node> chartChildren = FXCollections.observableArrayList();
    private final List<Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>>> mouseEventHandlers = new LinkedList<Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>>>();
    private final ObjectProperty<Chart> chart = new SimpleObjectProperty((Object)this, "chart");
    private final BooleanProperty addButtonsToToolBar = new SimpleBooleanProperty((Object)this, "addButtonsToToolBar", true);

    public final ObjectProperty<Chart> chartProperty() {
        return this.chart;
    }

    public final Chart getChart() {
        return (Chart)((Object)this.chartProperty().get());
    }

    public final void setChart(Chart chart) {
        this.chartProperty().set((Object)chart);
    }

    public final BooleanProperty addButtonsToToolBarProperty() {
        return this.addButtonsToToolBar;
    }

    public final void setAddButtonsToToolBar(boolean state) {
        this.addButtonsToToolBarProperty().set(state);
    }

    public final boolean isAddButtonsToToolBar() {
        return this.addButtonsToToolBarProperty().get();
    }

    protected ChartPlugin() {
        this.chartProperty().addListener((obs, oldChart, newChart) -> {
            if (oldChart != null) {
                this.removeEventHandlers((Node)oldChart.getPlotArea());
                this.removeEventHandlers((Node)oldChart.getPlotBackground());
            }
            if (newChart != null) {
                this.addEventHandlers((Node)newChart.getPlotArea());
                this.addEventHandlers((Node)newChart.getPlotBackground());
            }
        });
    }

    private <T extends InputEvent> void removeEventHandlers(Node node) {
        if (node == null) {
            return;
        }
        for (Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>> pair : this.mouseEventHandlers) {
            EventType type = (EventType)pair.getKey();
            EventHandler handler = (EventHandler)pair.getValue();
            node.removeEventHandler(type, handler);
            if (node.getScene() == null) continue;
            node.getScene().removeEventFilter(type, handler);
        }
    }

    private <T extends InputEvent> void addEventHandlers(Node node) {
        if (node == null) {
            return;
        }
        for (Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>> pair : this.mouseEventHandlers) {
            EventType type = (EventType)pair.getKey();
            EventHandler handler = (EventHandler)pair.getValue();
            node.addEventHandler(type, handler);
            node.sceneProperty().addListener((ch, o, n) -> {
                if (o == n) {
                    return;
                }
                if (o != null) {
                    o.removeEventHandler(type, handler);
                }
                if (n != null) {
                    n.addEventHandler(type, handler);
                }
            });
        }
    }

    protected final void registerInputEventHandler(EventType<? extends InputEvent> eventType, EventHandler<? extends InputEvent> handler) {
        this.mouseEventHandlers.add((Pair<EventType<? extends InputEvent>, EventHandler<? extends InputEvent>>)new Pair(eventType, handler));
    }

    public final ObservableList<Node> getChartChildren() {
        return this.chartChildren;
    }

    public void layoutChildren() {
    }

    protected final Point2D getLocationInPlotArea(MouseEvent event) {
        Point2D mouseLocationInScene = new Point2D(event.getSceneX(), event.getSceneY());
        Chart chart = this.getChart();
        if (!(chart instanceof XYChart)) {
            return null;
        }
        XYChart xyChart = (XYChart)chart;
        double xInAxis = ((Node)xyChart.getXAxis()).sceneToLocal(mouseLocationInScene).getX();
        double yInAxis = ((Node)xyChart.getYAxis()).sceneToLocal(mouseLocationInScene).getY();
        return new Point2D(xInAxis, yInAxis);
    }

    protected final Point2D toDisplayPoint(Axis yAxis, double x, double y) {
        return new Point2D(((XYChart)this.getChart()).getXAxis().getDisplayPosition(x), yAxis.getDisplayPosition(y));
    }

    protected final Tuple<Number, Number> toDataPoint(Axis yAxis, Point2D displayPoint) {
        Chart chart = this.getChart();
        if (!(chart instanceof XYChart)) {
            return null;
        }
        XYChart xyChart = (XYChart)chart;
        return new Tuple((Object)xyChart.getXAxis().getValueForDisplay(displayPoint.getX()), (Object)yAxis.getValueForDisplay(displayPoint.getY()));
    }
}

