/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractValueIndicator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;

public abstract class AbstractSingleValueIndicator
extends AbstractValueIndicator {
    protected static final int DEFAULT_PICKING_DISTANCE = 30;
    protected static final double MIDDLE_POSITION = 0.5;
    protected static final String STYLE_CLASS_LABEL = "value-indicator-label";
    protected static final String STYLE_CLASS_LINE = "value-indicator-line";
    protected static final String STYLE_CLASS_MARKER = "value-indicator-marker";
    protected static double triangleHalfWidth = 5.0;
    protected final Line line = new Line();
    protected final Line pickLine = new Line();
    protected final Polygon triangle = new Polygon();
    private final DoubleProperty pickingDistance = new SimpleDoubleProperty(this, "pickingDistance", 30.0){

        protected void invalidated() {
            if (this.get() <= 0.0) {
                throw new IllegalArgumentException("The " + this.getName() + " must be a positive value");
            }
        }
    };
    private final DoubleProperty value = new SimpleDoubleProperty(this, "value"){

        protected void invalidated() {
            AbstractSingleValueIndicator.this.layoutChildren();
        }
    };
    private final DoubleProperty labelPosition = new SimpleDoubleProperty(this, "labelPosition", 0.5){

        protected void invalidated() {
            if (this.get() < 0.0 || this.get() > 1.0) {
                throw new IllegalArgumentException("labelPosition must be in rage [0,1]");
            }
            AbstractSingleValueIndicator.this.layoutChildren();
        }
    };

    protected AbstractSingleValueIndicator(Axis axis, double value, String text) {
        super(axis, text);
        this.setValue(value);
        this.initLine();
        this.initTriangle();
        this.editableIndicatorProperty().addListener((ch, o, n) -> this.updateMouseListener((boolean)n));
        this.updateMouseListener(this.isEditable());
        this.getChartChildren().addAll((Object[])new Node[]{this.line, this.triangle, this.label});
    }

    public final DoubleProperty pickingDistanceProperty() {
        return this.pickingDistance;
    }

    public final void setPickingDistance(double distance) {
        this.pickingDistanceProperty().set(distance);
    }

    public final double getPickingDistance() {
        return this.pickingDistanceProperty().get();
    }

    private void initLine() {
        this.line.setMouseTransparent(true);
        this.pickLine.setPickOnBounds(true);
        this.pickLine.setStroke((Paint)Color.TRANSPARENT);
        this.pickLine.setStrokeWidth(this.getPickingDistance());
        this.pickLine.mouseTransparentProperty().bind((ObservableValue)this.editableIndicatorProperty().not());
        this.pickLine.setOnMousePressed(mouseEvent -> {
            this.dragDelta.x = this.pickLine.getStartX() - mouseEvent.getX();
            this.dragDelta.y = this.pickLine.getStartY() - mouseEvent.getY();
            this.pickLine.setCursor(Cursor.MOVE);
            mouseEvent.consume();
        });
    }

    private void initTriangle() {
        this.triangle.visibleProperty().bind((ObservableValue)this.editableIndicatorProperty());
        this.triangle.mouseTransparentProperty().bind((ObservableValue)this.editableIndicatorProperty().not());
        this.triangle.setPickOnBounds(true);
        double a = triangleHalfWidth;
        this.triangle.getPoints().setAll((Object[])new Double[]{-a, -a, -a, a, a, a, a, -a});
        this.triangle.setOnMousePressed(mouseEvent -> {
            this.dragDelta.x = this.triangle.getLayoutX() - mouseEvent.getX();
            this.dragDelta.y = this.triangle.getLayoutY() - mouseEvent.getY();
            this.triangle.setCursor(Cursor.MOVE);
            mouseEvent.consume();
        });
    }

    private void updateMouseListener(boolean state) {
        if (state) {
            this.pickLine.setOnMouseReleased(mouseEvent -> this.pickLine.setCursor(Cursor.HAND));
            this.pickLine.setOnMouseEntered(mouseEvent -> this.pickLine.setCursor(Cursor.HAND));
            this.triangle.setOnMouseReleased(mouseEvent -> this.triangle.setCursor(Cursor.HAND));
            this.triangle.setOnMouseEntered(mouseEvent -> this.triangle.setCursor(Cursor.HAND));
            this.label.setOnMouseReleased(mouseEvent -> this.label.setCursor(Cursor.HAND));
            this.label.setOnMouseEntered(mouseEvent -> this.label.setCursor(Cursor.HAND));
        } else {
            this.pickLine.setOnMouseReleased(null);
            this.pickLine.setOnMouseEntered(null);
            this.triangle.setOnMouseReleased(null);
            this.triangle.setOnMouseEntered(null);
            this.label.setOnMouseReleased(null);
            this.label.setOnMouseEntered(null);
        }
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getValue() {
        return this.valueProperty().get();
    }

    public final void setValue(double newValue) {
        this.valueProperty().set(newValue);
    }

    public final DoubleProperty labelPositionProperty() {
        return this.labelPosition;
    }

    public final double getLabelPosition() {
        return this.labelPositionProperty().get();
    }

    public final void setLabelPosition(double value) {
        this.labelPositionProperty().set(value);
    }

    protected void layoutLine(double startX, double startY, double endX, double endY) {
        this.line.setStartX(startX);
        this.line.setStartY(startY);
        this.line.setEndX(endX);
        this.line.setEndY(endY);
        this.pickLine.setStartX(startX);
        this.pickLine.setStartY(startY);
        this.pickLine.setEndX(endX);
        this.pickLine.setEndY(endY);
        this.addChildNodeIfNotPresent((Node)this.line);
        this.addChildNodeIfNotPresent((Node)this.pickLine);
        this.pickLine.toBack();
    }

    protected void layoutMarker(double startX, double startY, double endX, double endY) {
        if (!this.triangle.isVisible()) {
            return;
        }
        this.triangle.setTranslateX(startX);
        this.triangle.setTranslateY(startY);
        this.addChildNodeIfNotPresent((Node)this.triangle);
    }
}

