/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.format;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.format.AbstractFormatter;
import de.gsi.chart.axes.spi.format.DefaultTimeTickUnitSupplier;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class DefaultTimeFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTimeTickUnitSupplier();
    private static final DateTimeFormatter HIGHRES_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss +SSS", Locale.ENGLISH);
    protected final DateTimeFormatter[] dateFormat;
    protected int oldIndex = -1;
    protected int formatterIndex;
    protected ObjectProperty<ZoneOffset> timeZone = new SimpleObjectProperty((Object)ZoneOffset.UTC);

    public ObjectProperty<ZoneOffset> timeZoneOffsetProperty() {
        return this.timeZone;
    }

    public ZoneOffset getTimeZoneOffset() {
        return (ZoneOffset)this.timeZoneOffsetProperty().get();
    }

    public void setTimeZoneOffset(ZoneOffset newOffset) {
        if (newOffset != null) {
            this.timeZoneOffsetProperty().set((Object)newOffset);
            return;
        }
        this.timeZoneOffsetProperty().set((Object)ZoneOffset.UTC);
    }

    public DefaultTimeFormatter(Axis axis) {
        super(axis);
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
        this.dateFormat = new DateTimeFormatter[DefaultTimeTickUnitSupplier.TICK_UNIT_FORMATTER_DEFAULTS.length];
        for (int i = 0; i < this.dateFormat.length; ++i) {
            String format = DefaultTimeTickUnitSupplier.TICK_UNIT_FORMATTER_DEFAULTS[i];
            this.dateFormat[i] = format.contains("HIGHRES") ? HIGHRES_FORMATTER : DateTimeFormatter.ofPattern(format, Locale.ENGLISH);
        }
    }

    public DefaultTimeFormatter() {
        this(null);
    }

    @Override
    protected void rangeUpdated() {
        this.formatterIndex = DefaultTimeTickUnitSupplier.getTickIndex(this.getRange());
        if (this.oldIndex != this.formatterIndex) {
            this.labelCache.clear();
            this.oldIndex = this.formatterIndex;
        }
    }

    public String getCurrentLocalDateTimeStamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public String formatHighResString(Number utcValueSeconds) {
        double timeAbs = Math.abs(utcValueSeconds.doubleValue());
        long timeUS = (long)((double)TimeUnit.SECONDS.toMicros(1L) * timeAbs);
        long longUTCSeconds = Math.abs(utcValueSeconds.longValue());
        int longNanoSeconds = (int)((timeAbs - (double)longUTCSeconds) * 1.0E9);
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(longUTCSeconds, longNanoSeconds, this.getTimeZoneOffset());
        return dateTime.format(HIGHRES_FORMATTER).concat(Long.toString(timeUS % 1000L)).concat("us").replaceAll(" ", System.lineSeparator());
    }

    @Override
    public String toString(Number utcValueSeconds) {
        return this.labelCache.computeIfAbsent(utcValueSeconds, this::getTimeString);
    }

    private String getTimeString(Number utcValueSeconds) {
        if (this.formatterIndex <= 3) {
            return this.formatHighResString(utcValueSeconds);
        }
        long longUTCSeconds = utcValueSeconds.longValue();
        int longNanoSeconds = (int)((utcValueSeconds.doubleValue() - (double)longUTCSeconds) * 1.0E9);
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(longUTCSeconds, longNanoSeconds, this.getTimeZoneOffset());
        return dateTime.format(this.dateFormat[this.formatterIndex]).replaceAll(" ", System.lineSeparator());
    }

    @Override
    public Number fromString(String string) {
        return null;
    }
}

