/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.format;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.format.AbstractFormatter;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import de.gsi.chart.utils.NumberFormatter;
import java.text.DecimalFormat;
import java.text.ParseException;
import javafx.util.StringConverter;

public class DefaultLogFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private static final String FORMAT_SMALL_SCALE = "0.######";
    private static final String FORMAT_LARGE_SCALE = "0.0E0";
    public static final int DEFAULT_SMALL_LOG_AXIS = 4;
    private final DecimalFormat formatterSmall = new DecimalFormat("0.######");
    private final DecimalFormat formatterLarge = new DecimalFormat("0.0E0");
    private MyDecimalFormat formatter = new MyDecimalFormat(this.formatterSmall);

    public DefaultLogFormatter(Axis axis) {
        super(axis);
    }

    public DefaultLogFormatter() {
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
    }

    @Override
    protected void rangeUpdated() {
        boolean smallScale = this.getLogRange() <= 4.0;
        DecimalFormat oldFormatter = this.formatter.getFormatter();
        if (smallScale) {
            this.formatter.setFormatter(this.formatterSmall);
            if (!this.formatter.equals(oldFormatter)) {
                this.labelCache.clear();
            }
            return;
        }
        this.formatter.setFormatter(this.formatterLarge);
        if (!this.formatter.equals(oldFormatter)) {
            this.labelCache.clear();
        }
    }

    @Override
    protected double getLogRange() {
        return Math.abs(Math.log10(this.rangeMin)) + Math.abs(Math.log10(this.rangeMax));
    }

    @Override
    public String toString(Number object) {
        return this.labelCache.get(this.formatter, object.doubleValue());
    }

    @Override
    public Number fromString(String string) {
        return null;
    }

    private class MyDecimalFormat
    extends StringConverter<Number>
    implements NumberFormatter {
        private DecimalFormat formatter;

        public MyDecimalFormat(DecimalFormat formatter) {
            this.formatter = formatter;
        }

        private void setFormatter(DecimalFormat formatter) {
            this.formatter = formatter;
        }

        private DecimalFormat getFormatter() {
            return this.formatter;
        }

        @Override
        public int getPrecision() {
            return 0;
        }

        @Override
        public NumberFormatter setPrecision(int precision) {
            return this;
        }

        @Override
        public boolean isExponentialForm() {
            return false;
        }

        @Override
        public NumberFormatter setExponentialForm(boolean state) {
            return this;
        }

        @Override
        public String toString(double val) {
            return this.formatter.format(val);
        }

        public String toString(Number object) {
            return this.formatter.format(object.doubleValue());
        }

        public Number fromString(String source) {
            try {
                return this.formatter.parse(source);
            }
            catch (ParseException e) {
                return Double.NaN;
            }
        }
    }
}

