/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.format;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.format.AbstractFormatter;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import de.gsi.chart.utils.DigitNumberArithmetic;
import de.gsi.chart.utils.NumberFormatterImpl;
import de.gsi.dataset.spi.utils.Tuple;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.WeakHashMap;

public class DefaultFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private static final String FORMAT_SMALL_SCALE = "0.00";
    private static final String FORMAT_LARGE_SCALE = "#.##E0";
    public static final int DEFAULT_SMALL_AXIS = 6;
    private final DecimalFormat formatterSmall = new DecimalFormat("0.00");
    private final DecimalFormat formatterLarge = new DecimalFormat("#.##E0");
    private String formatterPattern = "%f";
    private boolean isExponentialForm = false;
    private final WeakHashMap<Integer, WeakHashMap<Number, String>> numberFormatCache = new WeakHashMap();
    protected NumberFormatterImpl myFormatter = new NumberFormatterImpl();
    protected int rangeIndex = 0;
    protected int oldRangeIndex = 0;
    private String prefix;
    private String suffix;

    public DefaultFormatter(Axis axis) {
        super(axis);
    }

    public DefaultFormatter() {
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
    }

    public DefaultFormatter(Axis axis, String prefix, String suffix) {
        this(axis);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    protected void rangeUpdated() {
        double range = this.getRange();
        this.isExponentialForm = range < 0.001 || range > 10000.0;
        this.myFormatter.setExponentialForm(this.isExponentialForm);
        int maxSigDigits = 0;
        int maxDigits = 0;
        if (this.majorTickMarksCopy != null) {
            for (int i = 0; i < this.majorTickMarksCopy.size(); ++i) {
                double val = (Double)this.majorTickMarksCopy.get(i) / this.unitScaling;
                int nDigits = (int)Math.log10(Math.abs(val)) + 1;
                maxDigits = Math.max(nDigits, maxDigits);
            }
            int maxExp = 0;
            int maxFrac = 0;
            for (int i = 0; i < this.majorTickMarksCopy.size() - 1; ++i) {
                double lower = (Double)this.majorTickMarksCopy.get(i) / this.unitScaling;
                double upper = (Double)this.majorTickMarksCopy.get(i + 1) / this.unitScaling;
                int significantDifferentDigits = DigitNumberArithmetic.numberDigitsUntilFirstSignificantDigit(lower, upper);
                maxSigDigits = Math.max(maxSigDigits, significantDifferentDigits);
                Tuple<Double, Double> formatTuple = DigitNumberArithmetic.formatStringForSignificantDigits(lower, upper);
                maxExp = (int)Math.max((Double)formatTuple.getXValue(), (double)maxExp);
                maxFrac = (int)Math.max((Double)formatTuple.getYValue() + 1.0, (double)maxFrac);
            }
            StringBuilder sb = new StringBuilder("%");
            sb.append(maxExp + maxFrac + 1);
            if (maxFrac > 0) {
                sb.append(".");
                sb.append(maxFrac);
            } else if (maxExp == 0 && maxFrac == 0) {
                sb.append(".1");
            } else if (maxExp >= 0 && maxFrac == 0) {
                sb.append(".0");
            }
            this.formatterPattern = sb.append("f").toString();
            this.myFormatter.setPrecision(maxSigDigits);
        }
        if (this.oldRangeIndex != this.rangeIndex) {
            this.labelCache.clear();
            this.oldRangeIndex = this.rangeIndex;
        }
    }

    @Override
    public String toString(Number object) {
        String label;
        if (this.isExponentialForm) {
            return this.labelCache.get(this.myFormatter, object.doubleValue());
        }
        WeakHashMap<Number, String> hash = this.numberFormatCache.get(this.formatterPattern.hashCode());
        if (hash != null && (label = hash.get(object)) != null) {
            return label;
        }
        String retVal = String.format(this.formatterPattern, object.doubleValue());
        if (hash == null) {
            WeakHashMap<Number, String> temp = new WeakHashMap<Number, String>();
            temp.put(object, retVal);
            this.numberFormatCache.put(this.formatterPattern.hashCode(), temp);
        } else {
            hash.put(object, retVal);
        }
        return retVal;
    }

    @Override
    public Number fromString(String string) {
        int prefixLength = this.prefix == null ? 0 : this.prefix.length();
        int suffixLength = this.suffix == null ? 0 : this.suffix.length();
        try {
            return this.formatterSmall.parse(string.substring(prefixLength, string.length() - suffixLength));
        }
        catch (ParseException exc) {
            try {
                return this.formatterLarge.parse(string.substring(prefixLength, string.length() - suffixLength));
            }
            catch (ParseException ex) {
                ex.addSuppressed(exc);
                throw new IllegalArgumentException(ex);
            }
        }
    }
}

