/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

public enum MetricPrefix {
    YOTTA("yotta", "Y", 1.0E24),
    ZETTA("zetta", "Z", 1.0E21),
    EXA("exa", "E", 1.0E18),
    PETA("peta", "P", 1.0E15),
    TERA("tera", "T", 1.0E12),
    GIGA("giga", "G", 1.0E9),
    MEGA("mega", "M", 1000000.0),
    KILO("kilo", "k", 1000.0),
    HECTO("hecto", "h", 100.0),
    NONE("", "", 1.0),
    CENTI("centi", "c", 0.01),
    MILLI("milli", "m", 0.001),
    MICRO("micro", "\u03bc", 1.0E-6),
    NANO("nano", "n", 1.0E-9),
    PICO("pico", "p", 1.0E-12),
    FEMTO("femto", "f", 1.0E-15),
    ATTO("atto", "a", 1.0E-18),
    ZEPTO("zepto", "z", 1.0E-21),
    YOCTO("yocto", "y", 1.0E-24);

    final String longPrefix;
    final String shortPrefix;
    final double power;

    private MetricPrefix(String longPrefix, String shortPrefix, double power) {
        this.longPrefix = longPrefix;
        this.shortPrefix = shortPrefix;
        this.power = power;
    }

    public String getLongPrefix() {
        return this.longPrefix;
    }

    public String getShortPrefix() {
        return this.shortPrefix;
    }

    public double getPower() {
        return this.power;
    }

    public static MetricPrefix getNearestMatch(double scaling) {
        for (MetricPrefix e : MetricPrefix.values()) {
            if (!(scaling >= e.getPower())) continue;
            return e;
        }
        return NONE;
    }

    public static String getShortPrefix(double scaling) {
        for (MetricPrefix e : MetricPrefix.values()) {
            if (scaling != e.getPower()) continue;
            return e.getShortPrefix();
        }
        return scaling + "*";
    }

    public static String getLongPrefix(double scaling) {
        for (MetricPrefix e : MetricPrefix.values()) {
            if (scaling != e.getPower()) continue;
            return e.getLongPrefix();
        }
        return scaling + "*";
    }
}

