/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.AxisTransform;
import de.gsi.chart.axes.LogAxisType;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.AbstractAxis;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.transforms.DefaultAxisTransform;
import de.gsi.chart.axes.spi.transforms.LogarithmicAxisTransform;
import de.gsi.chart.axes.spi.transforms.LogarithmicTimeAxisTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class DefaultNumericAxis
extends AbstractAxis {
    public static final double DEFAULT_LOG_MIN_VALUE = 1.0E-6;
    private double offset;
    private static final int MAX_TICK_COUNT = 20;
    private static final int DEFAULT_RANGE_LENGTH = 2;
    private final Cache cache = new Cache();
    private final DefaultAxisTransform linearTransform = new DefaultAxisTransform(this);
    private final LogarithmicAxisTransform logTransform = new LogarithmicAxisTransform(this);
    private final LogarithmicTimeAxisTransform logTimeTransform = new LogarithmicTimeAxisTransform(this);
    private AxisTransform axisTransform = this.linearTransform;
    protected boolean isUpdating = true;
    private final BooleanProperty forceZeroInRange = new SimpleBooleanProperty(this, "forceZeroInRange", false){

        protected void invalidated() {
            if (DefaultNumericAxis.this.isAutoRanging() || DefaultNumericAxis.this.isAutoGrowRanging()) {
                DefaultNumericAxis.this.invalidateRange();
                DefaultNumericAxis.this.requestAxisLayout();
            }
        }
    };
    protected boolean isLogAxis = false;
    private final BooleanProperty logAxis = new SimpleBooleanProperty(this, "logAxis", this.isLogAxis){

        protected void invalidated() {
            DefaultNumericAxis.this.isLogAxis = this.get();
            if (DefaultNumericAxis.this.isLogAxis) {
                if (DefaultNumericAxis.this.isTimeAxis()) {
                    DefaultNumericAxis.this.axisTransform = DefaultNumericAxis.this.logTimeTransform;
                    DefaultNumericAxis.this.setMinorTickCount(0);
                } else {
                    DefaultNumericAxis.this.axisTransform = DefaultNumericAxis.this.logTransform;
                    DefaultNumericAxis.this.setMinorTickCount(10);
                }
                if (DefaultNumericAxis.this.getLowerBound() <= 0.0) {
                    DefaultNumericAxis.this.isUpdating = true;
                    DefaultNumericAxis.this.setLowerBound(1.0E-6);
                    DefaultNumericAxis.this.isUpdating = false;
                }
                DefaultNumericAxis.this.invalidateRange();
                DefaultNumericAxis.this.requestLayout();
            } else {
                DefaultNumericAxis.this.axisTransform = DefaultNumericAxis.this.linearTransform;
                if (DefaultNumericAxis.this.isTimeAxis()) {
                    DefaultNumericAxis.this.setMinorTickCount(0);
                } else {
                    DefaultNumericAxis.this.setMinorTickCount(10);
                }
            }
            if (DefaultNumericAxis.this.isAutoRanging() || DefaultNumericAxis.this.isAutoGrowRanging()) {
                DefaultNumericAxis.this.invalidateRange();
            }
            DefaultNumericAxis.this.requestAxisLayout();
        }
    };

    public DefaultNumericAxis(String axisLabel) {
        this(axisLabel, 0.0, 0.0, 5.0);
    }

    public DefaultNumericAxis(String axisLabel, String unit) {
        this(axisLabel, 0.0, 0.0, 5.0);
        this.setUnit(unit);
    }

    public DefaultNumericAxis() {
        this("axis label", 0.0, 0.0, 5.0);
    }

    public DefaultNumericAxis(double lowerBound, double upperBound, double tickUnit) {
        this(null, lowerBound, upperBound, tickUnit);
    }

    public DefaultNumericAxis(String axisLabel, double lowerBound, double upperBound, double tickUnit) {
        super(lowerBound, upperBound);
        this.setLabel(axisLabel);
        if (lowerBound >= upperBound || lowerBound == 0.0 && upperBound == 0.0) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(tickUnit);
        this.setMinorTickCount(10);
        this.isUpdating = false;
    }

    @Override
    public AxisTransform getAxisTransform() {
        return this.axisTransform;
    }

    public BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    public boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    public void setForceZeroInRange(boolean value) {
        this.forceZeroInRange.setValue(Boolean.valueOf(value));
    }

    public BooleanProperty logAxisProperty() {
        return this.logAxis;
    }

    @Override
    public boolean isLogAxis() {
        return this.isLogAxis;
    }

    public void setLogAxis(boolean value) {
        this.isLogAxis = value;
        this.logAxis.set(value);
    }

    @Override
    public LogAxisType getLogAxisType() {
        if (this.isLogAxis) {
            return LogAxisType.LOG10_SCALE;
        }
        return LogAxisType.LINEAR_SCALE;
    }

    public DoubleProperty logarithmBaseProperty() {
        return this.logTransform.logarithmBaseProperty();
    }

    public double getLogarithmBase() {
        return this.logarithmBaseProperty().get();
    }

    public void setLogarithmBase(double value) {
        this.logarithmBaseProperty().set(value);
        this.invalidateRange();
        this.requestAxisLayout();
    }

    @Override
    protected void setRange(AxisRange range, boolean animate) {
        super.setRange(range, animate);
        this.setTickUnit(range.getTickUnit());
    }

    @Override
    protected List<Double> calculateMajorTickValues(double axisLength, AxisRange axisRange) {
        double firstTick;
        ArrayList<Double> tickValues = new ArrayList<Double>();
        if (this.isLogAxis) {
            if (axisRange.getLowerBound() >= axisRange.getUpperBound()) {
                return Arrays.asList(axisRange.getLowerBound());
            }
            double exp = Math.ceil(this.axisTransform.forward(axisRange.getLowerBound()));
            double tickValue = this.axisTransform.backward(exp);
            while (tickValue <= axisRange.getUpperBound()) {
                tickValues.add(tickValue);
                tickValue = this.axisTransform.backward(exp += 1.0);
            }
            return tickValues;
        }
        if (axisRange.getLowerBound() == axisRange.getUpperBound() || axisRange.getTickUnit() <= 0.0) {
            return Arrays.asList(axisRange.getLowerBound());
        }
        for (double major = firstTick = DefaultNumericAxis.computeFistMajorTick(axisRange.getLowerBound(), axisRange.getTickUnit()); major <= axisRange.getUpperBound(); major += axisRange.getTickUnit()) {
            tickValues.add(major);
        }
        return tickValues;
    }

    private static double computeFistMajorTick(double lowerBound, double tickUnit) {
        return Math.ceil(lowerBound / tickUnit) * tickUnit;
    }

    @Override
    protected List<Double> calculateMinorTickValues() {
        if (this.isLogAxis ? this.getMinorTickCount() <= 0 : this.getMinorTickCount() == 0 || this.getTickUnit() == 0.0) {
            return Collections.emptyList();
        }
        ArrayList<Double> minorTickMarks = new ArrayList<Double>();
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double majorUnit = this.getTickUnit();
        if (this.isLogAxis) {
            double exp = Math.floor(this.axisTransform.forward(lowerBound));
            double majorTick = this.axisTransform.backward(exp);
            while (majorTick < upperBound) {
                double nextMajorTick = this.axisTransform.backward(exp + 1.0);
                double minorUnit = (nextMajorTick - majorTick) / (double)this.getMinorTickCount();
                for (double minorTick = majorTick + minorUnit; minorTick < nextMajorTick; minorTick += minorUnit) {
                    if (!(minorTick >= lowerBound) || !(minorTick <= upperBound)) continue;
                    minorTickMarks.add(minorTick);
                }
                majorTick = this.axisTransform.backward(exp += 1.0);
            }
        } else {
            double firstMajorTick = DefaultNumericAxis.computeFistMajorTick(lowerBound, majorUnit);
            double minorUnit = majorUnit / (double)this.getMinorTickCount();
            for (double majorTick = firstMajorTick - majorUnit; majorTick < upperBound; majorTick += majorUnit) {
                double nextMajorTick = majorTick + majorUnit;
                for (double minorTick = majorTick + minorUnit; minorTick < nextMajorTick; minorTick += minorUnit) {
                    if (!(minorTick >= lowerBound) || !(minorTick <= upperBound)) continue;
                    minorTickMarks.add(minorTick);
                }
            }
        }
        return minorTickMarks;
    }

    @Override
    protected AxisRange autoRange(double minValue, double maxValue, double length, double labelSize) {
        double min;
        double d = min = minValue > 0.0 && this.isForceZeroInRange() ? 0.0 : minValue;
        if (this.isLogAxis && minValue <= 0.0) {
            min = 1.0E-6;
            this.isUpdating = true;
            this.setLowerBound(1.0E-6);
            this.isUpdating = false;
        }
        double max = maxValue < 0.0 && this.isForceZeroInRange() ? 0.0 : maxValue;
        double padding = DefaultNumericAxis.getEffectiveRange(min, max) * this.getAutoRangePadding();
        double paddingScale = 1.0 + this.getAutoRangePadding();
        double paddedMin = this.isLogAxis ? minValue / paddingScale : DefaultNumericAxis.clampBoundToZero(min - padding, min);
        double paddedMax = this.isLogAxis ? maxValue * paddingScale : DefaultNumericAxis.clampBoundToZero(max + padding, max);
        return this.computeRange(paddedMin, paddedMax, length, labelSize);
    }

    protected static double getEffectiveRange(double min, double max) {
        double effectiveRange = max - min;
        if (effectiveRange == 0.0) {
            effectiveRange = min == 0.0 ? 2.0 : Math.abs(min);
        }
        return effectiveRange;
    }

    protected static double clampBoundToZero(double paddedBound, double bound) {
        if (paddedBound < 0.0 && bound >= 0.0 || paddedBound > 0.0 && bound <= 0.0) {
            return 0.0;
        }
        return paddedBound;
    }

    @Override
    protected AxisRange computeRange(double min, double max, double axisLength, double labelSize) {
        double minValue = min;
        double maxValue = max;
        if (this.isLogAxis) {
            if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
                minValue = this.axisTransform.getRoundedMinimumRange(minValue);
                maxValue = this.axisTransform.getRoundedMaximumRange(maxValue);
            }
            double newScale = this.calculateNewScale(axisLength, minValue, maxValue);
            return new AxisRange(minValue, maxValue, axisLength, newScale, this.getTickUnit());
        }
        if (maxValue - minValue == 0.0) {
            double padding = this.getAutoRangePadding() < 0.0 ? 0.0 : this.getAutoRangePadding();
            double paddedRange = DefaultNumericAxis.getEffectiveRange(minValue, maxValue) * padding;
            minValue -= paddedRange / 2.0;
            maxValue += paddedRange / 2.0;
        }
        return this.computeRangeImpl(minValue, maxValue, axisLength, labelSize);
    }

    private AxisRange computeRangeImpl(double min, double max, double axisLength, double labelSize) {
        int numOfFittingLabels = (int)Math.floor(axisLength / labelSize);
        int numOfTickMarks = Math.max(Math.min(numOfFittingLabels, 20), 2);
        double rawTickUnit = (max - min) / (double)numOfTickMarks;
        if (rawTickUnit == 0.0 || Double.isNaN(rawTickUnit)) {
            rawTickUnit = 0.001;
        }
        double tickUnitRounded = this.computeTickUnit(rawTickUnit);
        boolean round = (this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding();
        double minRounded = round ? this.axisTransform.getRoundedMinimumRange(min) : min;
        double maxRounded = round ? this.axisTransform.getRoundedMaximumRange(max) : max;
        double newScale = this.calculateNewScale(axisLength, minRounded, maxRounded);
        return new AxisRange(minRounded, maxRounded, axisLength, newScale, tickUnitRounded);
    }

    protected double computeTickUnit(double rawTickUnit) {
        TickUnitSupplier unitSupplier = this.getAxisLabelFormatter().getTickUnitSupplier();
        if (unitSupplier == null) {
            throw new IllegalStateException("class defaults not properly initialised");
        }
        double majorUnit = unitSupplier.computeTickUnit(rawTickUnit);
        if (majorUnit <= 0.0) {
            throw new IllegalArgumentException("The " + unitSupplier.getClass().getName() + " computed illegal unit value [" + majorUnit + "] for argument " + rawTickUnit);
        }
        return majorUnit;
    }

    @Override
    public double computePreferredTickUnit(double axisLength) {
        double labelSize = this.getTickLabelFont().getSize() * 2.0;
        int numOfFittingLabels = (int)Math.floor(axisLength / labelSize);
        int numOfTickMarks = Math.max(Math.min(numOfFittingLabels, 20), 2);
        double rawTickUnit = (this.getUpperBound() - this.getLowerBound()) / (double)numOfTickMarks;
        if (rawTickUnit == 0.0 || Double.isNaN(rawTickUnit)) {
            rawTickUnit = 0.001;
        }
        return this.computeTickUnit(rawTickUnit);
    }

    @Override
    public double getDisplayPosition(double value) {
        if (this.isInvertedAxis) {
            return this.offset - this.getDisplayPositionImpl(value);
        }
        return this.getDisplayPositionImpl(value);
    }

    private double getDisplayPositionImpl(double value) {
        if (this.isLogAxis) {
            double valueLogOffset = this.axisTransform.forward(value) - this.cache.lowerBoundLog;
            if (this.cache.isVerticalAxis) {
                return this.cache.axisHeight - valueLogOffset * this.cache.logScaleLengthInv;
            }
            return valueLogOffset * this.cache.logScaleLengthInv;
        }
        return this.cache.localOffset2 + value * this.cache.localScale;
    }

    @Override
    public double getValueForDisplay(double displayPosition) {
        if (this.isInvertedAxis) {
            return this.getValueForDisplayImpl(this.offset - displayPosition);
        }
        return this.getValueForDisplayImpl(displayPosition);
    }

    private double getValueForDisplayImpl(double displayPosition) {
        if (this.isLogAxis) {
            if (this.cache.isVerticalAxis) {
                double height = this.cache.axisHeight;
                return this.axisTransform.backward(this.cache.lowerBoundLog + (height - displayPosition) / height * this.cache.logScaleLength);
            }
            return this.axisTransform.backward(this.cache.lowerBoundLog + displayPosition / this.cache.axisWidth * this.cache.logScaleLength);
        }
        return this.cache.localCurrentLowerBound + (displayPosition - this.cache.localOffset) / this.cache.localScale;
    }

    @Override
    public double getZeroPosition() {
        if (this.isLogAxis) {
            return this.getDisplayPosition(this.cache.localCurrentLowerBound);
        }
        if (0.0 < this.cache.localCurrentLowerBound || 0.0 > this.cache.localCurrentUpperBound) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    @Override
    public boolean isValueOnAxis(double value) {
        return value >= this.getLowerBound() && value <= this.getUpperBound();
    }

    @Override
    public void requestAxisLayout() {
        if (this.isUpdating) {
            return;
        }
        super.requestAxisLayout();
    }

    @Override
    protected void updateCachedVariables() {
        this.cache.updateCachedAxisVariables();
    }

    protected class Cache {
        protected double localScale;
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double localOffset;
        protected double localOffset2;
        protected double upperBoundLog;
        protected double lowerBoundLog;
        protected double logScaleLength;
        protected double logScaleLengthInv;
        protected boolean isVerticalAxis;
        protected double axisWidth;
        protected double axisHeight;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.axisWidth = DefaultNumericAxis.this.getWidth();
            this.axisHeight = DefaultNumericAxis.this.getHeight();
            this.localCurrentLowerBound = DefaultNumericAxis.this.currentLowerBound.get();
            this.localCurrentUpperBound = DefaultNumericAxis.super.getUpperBound();
            this.upperBoundLog = DefaultNumericAxis.this.axisTransform.forward(DefaultNumericAxis.this.getUpperBound());
            this.lowerBoundLog = DefaultNumericAxis.this.axisTransform.forward(DefaultNumericAxis.this.getLowerBound());
            this.logScaleLength = this.upperBoundLog - this.lowerBoundLog;
            this.logScaleLengthInv = 1.0 / this.logScaleLength;
            this.localScale = DefaultNumericAxis.this.scaleProperty().get();
            double zero = DefaultNumericAxis.super.getDisplayPosition(0.0);
            this.localOffset = zero + this.localCurrentLowerBound * this.localScale;
            this.localOffset2 = this.localOffset - DefaultNumericAxis.this.cache.localCurrentLowerBound * DefaultNumericAxis.this.cache.localScale;
            if (DefaultNumericAxis.this.getSide() != null) {
                this.isVerticalAxis = DefaultNumericAxis.this.getSide().isVertical();
            }
            this.logScaleLengthInv = this.isVerticalAxis ? this.axisHeight / this.logScaleLength : this.axisWidth / this.logScaleLength;
            DefaultNumericAxis.this.offset = this.isVerticalAxis ? DefaultNumericAxis.this.getHeight() : DefaultNumericAxis.this.getWidth();
        }
    }
}

