/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.spi.DataRange;
import java.security.InvalidParameterException;
import java.util.Objects;

public class AxisRange
extends DataRange {
    protected double axisLength;
    protected double scale = 1.0;
    protected double tickUnit;

    public AxisRange() {
        this(0.0, 1.0, 1.0, 1.0, 0.1);
    }

    public AxisRange(double lowerBound, double upperBound, double axisLength, double scale, double tickUnit) {
        super(lowerBound, upperBound);
        if (scale == 0.0) {
            throw new InvalidParameterException("scale should not be '0'");
        }
        if (tickUnit <= 0.0) {
            throw new InvalidParameterException("tickUnit should not be <='0'");
        }
        this.axisLength = axisLength;
        this.scale = scale;
        this.tickUnit = tickUnit;
    }

    public String toString() {
        return String.format("AxisRange [min=%f, max=%f, axisLength=%f, scale=%f, tickUnit=%f]", this.min, this.max, this.axisLength, this.scale, this.tickUnit);
    }

    public double getLowerBound() {
        return this.min;
    }

    public double getUpperBound() {
        return this.max;
    }

    public double getAxisLength() {
        return this.axisLength;
    }

    public double getScale() {
        return this.scale;
    }

    public double getTickUnit() {
        return this.tickUnit;
    }

    public void setAxisLength(double length, Side side) {
        if (length == 0.0) {
            throw new InvalidParameterException("length should not be '0'");
        }
        this.axisLength = length;
        double newScale = 1.0;
        double diff = this.max - this.min;
        newScale = side.isVertical() ? (diff == 0.0 ? -length : -(length / diff)) : (diff == 0.0 ? length : length / diff);
        this.scale = newScale;
        this.tickUnit = diff / 10.0;
    }

    public void add(AxisRange range) {
        this.add(range.min);
        this.add(range.max);
    }

    public AxisRange substract(AxisRange range) {
        if (range.min > this.max || range.max < this.min) {
            return this;
        }
        this.min = Math.max(this.min, range.min);
        this.max = Math.min(this.max, range.max);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.axisLength, this.scale, this.tickUnit);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AxisRange)) {
            return false;
        }
        return ((AxisRange)((Object)obj)).hashCode() == this.hashCode();
    }

    public AxisRange copy() {
        return new AxisRange(this.getLowerBound(), this.getUpperBound(), this.getAxisLength(), this.getScale(), this.getTickUnit());
    }
}

