/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.ui;

import de.gsi.chart.viewer.SquareButton;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;

public class AcquisitionButtonBar
extends HBox {
    private static final String DEFAULT_CSS = AcquisitionButtonBar.class.getResource("acq_button_small.css").toExternalForm();
    private static final PseudoClass PSEUDO_CLASS_ACTIVATED = PseudoClass.getPseudoClass((String)"activated");
    private static final PseudoClass PSEUDO_CLASS_PAUSE = PseudoClass.getPseudoClass((String)"paused");
    private final Button buttonPlayStop = new SquareButton("my-playstop-button");
    private final Button buttonPlay = new SquareButton("my-play-button");
    private final Button buttonStop = new SquareButton("my-stop-button");
    private final BooleanProperty pauseState = new SimpleBooleanProperty((Object)this, "buttonPauseState", false);
    private final BooleanProperty playStopState = new SimpleBooleanProperty((Object)this, "buttonPlayStopState", false);
    private final BooleanProperty playState = new SimpleBooleanProperty((Object)this, "buttonPlayState", false);
    private final BooleanProperty stopState = new SimpleBooleanProperty((Object)this, "buttonStopState", true);

    public AcquisitionButtonBar(@NamedArg(value="isPauseEnabled") boolean isPauseEnabled) {
        if (this.getStylesheets().isEmpty()) {
            this.getStylesheets().add((Object)DEFAULT_CSS);
        }
        this.disabledProperty().addListener((ch, o, n) -> {
            this.buttonPlayStop.setDisable(n.booleanValue());
            this.buttonPlay.setDisable(n.booleanValue());
            this.buttonStop.setDisable(n.booleanValue());
        });
        this.buttonPlayStop.disableProperty().addListener((ch, o, n) -> {
            if (Boolean.TRUE.equals(n)) {
                this.playStopState.set(false);
            }
        });
        this.buttonPlay.disableProperty().addListener((ch, o, n) -> {
            if (Boolean.TRUE.equals(n)) {
                this.playState.set(false);
            }
        });
        this.buttonStop.disableProperty().addListener((ch, o, n) -> this.stopState.set(n == false));
        this.pauseState.addListener((ch, o, n) -> {
            if (isPauseEnabled) {
                if (Boolean.TRUE.equals(n)) {
                    this.playState.set(true);
                }
                this.buttonPlay.pseudoClassStateChanged(PSEUDO_CLASS_PAUSE, isPauseEnabled ? n.booleanValue() : this.playState.get());
            } else {
                this.pauseState.set(false);
            }
        });
        this.buttonPlayStop.setOnAction(evt -> this.playStopState.set(!this.playStopState.get()));
        this.playStopState.addListener((ch, o, n) -> {
            this.buttonPlay.setDisable(n.booleanValue());
            this.stopState.set(n == false);
            this.buttonStop.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, n.booleanValue());
            this.buttonPlayStop.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, n.booleanValue());
            if (Boolean.TRUE.equals(n)) {
                this.buttonPlay.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, false);
                this.buttonPlay.pseudoClassStateChanged(PSEUDO_CLASS_PAUSE, false);
            }
        });
        this.buttonPlay.setOnAction(evt -> {
            if (isPauseEnabled) {
                if (this.playState.get()) {
                    this.pauseState.set(!this.pauseState.get());
                } else {
                    this.playState.set(true);
                }
            } else {
                this.playState.set(!this.playState.get());
                this.pauseState.set(false);
            }
        });
        this.playState.addListener((ch, o, n) -> {
            this.buttonPlayStop.setDisable(n.booleanValue());
            this.stopState.set(n == false);
            this.buttonStop.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, n.booleanValue());
            this.buttonPlay.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, n.booleanValue());
            this.buttonPlay.pseudoClassStateChanged(PSEUDO_CLASS_PAUSE, !isPauseEnabled || this.pauseState.get());
        });
        this.buttonStop.setOnAction(evt -> this.stopState.set(!this.stopState.get()));
        this.stopState.addListener((ch, o, n) -> {
            if (Boolean.TRUE.equals(n)) {
                this.pauseState.set(false);
                this.playStopState.set(false);
                this.playState.set(false);
                this.buttonPlayStop.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, false);
                this.buttonPlay.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, false);
                this.buttonPlayStop.setDisable(false);
                this.buttonPlay.setDisable(false);
            }
            this.buttonStop.pseudoClassStateChanged(PSEUDO_CLASS_ACTIVATED, n == false);
        });
        this.getChildren().addAll((Object[])new Node[]{this.buttonPlayStop, this.buttonPlay, this.buttonStop});
    }

    public Button getButtonPlay() {
        return this.buttonPlay;
    }

    public Button getButtonPlayStop() {
        return this.buttonPlayStop;
    }

    public Button getButtonStop() {
        return this.buttonStop;
    }

    public BooleanProperty pauseStateProperty() {
        return this.pauseState;
    }

    public BooleanProperty playStateProperty() {
        return this.playState;
    }

    public BooleanProperty playStopStateProperty() {
        return this.playStopState;
    }

    public BooleanProperty stopStateProperty() {
        return this.stopState;
    }
}

