/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote.clipboard;

import ar.com.hjg.pngj.FilterType;
import de.gsi.acc.remote.BasicRestRoles;
import de.gsi.acc.remote.RestCommonThreadPool;
import de.gsi.acc.remote.RestServer;
import de.gsi.acc.remote.util.CombinedHandler;
import de.gsi.acc.remote.util.MessageBundle;
import de.gsi.chart.utils.FXUtils;
import de.gsi.chart.utils.PaletteQuantizer;
import de.gsi.chart.utils.WritableImageCache;
import de.gsi.chart.utils.WriteFxImage;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventRateLimiter;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.remote.DataContainer;
import de.gsi.dataset.remote.MimeType;
import de.gsi.dataset.utils.ByteArrayCache;
import de.gsi.dataset.utils.Cache;
import de.gsi.dataset.utils.GenericsHelper;
import de.gsi.math.Math;
import de.gsi.math.MathBase;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.sse.SseClient;
import io.javalin.plugin.openapi.annotations.HttpMethod;
import io.javalin.plugin.openapi.annotations.OpenApi;
import io.javalin.plugin.openapi.annotations.OpenApiContent;
import io.javalin.plugin.openapi.annotations.OpenApiFileUpload;
import io.javalin.plugin.openapi.annotations.OpenApiFormParam;
import io.javalin.plugin.openapi.annotations.OpenApiParam;
import io.javalin.plugin.openapi.annotations.OpenApiRequestBody;
import io.javalin.plugin.openapi.annotations.OpenApiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clipboard
implements EventSource,
EventListener {
    public static final String ERROR_WHILE_READING_TEST_IMAGE_FROM = "error while reading test image from '{}'";
    private static final Logger LOGGER = LoggerFactory.getLogger(Clipboard.class);
    private static final int DEFAULT_PALETTE_COLOR_COUNT = 32;
    private static final int STATISTICS_INT_COUNT = 250;
    private static final boolean IMAGE_USE_ALPHA = true;
    private static final String TESTIMAGE = "PM5544_test_signal.png";
    private static final String DOT_PNG = ".png";
    private static final String QUERY_UPDATE_PERIOD = "updatePeriod";
    private static final String QUERY_LONG_POLLING = "longpolling";
    private static final String QUERY_SSE = "sse";
    private static final String QUERY_LAST_UPDATE = "lastAccess.";
    private static final String CLIPBOARD_BASE = "/clipboard/";
    private static final String CLIPBOARD_ROOT = "";
    private static final String CLIPBOARD_DEFAULT = "misc/";
    private static final String ENDPOINT_UPLOAD = "/upload";
    private static final String ENDPOINT_CLIPBOARD = "/clipboard/*";
    private static final String TEMPLATE_UPLOAD = "/velocity/clipboard/upload.vm";
    private static final String TEMPLATE_ALL_IMAGES = "/velocity/clipboard/all.vm";
    private static final String TEMPLATE_ONE_IMAGE_LONG_POLLING = "/velocity/clipboard/one_long.vm";
    private static final String TEMPLATE_ONE_IMAGE_SSE = "/velocity/clipboard/one_sse.vm";
    private static final String CACHE_LIMIT = "clipboardCacheLimit";
    private static final int CACHE_LIMIT_DEFAULT = 25;
    private static final String CACHE_TIME_OUT = "clipboardCacheTimeOut";
    private static final int CACHE_TIME_OUT_DEFAULT = 60;
    private final AtomicBoolean autoNotify = new AtomicBoolean(true);
    private final List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    private final Lock clipboardLock = new ReentrantLock();
    private final Condition clipboardCondition = this.clipboardLock.newCondition();
    private final Cache<String, Cache<String, DataContainer>> clipboardCacheCategory;
    private final SnapshotParameters snapshotParameters = new SnapshotParameters();
    private final Cache<String, String> userCounterCache = Cache.builder().withTimeout(1L, TimeUnit.MINUTES).build();
    private final IntegerProperty userCount = new SimpleIntegerProperty((Object)this, "userCount", 0);
    private final IntegerProperty userCountSse = new SimpleIntegerProperty((Object)this, "userCountSse", 0);
    private final String exportRoot;
    private final String exportNameImage;
    private final Region regionToCapture;
    private final long maxUpdatePeriod;
    private final TimeUnit maxUpdatePeriodTimeUnit;
    private final WritableImageCache imageCache = new WritableImageCache();
    private final ByteArrayCache byteArrayCache = new ByteArrayCache();
    private final EventRateLimiter eventRateLimiter;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final List<Double> captureDiffs = new ArrayList<Double>(250);
    private final List<Double> processingTotal = new ArrayList<Double>(250);
    private final List<Double> sizeTotal = new ArrayList<Double>(250);
    private boolean usePalette;
    private PaletteQuantizer userPalette = null;
    private final EventListener paletteUpdateListener = evt -> {
        if (evt.getPayLoad() instanceof Image) {
            RestCommonThreadPool.getCommonPool().execute(() -> {
                this.userPalette = WriteFxImage.estimatePalette((Image)((Image)evt.getPayLoad()), (boolean)true, (int)32);
            });
        }
    };
    private EventRateLimiter paletteUpdateRateLimiter = new EventRateLimiter(this.paletteUpdateListener, TimeUnit.SECONDS.toMillis(20L));
    @OpenApi(description="endpoint to provide html form data to upload clipboard data", summary="GET", tags={"Clipboard"}, path="/upload", method=HttpMethod.GET, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")}), @OpenApiResponse(status="200", content={@OpenApiContent(type="text/json")})})
    private final Handler uploadHandlerGet = new CombinedHandler(ctx -> {
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        ctx.render(TEMPLATE_UPLOAD, model);
    }){};
    private final Function<? super String, ? extends Cache<String, DataContainer>> categoryMappingFunction = category -> {
        Cache.CacheBuilder clipboardCacheBuilder = Cache.builder().withLimit(Clipboard.getCacheLimit());
        if (Clipboard.getCacheTimeOut() > 0) {
            clipboardCacheBuilder.withTimeout((long)Clipboard.getCacheTimeOut(), Clipboard.getCacheTimeOutUnit());
        }
        BiConsumer<String, DataContainer> cacheRecoverAction = (k, v) -> RestCommonThreadPool.getCommonScheduledPool().schedule(() -> v.getData().forEach(d -> this.byteArrayCache.add((Object)d.getDataByteArray())), 200L, TimeUnit.MILLISECONDS);
        return clipboardCacheBuilder.withPostListener(cacheRecoverAction).build();
    };
    private final Runnable convertImage = () -> {
        WritableImage imageCopyOut;
        long start = System.nanoTime();
        int width = (int)this.getRegionToCapture().getWidth();
        int height = (int)this.getRegionToCapture().getHeight();
        if (this.threadCount.get() > 1 || width == 0 || height == 0) {
            return;
        }
        this.threadCount.incrementAndGet();
        WritableImage imageCopyIn = this.imageCache.getImage(width, height);
        try {
            imageCopyOut = (WritableImage)FXUtils.runAndWait(() -> this.getRegionToCapture().snapshot(this.snapshotParameters, imageCopyIn));
        }
        catch (Exception e) {
            LOGGER.atError().setCause((Throwable)e).log("snapshotListener -> Node::snapshot(..)");
            this.threadCount.decrementAndGet();
            return;
        }
        this.captureDiffs.add((double)(System.nanoTime() - start) / 1000000.0);
        if (imageCopyOut == null) {
            LOGGER.atDebug().addArgument((Object)width).addArgument((Object)height).log("snapshotListener - return image is null - requested '{}x{}'");
            this.threadCount.decrementAndGet();
            return;
        }
        long mid = System.nanoTime();
        int size2 = WriteFxImage.getCompressedSizeBound((int)width, (int)height, (boolean)true);
        byte[] rawByteBuffer = this.byteArrayCache.getArray(size2);
        ByteBuffer imageBuffer = ByteBuffer.wrap(rawByteBuffer);
        if (this.usePalette) {
            WriteFxImage.encodePalette((Image)imageCopyOut, (ByteBuffer)imageBuffer, (boolean)true, (int)1, (FilterType)FilterType.FILTER_NONE, (PaletteQuantizer[])new PaletteQuantizer[]{this.userPalette});
        } else {
            WriteFxImage.encode((Image)imageCopyOut, (ByteBuffer)imageBuffer, (boolean)true, (int)1, (FilterType)FilterType.FILTER_NONE);
        }
        this.sizeTotal.add(Double.valueOf(imageBuffer.limit()));
        this.imageCache.add((Object)imageCopyIn);
        this.imageCache.add((Object)imageCopyOut);
        LOGGER.atDebug().addArgument((Object)this.getExportNameImage()).addArgument((Object)this.getExportNameImage()).log("new image '{}' for export name '{}' generated -> notify listener");
        int maxUpdatePeriodMillis = (int)this.getMaxUpdatePeriodTimeUnit().toMillis(this.getMaxUpdatePeriod());
        this.addClipboardData(new DataContainer(this.getExportNameImage(), (long)maxUpdatePeriodMillis, imageBuffer.array(), imageBuffer.limit()));
        this.processingTotal.add((double)(System.nanoTime() - mid) / 1000000.0);
        Clipboard.printDiffs("capture", "ms", this.captureDiffs);
        Clipboard.printDiffs("processingTotal", "ms", this.processingTotal);
        Clipboard.printDiffs("sizeTotal", "bytes", this.sizeTotal);
        int threads = this.threadCount.decrementAndGet();
        if (threads > 1) {
            LOGGER.atWarn().addArgument((Object)threads).log("thread-pile-up = {}");
        }
    };
    @OpenApi(description="clipboard root", summary="My Summary", tags={"Clipboard"}, path="/clipboard/*", method=HttpMethod.GET, headers={@OpenApiParam(name="my-custom-header")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")}), @OpenApiResponse(status="200", content={@OpenApiContent(type="image/png")}), @OpenApiResponse(status="200", content={@OpenApiContent(type="text/event-stream")})})
    private final Handler exportHandler = new CombinedHandler(ctx -> {
        long maxUpdateMillis = this.getMaxUpdatePeriodTimeUnit().toMillis(this.getMaxUpdatePeriod());
        int maxUpdateRate = 1000 / (int)maxUpdateMillis;
        RestServer.applyRateLimit(ctx, 2 * maxUpdateRate, TimeUnit.SECONDS);
        RestServer.suppressCaching(ctx);
        String landingPage = ctx.path().replaceFirst(CLIPBOARD_BASE, CLIPBOARD_ROOT);
        String category = Clipboard.fixPreAndPost(Clipboard.getCategoryFromPath(landingPage));
        Cache categoryMap = (Cache)this.getClipboardCache().get((Object)category);
        if (categoryMap == null) {
            ctx.status(404).result(this.categoryNotFound(category));
            return;
        }
        String imageDataTag = landingPage.replaceFirst(Clipboard.getCategoryFromPath(landingPage), CLIPBOARD_ROOT);
        if (imageDataTag.isBlank() || !imageDataTag.contains(".")) {
            if (imageDataTag.isBlank()) {
                this.serveCategoryOverview(ctx, category);
                return;
            }
            Map.Entry matchingEntry = categoryMap.entrySet().stream().filter(kv -> ((DataContainer)kv.getValue()).getExportName().equals(imageDataTag)).findFirst().orElse(null);
            if (matchingEntry == null) {
                this.serveCategoryOverview(ctx, category);
                return;
            }
            DataContainer matchedClipboardData = (DataContainer)matchingEntry.getValue();
            this.serveImageDataLandingPage(ctx, category, matchedClipboardData);
            return;
        }
        this.serveImageData(ctx, category, imageDataTag);
    }){};
    @OpenApi(description="endpoint for posting clipboard data", summary="submit new clipboard data", tags={"Clipboard"}, path="/upload", method=HttpMethod.POST, formParams={@OpenApiFormParam(name="clipboarExportName"), @OpenApiFormParam(name="clipboarCategoryName")}, fileUploads={@OpenApiFileUpload(name="clipboardData", isArray=true)}, requestBody=@OpenApiRequestBody(content={@OpenApiContent(type="text/html"), @OpenApiContent(type="application/binary-new-protocol"), @OpenApiContent(type="application/binary-legacy"), @OpenApiContent(from=DataContainer.class)}), responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")}), @OpenApiResponse(status="200", content={@OpenApiContent(type="text/json")}), @OpenApiResponse(status="200", content={@OpenApiContent(from=DataContainer.class)})})
    private final Handler uploadHandlerPost = new CombinedHandler(ctx -> {
        String exportName = ctx.formParam("clipboarExportName");
        String rawCategory = ctx.formParam("clipboarCategoryName");
        String category = Clipboard.fixPreAndPost(rawCategory == null || rawCategory.isBlank() ? CLIPBOARD_DEFAULT : rawCategory);
        LOGGER.atDebug().addArgument((Object)exportName).log("received export name = '{}'");
        LOGGER.atInfo().addArgument((Object)exportName).log("received export name = '{}'");
        LOGGER.atInfo().addArgument((Object)ctx.formParam("clipboarCategoryName")).log("received category name = '{}'");
        ctx.uploadedFiles("clipboardData").forEach(file -> {
            String fileName = file.getFilename();
            if (exportName == null || exportName.isBlank() || !fileName.contains(".")) {
                try {
                    byte[] fileData = file.getContent().readAllBytes();
                    this.addClipboardData(new DataContainer(category + fileName, -1L, fileData, fileData.length));
                }
                catch (IOException e) {
                    LOGGER.atError().setCause((Throwable)e).addArgument((Object)fileName).log(ERROR_WHILE_READING_TEST_IMAGE_FROM);
                }
                LOGGER.atInfo().addArgument((Object)fileName).log("upload received: '{}'");
                return;
            }
            int p = fileName.lastIndexOf(47);
            if (p < 0) {
                p = 0;
            }
            String[] exportNameData = fileName.substring(p).replace("/", CLIPBOARD_ROOT).split("\\.");
            String export = exportName.replace(" ", "_") + "." + exportNameData[1];
            try {
                byte[] fileData = file.getContent().readAllBytes();
                this.addClipboardData(new DataContainer(category + export, -1L, fileData, fileData.length));
            }
            catch (IOException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)file.getFilename()).log(ERROR_WHILE_READING_TEST_IMAGE_FROM);
            }
            LOGGER.atInfo().addArgument((Object)fileName).addArgument((Object)export).log("upload received: '{}' as '{}'");
        });
        ctx.redirect(this.getExportRoot());
    }){};
    @OpenApi(description="landing page", summary="root export", tags={"Clipboard"}, path="/", method=HttpMethod.GET, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")}), @OpenApiResponse(status="200", content={@OpenApiContent(type="text/json")})})
    private final Handler rootHandler = new CombinedHandler(ctx -> this.serveCategoryOverview(ctx, Clipboard.fixPreAndPost(CLIPBOARD_ROOT))){};

    public Clipboard(String exportRoot, String exportName, Region regionToCapture, long maxUpdatePeriod, TimeUnit maxUpdatePeriodTimeUnit, boolean allowUploads) {
        this.exportRoot = exportRoot;
        this.exportNameImage = exportName + DOT_PNG;
        this.regionToCapture = regionToCapture;
        this.maxUpdatePeriod = maxUpdatePeriod;
        this.maxUpdatePeriodTimeUnit = maxUpdatePeriodTimeUnit;
        Cache.CacheBuilder clipboardCacheBuilder = Cache.builder().withLimit(Clipboard.getCacheLimit());
        if (Clipboard.getCacheTimeOut() > 0) {
            clipboardCacheBuilder.withTimeout((long)Clipboard.getCacheTimeOut(), Clipboard.getCacheTimeOutUnit());
        }
        this.clipboardCacheCategory = clipboardCacheBuilder.build();
        this.eventRateLimiter = new EventRateLimiter(evt -> RestCommonThreadPool.getCommonPool().execute(this.convertImage), maxUpdatePeriodTimeUnit.toMillis(maxUpdatePeriod));
        Set<BasicRestRoles> accessRoles = Collections.singleton(BasicRestRoles.ANYONE);
        RestServer.getInstance().get(exportRoot, this.rootHandler, accessRoles);
        RestServer.getInstance().get(RestServer.prefixPath(ENDPOINT_CLIPBOARD), this.exportHandler, accessRoles);
        if (allowUploads) {
            RestServer.getInstance().get(exportRoot + ENDPOINT_UPLOAD, this.uploadHandlerGet, Set.of(BasicRestRoles.ADMIN, BasicRestRoles.READ_WRITE));
            RestServer.getInstance().post(exportRoot + ENDPOINT_UPLOAD, this.uploadHandlerPost, Set.of(BasicRestRoles.ADMIN, BasicRestRoles.READ_WRITE));
        }
    }

    public void addClipboardData(@NotNull DataContainer data) {
        RestCommonThreadPool.getCommonPool().execute(() -> {
            try {
                this.clipboardLock.lock();
                String category = data.getCategory() == null ? CLIPBOARD_ROOT : data.getCategory();
                Cache<String, DataContainer> categoryMap = this.getClipboardCache(category);
                DataContainer ret = (DataContainer)categoryMap.put((Object)data.getExportNameData(), (Object)data);
                LOGGER.atDebug().addArgument((Object)data.getCategory()).addArgument((Object)data.getExportName()).addArgument((Object)data.getExportNameData()).addArgument((Object)ret).log("adding c = '{}' ex = '{}' exData = '{}' previous data = {}");
                data.updateAccess();
                this.updateListener(CLIPBOARD_BASE + data.getCategory() + data.getExportNameData(), data.getTimeStampCreation());
                this.clipboardCondition.signalAll();
            }
            finally {
                this.clipboardLock.unlock();
            }
        });
    }

    public void addTestImageData() {
        try (InputStream in = Clipboard.class.getResourceAsStream(TESTIMAGE);){
            byte[] fileContent = in.readAllBytes();
            this.addClipboardData(new DataContainer("test.png", -1L, fileContent, fileContent.length));
            this.addClipboardData(new DataContainer("misc/test0.png", -1L, fileContent, fileContent.length));
            this.addClipboardData(new DataContainer("misc/misc/test1.png", -1L, fileContent, fileContent.length));
            this.addClipboardData(new DataContainer("misc/misc/test2.bin", -1L, fileContent, fileContent.length));
        }
        catch (IOException e) {
            URL res = DataContainer.class.getResource(TESTIMAGE);
            LOGGER.atError().setCause((Throwable)e).addArgument((Object)(res == null ? null : res.getPath())).log(ERROR_WHILE_READING_TEST_IMAGE_FROM);
        }
    }

    public AtomicBoolean autoNotification() {
        return this.autoNotify;
    }

    public Cache<String, Cache<String, DataContainer>> getClipboardCache() {
        return this.clipboardCacheCategory;
    }

    public Cache<String, DataContainer> getClipboardCache(String category) {
        return (Cache)this.clipboardCacheCategory.computeIfAbsent((Object)Clipboard.fixPreAndPost(category), this.categoryMappingFunction);
    }

    public String getExportNameImage() {
        return this.exportNameImage;
    }

    public String getExportRoot() {
        return this.exportRoot;
    }

    public URI getLocalURI() {
        return URI.create(Objects.requireNonNull(RestServer.getLocalURI()).toString() + RestServer.prefixPath(this.getExportRoot()));
    }

    public long getMaxUpdatePeriod() {
        return this.maxUpdatePeriod;
    }

    public TimeUnit getMaxUpdatePeriodTimeUnit() {
        return this.maxUpdatePeriodTimeUnit;
    }

    public EventRateLimiter getPaletteUpdateRateLimiter() {
        return this.paletteUpdateRateLimiter;
    }

    public URI getPublicURI() {
        return URI.create(Objects.requireNonNull(RestServer.getPublicURI()).toString() + RestServer.prefixPath(this.getExportRoot()));
    }

    public Region getRegionToCapture() {
        return this.regionToCapture;
    }

    public void handle(UpdateEvent event) {
        this.eventRateLimiter.handle(event);
    }

    public boolean isUsePalette() {
        return this.usePalette;
    }

    public void setPaletteUpdateRateLimiter(long timeOut, TimeUnit timeUnit) {
        this.paletteUpdateRateLimiter = new EventRateLimiter(this.paletteUpdateListener, timeUnit.toMillis(timeOut));
    }

    public void setUsePalette(boolean usePalette) {
        this.usePalette = usePalette;
    }

    public List<EventListener> updateEventListener() {
        return this.updateListeners;
    }

    public void updateListener(@NotNull String eventSource, long eventTimeStamp) {
        Queue<SseClient> sseClients = RestServer.getEventClients(eventSource);
        FXUtils.runFX(() -> this.userCountSse.set(sseClients.size()));
        sseClients.forEach(client -> client.sendEvent("new '" + eventSource + "' @" + eventTimeStamp));
    }

    public ReadOnlyIntegerProperty userCountProperty() {
        return this.userCount;
    }

    public ReadOnlyIntegerProperty userCountSseProperty() {
        return this.userCountSse;
    }

    protected void updatePalette(Image imageCopyOut) {
        this.paletteUpdateRateLimiter.handle(new UpdateEvent((EventSource)this, "update palette", (Object)WriteFxImage.clone((Image)imageCopyOut)));
    }

    private String categoryNotFound(String category) {
        return "category = " + category + " not found";
    }

    private void serveCategoryOverview(Context ctx, String category) {
        if (this.getClipboardCache().get((Object)category) == null) {
            ctx.status(404).result(this.categoryNotFound(category));
            return;
        }
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        model.put("root", this.getExportRoot());
        model.put("category", category);
        Predicate<String> categoryFilter = cat -> cat.startsWith(category) && !cat.equals(category);
        List subCategories = this.getClipboardCache().keySet().stream().filter(categoryFilter).collect(Collectors.toList());
        model.put("categories", subCategories);
        Predicate<DataContainer> nonDisplayableDataFilter = cat -> MimeType.getEnum((String)cat.getMimeType()).isNonDisplayableData();
        model.put("images", this.getClipboardCache(category).values().stream().filter(nonDisplayableDataFilter.negate()).collect(Collectors.toList()));
        model.put("data", this.getClipboardCache(category).values().stream().filter(nonDisplayableDataFilter).collect(Collectors.toList()));
        ctx.render(TEMPLATE_ALL_IMAGES, model);
    }

    private void serveImageData(Context ctx, String category, String imageDataTag) {
        Cache<String, DataContainer> categoryMap = this.getClipboardCache(category);
        DataContainer cbData = (DataContainer)categoryMap.get((Object)imageDataTag);
        if (cbData == null) {
            ctx.status(404).result("category = " + category + " and imageDataTag " + imageDataTag + " not found");
            return;
        }
        boolean isLongPolling = ctx.queryParam(QUERY_LONG_POLLING) != null;
        String identifier = ctx.req.getRemoteAddr();
        this.userCounterCache.put((Object)identifier, (Object)ctx.req.getProtocol());
        FXUtils.runFX(() -> this.userCount.set(this.userCounterCache.size()));
        Long sessionUpdate = (Long)ctx.sessionAttribute(QUERY_LAST_UPDATE + ctx.path());
        long lastUpdate = sessionUpdate == null ? 0L : sessionUpdate;
        ctx.contentType(MimeType.PNG.toString());
        while (cbData.getTimeStampCreation() <= lastUpdate && isLongPolling) {
            try {
                boolean condition1;
                long waitPeriod = MathBase.max((long)TimeUnit.SECONDS.toMillis(1L), (long)(4L * cbData.getUpdatePeriod()));
                this.clipboardLock.lock();
                boolean bl = condition1 = !this.clipboardCondition.await(waitPeriod, TimeUnit.MILLISECONDS) && LOGGER.isInfoEnabled();
                if (condition1) {
                    LOGGER.atInfo().log("aborted a possibly too long long-polling await");
                }
                this.clipboardLock.unlock();
            }
            catch (InterruptedException e) {
                this.clipboardLock.unlock();
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)imageDataTag).log("waiting for new image '{}' to be updated");
                Thread.currentThread().interrupt();
            }
            if ((cbData = (DataContainer)categoryMap.get((Object)imageDataTag)) != null) continue;
            return;
        }
        ctx.sessionAttribute(QUERY_LAST_UPDATE + ctx.path(), (Object)cbData.getTimeStampCreation());
        ctx.res.setContentType(cbData.getMimeType());
        RestServer.writeBytesToContext(ctx, cbData.getDataByteArray(), cbData.getDataByteArraySize());
    }

    private void serveImageDataLandingPage(Context ctx, String category, DataContainer data) {
        String updatePeriodString = ctx.queryParam(QUERY_UPDATE_PERIOD, "1000");
        long updatePeriod = 500L;
        if (updatePeriodString != null) {
            try {
                updatePeriod = Long.parseLong(updatePeriodString);
            }
            catch (NumberFormatException e) {
                String clientIp = ctx.req.getRemoteHost();
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)updatePeriodString).addArgument((Object)clientIp).log("could not parse 'updatePeriod'={} argument sent by client {}");
            }
        }
        updatePeriod = MathBase.max((long)this.getMaxUpdatePeriod(), (long)updatePeriod);
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        model.put("indexRoot", CLIPBOARD_BASE + category);
        model.put(QUERY_UPDATE_PERIOD, updatePeriod);
        model.put("title", data.getExportName());
        model.put("imageLanding", CLIPBOARD_BASE + data.getExportName() + "?updatePeriod=" + data.getUpdatePeriod());
        model.put("imageSource", CLIPBOARD_BASE + category + data.getExportNameData());
        model.put(QUERY_LONG_POLLING, QUERY_LONG_POLLING);
        if (ctx.queryParam(QUERY_SSE) == null) {
            ctx.render(TEMPLATE_ONE_IMAGE_LONG_POLLING, model);
        } else {
            ctx.render(TEMPLATE_ONE_IMAGE_SSE, model);
        }
    }

    public static int getCacheLimit() {
        String property = System.getProperty(CACHE_LIMIT, Integer.toString(25));
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            LOGGER.atError().addArgument((Object)CACHE_LIMIT).addArgument((Object)property).addArgument((Object)25).log("could not parse {}='{}' return default limit {}");
            return 25;
        }
    }

    public static int getCacheTimeOut() {
        String property = System.getProperty(CACHE_TIME_OUT, Integer.toString(60));
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            LOGGER.atError().addArgument((Object)CACHE_TIME_OUT).addArgument((Object)property).addArgument((Object)60).log("could not parse {}='{}' return default timeout {} [minutes]");
            return 60;
        }
    }

    public static TimeUnit getCacheTimeOutUnit() {
        return TimeUnit.MINUTES;
    }

    private static String fixPreAndPost(String name) {
        Object fixedPrefix = name.startsWith("/") ? name : "/" + name;
        return ((String)fixedPrefix).endsWith("/") ? fixedPrefix : (String)fixedPrefix + "/";
    }

    private static String getCategoryFromPath(String name) {
        if (name.isBlank()) {
            return name;
        }
        int p = name.lastIndexOf(47);
        if (p < 0) {
            return CLIPBOARD_ROOT;
        }
        return name.substring(0, p + 1);
    }

    private static void printDiffs(String title, String unit, List<Double> diffArray) {
        double[] values = GenericsHelper.toDoublePrimitive((Object[])diffArray.toArray(new Double[0]));
        if (diffArray.size() >= 250) {
            double mean;
            if (LOGGER.isDebugEnabled() && (mean = Math.mean((double[])values)) > 40.0) {
                double rms = Math.rms((double[])values);
                String msg = String.format("processing delays: %-15s  (%3d): dT = %4.1f +- %4.1f %s", title, diffArray.size(), mean, rms, unit);
                LOGGER.atDebug().log(msg);
            }
            diffArray.clear();
        }
    }
}

