/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote.admin;

import de.gsi.acc.remote.BasicRestRoles;
import de.gsi.acc.remote.RestServer;
import de.gsi.acc.remote.login.LoginController;
import de.gsi.acc.remote.user.RestUserHandler;
import de.gsi.acc.remote.util.MessageBundle;
import io.javalin.apibuilder.ApiBuilder;
import io.javalin.core.security.Role;
import io.javalin.http.Handler;
import io.javalin.plugin.openapi.annotations.OpenApi;
import io.javalin.plugin.openapi.annotations.OpenApiContent;
import io.javalin.plugin.openapi.annotations.OpenApiResponse;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServerAdmin {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerAdmin.class);
    private static final String ENDPOINT_ADMIN = "/admin";
    private static final String TEMPLATE_ADMIN = "/velocity/admin/admin.vm";
    @OpenApi(description="endpoint to receive admin requests", operationId="serveAdminPage", summary="serve ", deprecated=false, tags={"RestServerAdmin"}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")})})
    private static final Handler serveAdminPage = ctx -> {
        String userName = LoginController.getSessionCurrentUser(ctx);
        Set<Role> roles = LoginController.getSessionCurrentRoles(ctx);
        if (!roles.contains((Object)BasicRestRoles.ADMIN)) {
            LOGGER.atWarn().addArgument((Object)userName).log("user '{}' does not have the required admin access rights");
            ctx.status(401).result("admin access denied");
            return;
        }
        RestUserHandler userHandler = RestServer.getUserHandler();
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        model.put("userHandler", userHandler);
        model.put("users", userHandler.getAllUserNames());
        model.put("endpoints", RestServer.getEndpoints());
        ctx.render(TEMPLATE_ADMIN, model);
    };
    @OpenApi(description="endpoint to receive admin requests", operationId="handleAdminPost", summary="POST ", deprecated=false, tags={"RestServerAdmin"}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")})})
    private static final Handler handleAdminPost = ctx -> {
        String userName = LoginController.getSessionCurrentUser(ctx);
        Set<Role> roles = LoginController.getSessionCurrentRoles(ctx);
        if (!roles.contains((Object)BasicRestRoles.ADMIN)) {
            LOGGER.atWarn().addArgument((Object)userName).log("user '{}' does not have the required admin access rights");
            ctx.status(401).result("admin access denied");
            return;
        }
        Map<String, Object> model = MessageBundle.baseModel(ctx);
        ctx.render(TEMPLATE_ADMIN, model);
    };

    public static void register() {
        RestServer.getInstance().routes(() -> {
            ApiBuilder.post((String)ENDPOINT_ADMIN, (Handler)handleAdminPost, Collections.singleton(BasicRestRoles.ADMIN));
            ApiBuilder.get((String)ENDPOINT_ADMIN, (Handler)serveAdminPage, Collections.singleton(BasicRestRoles.ADMIN));
        });
    }
}

