/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote.util;

import de.gsi.acc.remote.RestServer;
import de.gsi.acc.remote.util.CombinedHandler;
import de.gsi.acc.remote.util.MessageBundle;
import de.gsi.dataset.remote.MimeType;
import io.javalin.http.Handler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Property<G, S, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Property.class);
    private static final String ACCEPT_HEADER = "Accept";
    private final String propertyName;
    private final String htmlModelGet;
    private final String htmlModelSet;

    public Property(@NotNull String propertyName, @NotNull String htmlModelGet, @NotNull Class<G> dataClassPrototypeGet, @NotNull PropertyHandler userHandlerGet, @NotNull String htmlModelSet, @NotNull Class<S> dataClassPrototypeSet, @NotNull PropertyHandler userHandlerSet) {
        this.propertyName = propertyName;
        this.htmlModelGet = htmlModelGet;
        this.htmlModelSet = htmlModelSet;
        Handler handler = ctx -> {
            String type = ctx.header(ACCEPT_HEADER);
            String contentType = ctx.req.getContentType();
            LOGGER.atInfo().addArgument((Object)propertyName).addArgument((Object)type).addArgument((Object)contentType).log("property {} handle type {} contentType {}");
            if (type == null || type.equalsIgnoreCase(MimeType.HTML.toString())) {
                Map<String, Object> model = MessageBundle.baseModel(ctx);
                model.put("property", propertyName);
                model.put("selector", "FAIR.SELECTOR.ALL");
                HashMap<String, Object> fromUser = new HashMap<String, Object>();
                Map formMap = ctx.formParamMap();
                for (Map.Entry entry : formMap.entrySet()) {
                    fromUser.put((String)entry.getKey(), entry.getValue());
                }
                userHandlerGet.handle(fromUser, model);
                ctx.render(htmlModelGet, model);
            } else if (type.equalsIgnoreCase(MimeType.BINARY.toString()) || type.equalsIgnoreCase(MimeType.JSON.toString())) {
                // empty if block
            }
        };
        CombinedHandler restHandler = new CombinedHandler(handler);
        RestServer.getInstance().get(propertyName, (Handler)restHandler);
        RestServer.getInstance().post(propertyName, (Handler)restHandler);
    }

    protected String getHtmlModelGet() {
        return this.htmlModelGet;
    }

    protected String getHtmlModelSet() {
        return this.htmlModelSet;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    public static interface PropertyMap<K, V>
    extends Map<K, V> {
        public Object getData();
    }

    public static interface PropertyHandlerAlt3Set<S, R> {
        public void handle(ComHandler<R, S> var1, ComHandler<R, Void> var2) throws Exception;
    }

    public static interface PropertyHandlerAlt3<S, G, R> {
        public void handle(ComHandler<R, S> var1, ComHandler<R, G> var2) throws Exception;
    }

    public static interface PropertyHandlerAlt2 {
        public void handle(Operation var1, Map<String, Object> var2, Map<String, Object> var3) throws Exception;
    }

    public static interface PropertyHandler {
        public void handle(Map<String, Object> var1, Map<String, Object> var2) throws Exception;
    }

    public static interface PropertyGetHandler<G, R> {
        public void handle(ComHandler<R, Void> var1, ComHandler<R, G> var2) throws Exception;
    }

    public static enum Operation {
        GET,
        SET,
        SUBSCRIBE;

    }

    public static interface ComHandler<H, D> {
        public D getData();

        public D getData(D var1);

        public Supplier<D> getData(String var1);

        public H getHeader();
    }
}

