/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote.util;

import de.gsi.acc.remote.RestServer;
import io.javalin.http.Context;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class MessageBundle {
    private static final String ATTR_CURRENT_MESSAGES = "msg";
    private static final String ATTR_CURRENT_USER = "currentUser";
    private static final String ATTR_CURRENT_ROLES = "currentRoles";
    private final ResourceBundle messages;

    public MessageBundle(String languageTag) {
        Locale locale = languageTag == null ? Locale.ENGLISH : new Locale(languageTag);
        this.messages = ResourceBundle.getBundle("localisation/messages", locale);
    }

    public String get(String message) {
        return this.messages.getString(message);
    }

    public final String get(String key, Object ... args) {
        return MessageFormat.format(this.get(key), args);
    }

    public static Map<String, Object> baseModel(Context ctx) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(ATTR_CURRENT_MESSAGES, new MessageBundle(RestServer.getSessionLocale(ctx)));
        model.put(ATTR_CURRENT_USER, RestServer.getSessionCurrentUser(ctx));
        model.put(ATTR_CURRENT_ROLES, RestServer.getSessionCurrentRoles(ctx));
        return model;
    }
}

