/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote.util;

import de.gsi.acc.remote.RestServer;
import de.gsi.dataset.remote.MimeType;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.sse.SseClient;
import java.io.IOException;
import java.util.function.Consumer;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombinedHandler.class);
    private final Handler getHandler;
    private final Consumer<SseClient> clientConsumer = client -> {
        String endPointName = client.ctx.req.getRequestURI();
        RestServer.getEventClients(endPointName).add((SseClient)client);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)client.ctx.req.getRemoteHost()).addArgument((Object)endPointName).log("added SSE client: '{}' to route '{}'");
        }
        client.sendEvent("connected", "Hello, new SSE client " + client.ctx.req.getRemoteHost());
        client.onClose(() -> {
            RestServer.getEventClients(endPointName).remove(client);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().addArgument((Object)client.ctx.req.getRemoteHost()).addArgument((Object)endPointName).log("removed client: '{}' from route '{}'");
            }
        });
    };

    public CombinedHandler(@NotNull Handler getHandler) {
        this.getHandler = getHandler;
    }

    public void handle(Context ctx) throws Exception {
        if (MimeType.EVENT_STREAM.equals((Object)RestServer.getRequestedMimeProtocol(ctx, new MimeType[0]))) {
            ctx.res.setStatus(200);
            ctx.res.setCharacterEncoding("UTF-8");
            ctx.res.setContentType(MimeType.EVENT_STREAM.toString());
            ctx.res.addHeader("Connection", "close");
            ctx.res.addHeader("Cache-Control", "no-cache");
            ctx.res.flushBuffer();
            ctx.req.startAsync((ServletRequest)ctx.req, (ServletResponse)ctx.res);
            ctx.req.getAsyncContext().setTimeout(0L);
            this.clientConsumer.accept(new SseClient(ctx));
            ctx.req.getAsyncContext().addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) throws IOException {
                }

                public void onError(AsyncEvent event) throws IOException {
                    event.getAsyncContext().complete();
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                }

                public void onTimeout(AsyncEvent event) throws IOException {
                    event.getAsyncContext().complete();
                }
            });
            return;
        }
        this.getHandler.handle(ctx);
    }
}

