/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote.user;

import de.gsi.acc.remote.BasicRestRoles;
import de.gsi.acc.remote.RestServer;
import de.gsi.acc.remote.user.RestUser;
import de.gsi.acc.remote.user.RestUserHandler;
import io.javalin.core.security.Role;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUserHandlerImpl
implements RestUserHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestUserHandlerImpl.class);
    private static final String REST_USER_PASSWORD_STORE = "restUserPasswordStore";
    private static final String REST_USER_PASSWORD_FILE = RestUserHandlerImpl.getUserPasswordStore();
    private final Object usersLock = new Object();
    private List<RestUser> users = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(@NotNull String username, @NotNull String password) {
        Object object = this.usersLock;
        synchronized (object) {
            RestUser user = this.getUserByUsername(username);
            if (user == null) {
                return false;
            }
            String hashedPassword = BCrypt.hashpw((String)password, (String)user.salt);
            return hashedPassword.equals(user.hashedPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<String> getAllUserNames() {
        Object object = this.usersLock;
        synchronized (object) {
            if (this.users.isEmpty()) {
                this.readPasswordFile();
            }
            return this.users.stream().map(user -> user.userName).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestUser getUserByUsername(String userName) {
        Object object = this.usersLock;
        synchronized (object) {
            if (this.users.isEmpty()) {
                this.readPasswordFile();
            }
            return this.users.stream().filter(b -> b.userName.equals(userName)).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Role> getUserRolesByUsername(String userName) {
        Object object = this.usersLock;
        synchronized (object) {
            Optional<RestUser> user;
            if (this.users.isEmpty()) {
                this.readPasswordFile();
            }
            if ((user = this.users.stream().filter(b -> b.userName.equals(userName)).findFirst()).isPresent()) {
                return user.get().getRoles();
            }
            return Collections.singleton(BasicRestRoles.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPasswordFile() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("readPasswordFile called");
        }
        Object object = this.usersLock;
        synchronized (object) {
            try (BufferedReader br = REST_USER_PASSWORD_FILE == null ? new BufferedReader(new InputStreamReader(RestServer.class.getResourceAsStream("/DefaultRestUserPasswords.pwd"), StandardCharsets.UTF_8)) : Files.newBufferedReader(Paths.get(new File(REST_USER_PASSWORD_FILE).getPath(), new String[0]), StandardCharsets.UTF_8);){
                String userLine;
                ArrayList<RestUser> newUserList = new ArrayList<RestUser>(10);
                int lineCount = 0;
                while ((userLine = br.readLine()) != null) {
                    if (userLine.startsWith("#")) continue;
                    this.parsePasswordLine(newUserList, userLine, ++lineCount);
                }
                this.users = Collections.unmodifiableList(newUserList);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().log("PasswordFile successfully read");
                }
            }
            catch (IOException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)REST_USER_PASSWORD_FILE).log("could not read rest user passwords to '{}'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPassword(@NotNull String userName, @NotNull String oldPassword, @NotNull String newPassword) {
        if (REST_USER_PASSWORD_FILE == null) {
            LOGGER.atWarn().log("cannot set password for default user password store");
            return false;
        }
        Object object = this.usersLock;
        synchronized (object) {
            if (this.authenticate(userName, oldPassword)) {
                String newSalt = BCrypt.gensalt();
                String newHashedPassword = BCrypt.hashpw((String)newPassword, (String)newSalt);
                RestUser user = this.getUserByUsername(userName);
                if (user == null) {
                    return false;
                }
                user.salt = newSalt;
                user.hashedPassword = newHashedPassword;
                this.writePasswordFile();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePasswordFile() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().log("updatePasswordFile called");
        }
        if (REST_USER_PASSWORD_FILE == null) {
            LOGGER.atWarn().log("cannot write password for default user password store");
            return;
        }
        Object object = this.usersLock;
        synchronized (object) {
            File file = new File(REST_USER_PASSWORD_FILE);
            try {
                if (file.createNewFile()) {
                    LOGGER.atInfo().addArgument((Object)REST_USER_PASSWORD_FILE).log("needed to create new password file '{}'");
                }
            }
            catch (IOException | SecurityException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)REST_USER_PASSWORD_FILE).log("could not create user passwords file '{}'");
                return;
            }
            try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(file.getPath(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                StringBuilder builder = new StringBuilder();
                for (RestUser user : this.users) {
                    builder.delete(0, builder.length());
                    builder.append(user.userName).append(':').append(user.salt).append(':').append(user.hashedPassword).append(':');
                    builder.append(BasicRestRoles.getRoles(user.getRoles())).append(':');
                    bw.write(builder.toString());
                    bw.newLine();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.atDebug().log("PasswordFile successfully updated");
                }
            }
            catch (IOException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)REST_USER_PASSWORD_FILE).log("could not store rest user passwords to '{}'");
            }
        }
    }

    private void parsePasswordLine(List<RestUser> newUserList, String userLine, int lineCount) {
        try {
            String[] items = userLine.split(":");
            if (items.length < 4) {
                LOGGER.atWarn().addArgument((Object)items.length).addArgument((Object)lineCount).addArgument((Object)userLine).log("insufficient arguments ({} < 4)- parsing line {}: '{}'");
                return;
            }
            newUserList.add(new RestUser(items[0], items[1], items[2], BasicRestRoles.getRoles(items[3])));
        }
        catch (Exception e) {
            LOGGER.atWarn().setCause((Throwable)e).addArgument((Object)lineCount).addArgument((Object)userLine).log("could not parse line {}: '{}'");
        }
    }

    private static String getUserPasswordStore() {
        String passWordStore = System.getProperty(REST_USER_PASSWORD_STORE);
        if (passWordStore == null) {
            LOGGER.atWarn().log("using internal UserPasswordStore -- PLEASE CHANGE FOR PRODUCTION -- THIS IS UNSAFE PRACTICE");
        }
        return passWordStore;
    }
}

