/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.acc.remote;

import io.javalin.core.security.Role;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum BasicRestRoles implements Role
{
    NULL,
    ANYONE,
    ADMIN,
    READ_ONLY,
    READ_WRITE;


    public static String getRoles(Set<Role> roleSet) {
        return roleSet.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public static Set<Role> getRoles(@NotNull String roleString) {
        if (roleString.contains(":")) {
            throw new IllegalArgumentException("roleString must not contain [:]");
        }
        HashSet<BasicRestRoles> roles = new HashSet<BasicRestRoles>();
        for (String role : roleString.replaceAll("\\s", "").split(",")) {
            if (role == null || role.isEmpty() || "*".equals(role)) continue;
            roles.add(BasicRestRoles.valueOf(role.toUpperCase(Locale.UK)));
        }
        return Collections.unmodifiableSet(roles);
    }
}

