/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.versionchecker;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.versionchecker.Comparison;
import de.griefed.versionchecker.Update;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class VersionChecker {
    private static final Logger LOG = LogManager.getLogger(VersionChecker.class);
    private List<String> allVersions;

    public String checkForUpdate(@NotNull String currentVersion, boolean checkForPreReleases) {
        LOG.debug("Current version: " + currentVersion);
        try {
            String newVersion = this.isUpdateAvailable(currentVersion, checkForPreReleases);
            if (newVersion.equals("up_to_date")) {
                return "No updates available.";
            }
            return newVersion + ";" + this.getDownloadUrl(newVersion);
        }
        catch (NumberFormatException ex) {
            LOG.error("A version could not be parsed into integers.", (Throwable)ex);
            return "No updates available.";
        }
    }

    protected String isUpdateAvailable(@NotNull String currentVersion, boolean checkForPreReleases) {
        if (checkForPreReleases) {
            if (this.isNewBetaAvailable(currentVersion)) {
                return this.latestBeta();
            }
            if (this.isNewAlphaAvailable(currentVersion)) {
                return this.latestAlpha();
            }
        }
        if (this.compareSemantics(currentVersion, this.latestVersion(checkForPreReleases), Comparison.NEW)) {
            return this.latestVersion(checkForPreReleases);
        }
        if (currentVersion.matches("\\d+\\.\\d+\\.\\d+-(alpha|beta)\\.\\d+") && this.compareSemantics(currentVersion, this.latestVersion(false), Comparison.EQUAL)) {
            return this.latestVersion(false);
        }
        return "up_to_date";
    }

    protected boolean compareSemantics(@NotNull String currentVersion, @NotNull String newVersion, @NotNull Comparison comparison) {
        LOG.debug("Current version: " + currentVersion);
        LOG.debug("New version:     " + newVersion);
        LOG.debug("Comparison:      " + (Object)((Object)comparison));
        if (newVersion.equals("no_release")) {
            return false;
        }
        List<Integer> currentSemantics = this.getSemantics(currentVersion);
        List<Integer> newSemantics = this.getSemantics(newVersion);
        int currentMajor = currentSemantics.get(0);
        int currentMinor = currentSemantics.get(1);
        int currentPatch = currentSemantics.get(2);
        int newMajor = newSemantics.get(0);
        int newMinor = newSemantics.get(1);
        int newPatch = newSemantics.get(2);
        switch (comparison) {
            case EQUAL: {
                return this.checkEqual(newMajor, newMinor, newPatch, currentMajor, currentMinor, currentPatch);
            }
            case NEW: {
                return this.checkNew(newMajor, newMinor, newPatch, currentMajor, currentMinor, currentPatch);
            }
            case EQUAL_OR_NEW: {
                return this.checkNewOrEqual(newMajor, newMinor, newPatch, currentMajor, currentMinor, currentPatch);
            }
        }
        LOG.error("Incorrect comparison type selected: " + (Object)((Object)comparison));
        return false;
    }

    private List<Integer> getSemantics(String version) {
        ArrayList<Integer> semantics = new ArrayList<Integer>(3);
        String[] versionNumbers = version.split("\\.");
        semantics.add(0, Integer.parseInt(versionNumbers[0]));
        semantics.add(1, Integer.parseInt(versionNumbers[1]));
        if (versionNumbers[2].contains("-")) {
            semantics.add(2, Integer.parseInt(versionNumbers[2].split("-")[0]));
        } else {
            semantics.add(2, Integer.parseInt(versionNumbers[2]));
        }
        return semantics;
    }

    private boolean checkNew(int newMajor, int newMinor, int newPatch, int currentMajor, int currentMinor, int currentPatch) {
        if (newMajor > currentMajor) {
            return true;
        }
        if (newMajor == currentMajor && newMinor > currentMinor) {
            return true;
        }
        return newMajor == currentMajor && newMinor == currentMinor && newPatch > currentPatch;
    }

    private boolean checkNewOrEqual(int newMajor, int newMinor, int newPatch, int currentMajor, int currentMinor, int currentPatch) {
        return newMajor >= currentMajor && newMinor >= currentMinor && newPatch >= currentPatch;
    }

    private boolean checkEqual(int newMajor, int newMinor, int newPatch, int currentMajor, int currentMinor, int currentPatch) {
        return newMajor == currentMajor && newMinor == currentMinor && newPatch == currentPatch;
    }

    private boolean isNewAlphaAvailable(@NotNull String currentVersion) throws NumberFormatException {
        if (this.latestAlpha().equals("no_alphas")) {
            return false;
        }
        String latestAlpha = this.latestAlpha();
        if (this.compareSemantics(currentVersion, latestAlpha, Comparison.EQUAL) && currentVersion.contains("beta")) {
            return false;
        }
        if (this.compareSemantics(currentVersion, latestAlpha, Comparison.NEW)) {
            return true;
        }
        if (this.compareSemantics(currentVersion, latestAlpha, Comparison.EQUAL_OR_NEW) && currentVersion.contains("-")) {
            return this.isPreReleaseNewer(currentVersion, latestAlpha);
        }
        return false;
    }

    private boolean isNewBetaAvailable(@NotNull String currentVersion) throws NumberFormatException {
        if (this.latestBeta().equals("no_betas")) {
            return false;
        }
        String latestBeta = this.latestBeta();
        if (this.compareSemantics(currentVersion, latestBeta, Comparison.NEW)) {
            return true;
        }
        if (this.compareSemantics(currentVersion, latestBeta, Comparison.EQUAL_OR_NEW) && currentVersion.contains("-")) {
            return this.isPreReleaseNewer(currentVersion, latestBeta);
        }
        return false;
    }

    private boolean isPreReleaseNewer(@NotNull String currentVersion, @NotNull String newVersion) {
        int currentVersionReleaseNumber = Integer.parseInt(currentVersion.split("-")[1].split("\\.")[1]);
        int newVersionReleaseNumber = Integer.parseInt(newVersion.split("-")[1].split("\\.")[1]);
        return newVersionReleaseNumber > currentVersionReleaseNumber;
    }

    private List<String> allBetaVersions() {
        ArrayList<String> betaVersions = new ArrayList<String>(1000);
        if (this.allVersions != null) {
            for (String version : this.allVersions) {
                if (!version.contains("beta") || betaVersions.contains(version)) continue;
                betaVersions.add(version);
            }
        }
        if (betaVersions.size() == 0) {
            return null;
        }
        return betaVersions;
    }

    private List<String> allAlphaVersions() {
        ArrayList<String> alphaVersions = new ArrayList<String>(1000);
        if (this.allVersions != null) {
            for (String version : this.allVersions) {
                if (!version.contains("alpha") || alphaVersions.contains(version)) continue;
                alphaVersions.add(version);
            }
        }
        if (alphaVersions.size() == 0) {
            return null;
        }
        return alphaVersions;
    }

    protected String latestBeta() throws NumberFormatException {
        List<String> betaVersions = this.allBetaVersions();
        String beta = "no_betas";
        if (betaVersions != null) {
            beta = betaVersions.get(0);
            for (String betaVersion : betaVersions) {
                if (!this.compareSemantics(beta, betaVersion, Comparison.EQUAL_OR_NEW) || !this.isPreReleaseNewer(beta, betaVersion)) continue;
                beta = betaVersion;
            }
        }
        LOG.debug("Latest beta: " + beta);
        return beta;
    }

    protected String latestAlpha() throws NumberFormatException {
        List<String> alphaVersions = this.allAlphaVersions();
        String alpha = "no_alphas";
        if (alphaVersions != null) {
            alpha = alphaVersions.get(0);
            for (String alphaVersion : alphaVersions) {
                if (!this.compareSemantics(alpha, alphaVersion, Comparison.EQUAL_OR_NEW) || !this.isPreReleaseNewer(alpha, alphaVersion)) continue;
                alpha = alphaVersion;
            }
        }
        LOG.debug("Latest alpha: " + alpha);
        return alpha;
    }

    protected String getResponse(@NotNull URL requestUrl) throws IOException {
        String inputLine;
        HttpURLConnection httpURLConnection = (HttpURLConnection)requestUrl.openConnection();
        httpURLConnection.setRequestMethod("GET");
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IOException("Request for " + requestUrl + " responded with " + httpURLConnection.getResponseCode());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = bufferedReader.readLine()) != null) {
            response.append(inputLine);
        }
        bufferedReader.close();
        return response.toString();
    }

    protected ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    protected abstract List<String> allVersions();

    public abstract VersionChecker refresh() throws IOException;

    protected void setAllVersions() {
        this.allVersions = this.allVersions();
    }

    protected List<String> getAllVersions() {
        return this.allVersions;
    }

    protected abstract String latestVersion(boolean var1);

    protected abstract String getDownloadUrl(@NotNull String var1);

    protected abstract void setRepository() throws IOException;

    @Deprecated
    public abstract List<String> getAssetsDownloadUrls(@NotNull String var1);

    public abstract Optional<Update> check(@NotNull String var1, boolean var2);
}

