/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.model.SimplePersistentPropertyPathAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ConvertingPropertyAccessor<T>
extends SimplePersistentPropertyPathAccessor<T> {
    private final PersistentPropertyAccessor<T> accessor;
    private final ConversionService conversionService;

    public ConvertingPropertyAccessor(PersistentPropertyAccessor<T> accessor, ConversionService conversionService) {
        super(accessor);
        Assert.notNull(accessor, "PersistentPropertyAccessor must not be null!");
        Assert.notNull((Object)conversionService, "ConversionService must not be null!");
        this.accessor = accessor;
        this.conversionService = conversionService;
    }

    @Override
    public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
        this.accessor.setProperty(property, this.convertIfNecessary(value, property.getType()));
    }

    @Override
    public void setProperty(PersistentPropertyPath<? extends PersistentProperty<?>> path, @Nullable Object value) {
        Object converted = this.convertIfNecessary(value, path.getRequiredLeafProperty().getType());
        super.setProperty(path, converted);
    }

    @Nullable
    public <S> S getProperty(PersistentProperty<?> property, Class<S> targetType) {
        Assert.notNull(property, "PersistentProperty must not be null!");
        Assert.notNull(targetType, "Target type must not be null!");
        return this.convertIfNecessary(this.getProperty((PersistentProperty)property), targetType);
    }

    @Override
    @Nullable
    protected <S> S getTypedProperty(PersistentProperty<?> property, Class<S> type) {
        return this.convertIfNecessary(super.getTypedProperty(property, type), type);
    }

    @Nullable
    private <S> S convertIfNecessary(@Nullable Object source, Class<S> type) {
        return (S)(source == null ? null : (ClassUtils.isAssignable(type, source.getClass()) ? source : this.conversionService.convert(source, type)));
    }
}

