/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.data.jpa.repository.query.ProcedureParameter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StoredProcedureAttributes {
    static final String SYNTHETIC_OUTPUT_PARAMETER_NAME = "out";
    private final boolean namedStoredProcedure;
    private final String procedureName;
    private final List<ProcedureParameter> outputProcedureParameters;

    StoredProcedureAttributes(String procedureName, ProcedureParameter parameter) {
        this(procedureName, Collections.singletonList(parameter), false);
    }

    StoredProcedureAttributes(String procedureName, List<ProcedureParameter> outputProcedureParameters, boolean namedStoredProcedure) {
        Assert.notNull((Object)procedureName, "ProcedureName must not be null!");
        Assert.notNull(outputProcedureParameters, "OutputProcedureParameters must not be null!");
        Assert.isTrue(outputProcedureParameters.size() != 1 || outputProcedureParameters.get(0) != null, "ProcedureParameters must not have size 1 with a null value");
        this.procedureName = procedureName;
        this.namedStoredProcedure = namedStoredProcedure;
        this.outputProcedureParameters = namedStoredProcedure ? outputProcedureParameters : this.getParametersWithCompletedNames(outputProcedureParameters);
    }

    private List<ProcedureParameter> getParametersWithCompletedNames(List<ProcedureParameter> procedureParameters) {
        return IntStream.range(0, procedureParameters.size()).mapToObj(i2 -> this.getParameterWithCompletedName((ProcedureParameter)procedureParameters.get(i2), i2)).collect(Collectors.toList());
    }

    private ProcedureParameter getParameterWithCompletedName(ProcedureParameter parameter, int i2) {
        return new ProcedureParameter(this.completeOutputParameterName(i2, parameter.getName()), parameter.getMode(), parameter.getType());
    }

    private String completeOutputParameterName(int i2, String paramName) {
        return StringUtils.hasText(paramName) ? paramName : this.createSyntheticParameterName(i2);
    }

    private String createSyntheticParameterName(int i2) {
        return SYNTHETIC_OUTPUT_PARAMETER_NAME + (i2 == 0 ? "" : Integer.valueOf(i2));
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public boolean isNamedStoredProcedure() {
        return this.namedStoredProcedure;
    }

    public List<ProcedureParameter> getOutputProcedureParameters() {
        return this.outputProcedureParameters;
    }

    public boolean hasReturnValue() {
        if (this.getOutputProcedureParameters().isEmpty()) {
            return false;
        }
        Class<?> outputType = this.getOutputProcedureParameters().get(0).getType();
        return !Void.TYPE.equals(outputType) && !Void.class.equals(outputType);
    }
}

