/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryFactory;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.NamedQuery;
import org.springframework.data.jpa.repository.query.PartTreeJpaQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class JpaQueryLookupStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(JpaQueryLookupStrategy.class);

    private JpaQueryLookupStrategy() {
    }

    public static QueryLookupStrategy create(EntityManager em, JpaQueryMethodFactory queryMethodFactory, @Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, EscapeCharacter escape) {
        Assert.notNull((Object)em, "EntityManager must not be null!");
        Assert.notNull((Object)evaluationContextProvider, "EvaluationContextProvider must not be null!");
        switch (key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND) {
            case CREATE: {
                return new CreateQueryLookupStrategy(em, queryMethodFactory, escape);
            }
            case USE_DECLARED_QUERY: {
                return new DeclaredQueryLookupStrategy(em, queryMethodFactory, evaluationContextProvider);
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(em, queryMethodFactory, new CreateQueryLookupStrategy(em, queryMethodFactory, escape), new DeclaredQueryLookupStrategy(em, queryMethodFactory, evaluationContextProvider));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported query lookup strategy %s!", new Object[]{key}));
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy) {
            super(em, queryMethodFactory);
            Assert.notNull((Object)createStrategy, "CreateQueryLookupStrategy must not be null!");
            Assert.notNull((Object)lookupStrategy, "DeclaredQueryLookupStrategy must not be null!");
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, em, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, em, namedQueries);
            }
        }
    }

    private static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;

        public DeclaredQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, QueryMethodEvaluationContextProvider evaluationContextProvider) {
            super(em, queryMethodFactory);
            this.evaluationContextProvider = evaluationContextProvider;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            if (method.isProcedureQuery()) {
                return JpaQueryFactory.INSTANCE.fromProcedureAnnotation(method, em);
            }
            if (StringUtils.hasText(method.getAnnotatedQuery())) {
                if (method.hasAnnotatedQueryName()) {
                    LOG.warn(String.format("Query method %s is annotated with both, a query and a query name. Using the declared query.", method));
                }
                return JpaQueryFactory.INSTANCE.fromMethodWithQueryString(method, em, method.getRequiredAnnotatedQuery(), this.getCountQuery(method, namedQueries, em), this.evaluationContextProvider);
            }
            String name = method.getNamedQueryName();
            if (namedQueries.hasQuery(name)) {
                return JpaQueryFactory.INSTANCE.fromMethodWithQueryString(method, em, namedQueries.getQuery(name), this.getCountQuery(method, namedQueries, em), this.evaluationContextProvider);
            }
            RepositoryQuery query2 = NamedQuery.lookupFrom(method, em);
            if (null != query2) {
                return query2;
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor an annotated query for method %s!", method));
        }

        @Nullable
        private String getCountQuery(JpaQueryMethod method, NamedQueries namedQueries, EntityManager em) {
            if (StringUtils.hasText(method.getCountQuery())) {
                return method.getCountQuery();
            }
            String queryName = method.getNamedCountQueryName();
            if (!StringUtils.hasText(queryName)) {
                return method.getCountQuery();
            }
            if (namedQueries.hasQuery(queryName)) {
                return namedQueries.getQuery(queryName);
            }
            boolean namedQuery = NamedQuery.hasNamedQuery(em, queryName);
            if (namedQuery) {
                return method.getQueryExtractor().extractQueryString(em.createNamedQuery(queryName));
            }
            return null;
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final EscapeCharacter escape;

        public CreateQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory, EscapeCharacter escape) {
            super(em, queryMethodFactory);
            this.escape = escape;
        }

        @Override
        protected RepositoryQuery resolveQuery(JpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            return new PartTreeJpaQuery(method, em, this.escape);
        }
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final JpaQueryMethodFactory queryMethodFactory;

        public AbstractQueryLookupStrategy(EntityManager em, JpaQueryMethodFactory queryMethodFactory) {
            Assert.notNull((Object)em, "EntityManager must not be null!");
            Assert.notNull((Object)queryMethodFactory, "JpaQueryMethodFactory must not be null!");
            this.em = em;
            this.queryMethodFactory = queryMethodFactory;
        }

        @Override
        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return this.resolveQuery(this.queryMethodFactory.build(method, metadata, factory), this.em, namedQueries);
        }

        protected abstract RepositoryQuery resolveQuery(JpaQueryMethod var1, EntityManager var2, NamedQueries var3);
    }
}

