/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class LoggingCacheErrorHandler
implements CacheErrorHandler {
    private final Log logger;
    private final boolean logStacktrace;

    public LoggingCacheErrorHandler(Log logger2, boolean logStacktrace) {
        Assert.notNull((Object)logger2, "Logger must not be null");
        this.logger = logger2;
        this.logStacktrace = logStacktrace;
    }

    public LoggingCacheErrorHandler() {
        this(LogFactory.getLog(LoggingCacheErrorHandler.class), false);
    }

    @Override
    public void handleCacheGetError(RuntimeException exception, Cache cache, Object key) {
        this.logCacheError(this.logger, this.createMessage(cache, "failed to get entry with key '" + key + "'"), exception);
    }

    @Override
    public void handleCachePutError(RuntimeException exception, Cache cache, Object key, @Nullable Object value) {
        this.logCacheError(this.logger, this.createMessage(cache, "failed to put entry with key '" + key + "'"), exception);
    }

    @Override
    public void handleCacheEvictError(RuntimeException exception, Cache cache, Object key) {
        this.logCacheError(this.logger, this.createMessage(cache, "failed to evict entry with key '" + key + "'"), exception);
    }

    @Override
    public void handleCacheClearError(RuntimeException exception, Cache cache) {
        this.logCacheError(this.logger, this.createMessage(cache, "failed to clear entries"), exception);
    }

    protected void logCacheError(Log logger2, String message, RuntimeException ex) {
        if (this.logStacktrace) {
            logger2.warn(message, ex);
        } else {
            logger2.warn(message);
        }
    }

    private String createMessage(Cache cache, String reason) {
        return String.format("Cache '%s' %s", cache.getName(), reason);
    }
}

