/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherBlocking
implements Receiver {
    RpcDispatcher disp;
    JChannel channel;
    long timeout = 30000L;
    String props = null;
    int i = 0;

    public RpcDispatcherBlocking(String props, long timeout) {
        this.props = props;
        this.timeout = timeout;
    }

    public void print(int i2) throws Exception {
        System.out.println("<-- " + i2 + " [sleeping for " + this.timeout + " msecs");
        Util.sleep(this.timeout);
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("new view: " + new_view);
    }

    public void start() throws Exception {
        this.channel = new JChannel();
        this.disp = new RpcDispatcher(this.channel, this).setReceiver(this);
        this.channel.connect("rpc-test");
        while (true) {
            System.out.println("[x]: exit [s]: send sync group RPC");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case 120: {
                    this.channel.close();
                    this.disp.stop();
                    return;
                }
                case 115: {
                    RspList rsps = this.sendGroupRpc();
                    System.out.println("responses:\n" + rsps);
                }
            }
            System.in.skip(System.in.available());
        }
    }

    RspList sendGroupRpc() throws Exception {
        return this.disp.callRemoteMethods(null, "print", new Object[]{this.i++}, new Class[]{Integer.TYPE}, new RequestOptions(ResponseMode.GET_ALL, 0L));
    }

    public static void main(String[] args) {
        long timeout = 30000L;
        String props = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if ("-props".equals(args[i2])) {
                props = args[++i2];
                continue;
            }
            if ("-timeout".equals(args[i2])) {
                timeout = Long.parseLong(args[++i2]);
                continue;
            }
            RpcDispatcherBlocking.help();
            return;
        }
        try {
            new RpcDispatcherBlocking(props, timeout).start();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherBlocking [-help] [-props <properties>] [-timeout <timeout>]");
    }
}

