/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;

public class McastSenderTest {
    public static void main(String[] args) {
        MulticastSocket[] sockets = null;
        InetAddress mcast_addr = null;
        InetAddress bind_addr = null;
        byte[] buf = new byte[]{};
        int ttl = 32;
        AckReceiver ack_receiver = null;
        int port = 5555;
        try {
            for (int i2 = 0; i2 < args.length; ++i2) {
                String tmp = args[i2];
                if ("-help".equals(tmp)) {
                    McastSenderTest.help();
                    return;
                }
                if ("-bind_addr".equals(tmp)) {
                    bind_addr = InetAddress.getByName(args[++i2]);
                    continue;
                }
                if ("-mcast_addr".equals(tmp)) {
                    mcast_addr = InetAddress.getByName(args[++i2]);
                    continue;
                }
                if ("-ttl".equals(tmp)) {
                    ttl = Integer.parseInt(args[++i2]);
                    continue;
                }
                if ("-port".equals(tmp)) {
                    port = Integer.parseInt(args[++i2]);
                    continue;
                }
                McastSenderTest.help();
                return;
            }
            if (mcast_addr == null) {
                mcast_addr = InetAddress.getByName("224.0.0.150");
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        try {
            MulticastSocket sock;
            int i3;
            ArrayList<InetAddress> v = new ArrayList<InetAddress>();
            if (bind_addr != null) {
                v.add(bind_addr);
            } else {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> e2 = intf.getInetAddresses();
                    while (e2.hasMoreElements()) {
                        bind_addr = e2.nextElement();
                        v.add(bind_addr);
                    }
                }
            }
            sockets = new MulticastSocket[v.size()];
            for (i3 = 0; i3 < v.size(); ++i3) {
                sock = new MulticastSocket(port);
                sock.setTimeToLive(ttl);
                sock.setNetworkInterface(NetworkInterface.getByInetAddress((InetAddress)v.get(i3)));
                sockets[i3] = sock;
                ack_receiver = new AckReceiver(sock);
                ack_receiver.start();
            }
            for (i3 = 0; i3 < sockets.length; ++i3) {
                sock = sockets[i3];
                if (sock == null) continue;
                System.out.println("Socket #" + (i3 + 1) + "=" + sock.getLocalAddress() + ":" + sock.getLocalPort() + ", ttl=" + sock.getTimeToLive() + ", bind interface=" + sock.getNetworkInterface());
            }
            DataInputStream in = new DataInputStream(System.in);
            while (true) {
                System.out.print("> ");
                String line = in.readLine();
                if (line.startsWith("quit") || line.startsWith("exit")) {
                    System.exit(0);
                }
                buf = line.getBytes();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, mcast_addr, port);
                McastSenderTest.send(packet, sockets);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            return;
        }
    }

    static void send(DatagramPacket packet, MulticastSocket[] sockets) {
        if (packet == null || sockets == null) {
            return;
        }
        for (int i2 = 0; i2 < sockets.length; ++i2) {
            try {
                if (sockets[i2] == null) continue;
                sockets[i2].send(packet);
                continue;
            }
            catch (Exception ex) {
                System.err.println("McastSenderTest.send(): " + ex);
            }
        }
    }

    static void help() {
        System.out.println("McastSenderTest [-bind_addr <bind address>] [-help] [-mcast_addr <multicast address>] [-port <multicast port that receivers are listening on>] [-ttl <time to live for mcast packets>]");
    }

    private static class AckReceiver
    implements Runnable {
        DatagramSocket sock;
        DatagramPacket packet;
        byte[] buf;
        Thread t = null;

        AckReceiver(DatagramSocket sock) {
            this.sock = sock;
        }

        @Override
        public void run() {
            while (this.t != null) {
                try {
                    this.buf = new byte[256];
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.sock.receive(this.packet);
                    System.out.println("<< Received packet from " + this.packet.getAddress().getHostAddress() + ":" + this.packet.getPort() + ": " + new String(this.packet.getData()));
                }
                catch (Exception e) {
                    System.err.println(e);
                    break;
                }
            }
            this.t = null;
        }

        void start() {
            this.t = new Thread((Runnable)this, "McastSenderTest.AckReceiver thread");
            this.t.start();
        }

        void stop() {
            if (this.t != null && this.t.isAlive()) {
                this.t = null;
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

