/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.atomic.Counter;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Owner;
import org.jgroups.util.Promise;
import org.jgroups.util.ResponseCollector;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Streamable;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Protocol to maintain distributed atomic counters")
public class COUNTER
extends Protocol {
    @Property(description="Bypasses message bundling if true")
    protected boolean bypass_bundling = true;
    @Property(description="Request timeouts (in ms). If the timeout elapses, a TimeoutException will be thrown", type=AttributeType.TIME)
    protected long timeout = 60000L;
    @Property(description="Number of milliseconds to wait for reconciliation responses from all current members", type=AttributeType.TIME)
    protected long reconciliation_timeout = 10000L;
    @Property(description="Number of backup coordinators. Modifications are asynchronously sent to all backup coordinators")
    protected int num_backups = 1;
    protected boolean discard_requests = false;
    protected View view;
    protected Address coord;
    protected List<Address> backup_coords = null;
    protected Future<?> reconciliation_task_future;
    protected ReconciliationTask reconciliation_task;
    protected final ConcurrentMap<String, VersionedValue> counters = Util.createConcurrentMap(20);
    protected final Map<Owner, Tuple<Request, Promise>> pending_requests = Util.createConcurrentMap(20);
    protected static final byte REQUEST = 1;
    protected static final byte RESPONSE = 2;

    protected static RequestType requestToRequestType(Request req) {
        if (req instanceof GetOrCreateRequest) {
            return RequestType.GET_OR_CREATE;
        }
        if (req instanceof DeleteRequest) {
            return RequestType.DELETE;
        }
        if (req instanceof AddAndGetRequest) {
            return RequestType.ADD_AND_GET;
        }
        if (req instanceof UpdateRequest) {
            return RequestType.UPDATE;
        }
        if (req instanceof SetRequest) {
            return RequestType.SET;
        }
        if (req instanceof CompareAndSetRequest) {
            return RequestType.COMPARE_AND_SET;
        }
        if (req instanceof ReconcileRequest) {
            return RequestType.RECONCILE;
        }
        if (req instanceof ResendPendingRequests) {
            return RequestType.RESEND_PENDING_REQUESTS;
        }
        throw new IllegalStateException("request " + req + " cannot be mapped to request type");
    }

    protected static ResponseType responseToResponseType(Response rsp) {
        if (rsp instanceof GetOrCreateResponse) {
            return ResponseType.GET_OR_CREATE;
        }
        if (rsp instanceof BooleanResponse) {
            return ResponseType.BOOLEAN;
        }
        if (rsp instanceof ValueResponse) {
            return ResponseType.VALUE;
        }
        if (rsp instanceof ExceptionResponse) {
            return ResponseType.EXCEPTION;
        }
        if (rsp instanceof ReconcileResponse) {
            return ResponseType.RECONCILE;
        }
        if (rsp != null) {
            return ResponseType.VOID;
        }
        throw new IllegalStateException("response " + rsp + " cannot be mapped to response type");
    }

    public boolean getBypassBundling() {
        return this.bypass_bundling;
    }

    public COUNTER setBypassBundling(boolean bypass_bundling) {
        this.bypass_bundling = bypass_bundling;
        return this;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.toString() : null;
    }

    @ManagedAttribute(description="List of the backup coordinator (null if num_backups <= 0")
    public String getBackupCoords() {
        return this.backup_coords != null ? this.backup_coords.toString() : "null";
    }

    public Counter getOrCreateCounter(String name, long initial_value) {
        if (this.local_addr == null) {
            throw new IllegalArgumentException("the channel needs to be connected before creating or getting a counter");
        }
        Owner owner = this.getOwner();
        GetOrCreateRequest req = new GetOrCreateRequest(owner, name, initial_value);
        Promise promise = new Promise();
        this.pending_requests.put(owner, new Tuple(req, promise));
        this.sendRequest(this.coord, req);
        long[] result = new long[]{};
        try {
            result = (long[])promise.getResultWithTimeout(this.timeout);
            long value = result[0];
            long version = result[1];
            if (!this.coord.equals(this.local_addr)) {
                this.counters.put(name, new VersionedValue(value, version));
            }
            return new CounterImpl(name);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteCounter(String name) {
        Owner owner = this.getOwner();
        DeleteRequest req = new DeleteRequest(owner, name);
        this.sendRequest(this.coord, req);
        if (!this.local_addr.equals(this.coord)) {
            this.counters.remove(name);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.arg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        CounterHeader hdr = (CounterHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        try {
            Streamable obj = COUNTER.streamableFromBuffer(msg.getArray(), msg.getOffset(), msg.getLength());
            if (this.log.isTraceEnabled()) {
                this.log.trace("[" + this.local_addr + "] <-- [" + msg.getSrc() + "] " + obj);
            }
            if (obj instanceof Request) {
                this.handleRequest((Request)obj, msg.getSrc());
            } else if (obj instanceof Response) {
                this.handleResponse((Response)obj, msg.getSrc());
            } else {
                this.log.error(Util.getMessage("ReceivedObjectIsNeitherARequestNorAResponse") + obj);
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedHandlingMessage"), ex);
        }
        return null;
    }

    protected void handleRequest(Request req, Address sender) {
        RequestType type = COUNTER.requestToRequestType(req);
        switch (type) {
            case GET_OR_CREATE: {
                if (!this.local_addr.equals(this.coord) || this.discard_requests) {
                    return;
                }
                GetOrCreateRequest tmp = (GetOrCreateRequest)req;
                VersionedValue new_val = new VersionedValue(tmp.initial_value);
                VersionedValue val = this.counters.putIfAbsent(tmp.name, new_val);
                if (val == null) {
                    val = new_val;
                }
                GetOrCreateResponse rsp = new GetOrCreateResponse(tmp.owner, val.value, val.version);
                this.sendResponse(sender, rsp);
                if (this.backup_coords == null) break;
                this.updateBackups(tmp.name, val.value, val.version);
                break;
            }
            case DELETE: {
                if (!this.local_addr.equals(this.coord) || this.discard_requests) {
                    return;
                }
                this.counters.remove(((SimpleRequest)req).name);
                break;
            }
            case SET: {
                if (!this.local_addr.equals(this.coord) || this.discard_requests) {
                    return;
                }
                VersionedValue val = (VersionedValue)this.counters.get(((SimpleRequest)req).name);
                if (val == null) {
                    this.sendCounterNotFoundExceptionResponse(sender, ((SimpleRequest)req).owner, ((SimpleRequest)req).name);
                    return;
                }
                long[] result = val.set(((SetRequest)req).value);
                ValueResponse rsp = new ValueResponse(((SimpleRequest)req).owner, result[0], result[1]);
                this.sendResponse(sender, rsp);
                if (this.backup_coords == null) break;
                this.updateBackups(((SimpleRequest)req).name, result[0], result[1]);
                break;
            }
            case COMPARE_AND_SET: {
                if (!this.local_addr.equals(this.coord) || this.discard_requests) {
                    return;
                }
                VersionedValue val = (VersionedValue)this.counters.get(((SimpleRequest)req).name);
                if (val == null) {
                    this.sendCounterNotFoundExceptionResponse(sender, ((SimpleRequest)req).owner, ((SimpleRequest)req).name);
                    return;
                }
                long[] result = val.compareAndSet(((CompareAndSetRequest)req).expected, ((CompareAndSetRequest)req).update);
                ValueResponse rsp = new ValueResponse(((SimpleRequest)req).owner, result == null ? -1L : result[0], result == null ? -1L : result[1]);
                this.sendResponse(sender, rsp);
                if (this.backup_coords == null) break;
                VersionedValue value = (VersionedValue)this.counters.get(((SimpleRequest)req).name);
                this.updateBackups(((SimpleRequest)req).name, value.value, value.version);
                break;
            }
            case ADD_AND_GET: {
                if (!this.local_addr.equals(this.coord) || this.discard_requests) {
                    return;
                }
                VersionedValue val = (VersionedValue)this.counters.get(((SimpleRequest)req).name);
                if (val == null) {
                    this.sendCounterNotFoundExceptionResponse(sender, ((SimpleRequest)req).owner, ((SimpleRequest)req).name);
                    return;
                }
                long[] result = val.addAndGet(((AddAndGetRequest)req).value);
                ValueResponse rsp = new ValueResponse(((SimpleRequest)req).owner, result[0], result[1]);
                this.sendResponse(sender, rsp);
                if (this.backup_coords == null) break;
                this.updateBackups(((SimpleRequest)req).name, result[0], result[1]);
                break;
            }
            case UPDATE: {
                String counter_name = ((UpdateRequest)req).name;
                long new_value = ((UpdateRequest)req).value;
                long new_version = ((UpdateRequest)req).version;
                VersionedValue current = (VersionedValue)this.counters.get(counter_name);
                if (current == null) {
                    this.counters.put(counter_name, new VersionedValue(new_value, new_version));
                    break;
                }
                current.updateIfBigger(new_value, new_version);
                break;
            }
            case RECONCILE: {
                if (sender.equals(this.local_addr)) break;
                ReconcileRequest reconcile_req = (ReconcileRequest)req;
                HashMap<String, VersionedValue> map = new HashMap<String, VersionedValue>(this.counters);
                if (reconcile_req.names != null) {
                    for (int i2 = 0; i2 < reconcile_req.names.length; ++i2) {
                        String counter_name = reconcile_req.names[i2];
                        long version = reconcile_req.versions[i2];
                        VersionedValue my_value = (VersionedValue)map.get(counter_name);
                        if (my_value == null || my_value.version > version) continue;
                        map.remove(counter_name);
                    }
                }
                int len = map.size();
                String[] names = new String[len];
                long[] values = new long[len];
                long[] versions = new long[len];
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    names[index] = (String)entry.getKey();
                    values[index] = ((VersionedValue)entry.getValue()).value;
                    versions[index] = ((VersionedValue)entry.getValue()).version;
                    ++index;
                }
                ReconcileResponse rsp = new ReconcileResponse(names, values, versions);
                this.sendResponse(sender, rsp);
                break;
            }
            case RESEND_PENDING_REQUESTS: {
                for (Tuple<Request, Promise> tuple : this.pending_requests.values()) {
                    Request request = tuple.getVal1();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("[" + this.local_addr + "] --> [" + this.coord + "] resending " + request);
                    }
                    this.sendRequest(this.coord, request);
                }
                break;
            }
        }
    }

    protected VersionedValue getCounter(String name) {
        VersionedValue val = (VersionedValue)this.counters.get(name);
        if (val == null) {
            throw new IllegalStateException("counter \"" + name + "\" not found");
        }
        return val;
    }

    protected void handleResponse(Response rsp, Address sender) {
        if (rsp instanceof ReconcileResponse) {
            if (this.log.isTraceEnabled() && ((ReconcileResponse)rsp).names != null && ((ReconcileResponse)rsp).names.length > 0) {
                this.log.trace("[" + this.local_addr + "] <-- [" + sender + "] RECONCILE-RSP: " + COUNTER.dump(((ReconcileResponse)rsp).names, ((ReconcileResponse)rsp).values, ((ReconcileResponse)rsp).versions));
            }
            if (this.reconciliation_task != null) {
                this.reconciliation_task.add((ReconcileResponse)rsp, sender);
            }
            return;
        }
        Tuple<Request, Promise> tuple = this.pending_requests.remove(((SimpleResponse)rsp).owner);
        if (tuple == null) {
            this.log.warn("response for " + ((SimpleResponse)rsp).owner + " didn't have an entry");
            return;
        }
        Promise promise = tuple.getVal2();
        if (rsp instanceof ValueResponse) {
            ValueResponse tmp = (ValueResponse)rsp;
            if (tmp.result == -1L && tmp.version == -1L) {
                promise.setResult(null);
            } else {
                long[] result = new long[]{tmp.result, tmp.version};
                promise.setResult(result);
            }
        } else if (rsp instanceof BooleanResponse) {
            promise.setResult(((BooleanResponse)rsp).result);
        } else if (rsp instanceof ExceptionResponse) {
            promise.setResult(new Throwable(((ExceptionResponse)rsp).error_message));
        } else {
            promise.setResult(null);
        }
    }

    @ManagedOperation(description="Dumps all counters")
    public String printCounters() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.counters.entrySet()) {
            sb.append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Dumps all pending requests")
    public String dumpPendingRequests() {
        StringBuilder sb = new StringBuilder();
        for (Tuple<Request, Promise> tuple : this.pending_requests.values()) {
            Request tmp = tuple.getVal1();
            sb.append(tmp + " (" + tmp.getClass().getCanonicalName() + ") ");
        }
        return sb.toString();
    }

    protected void handleView(View view) {
        this.view = view;
        if (this.log.isDebugEnabled()) {
            this.log.debug("view=" + view);
        }
        List<Address> members = view.getMembers();
        Address old_coord = this.coord;
        if (!members.isEmpty()) {
            this.coord = members.get(0);
        }
        if (Objects.equals(this.coord, this.local_addr)) {
            ArrayList<Address> old_backups = this.backup_coords != null ? new ArrayList<Address>(this.backup_coords) : null;
            this.backup_coords = new CopyOnWriteArrayList<Address>(Util.pickNext(members, this.local_addr, this.num_backups));
            List<Address> new_backups = Util.newElements(old_backups, this.backup_coords);
            for (Address new_backup : new_backups) {
                for (Map.Entry entry : this.counters.entrySet()) {
                    UpdateRequest update = new UpdateRequest((String)entry.getKey(), ((VersionedValue)entry.getValue()).value, ((VersionedValue)entry.getValue()).version);
                    this.sendRequest(new_backup, update);
                }
            }
        } else {
            this.backup_coords = null;
        }
        if (old_coord != null && this.coord != null && !old_coord.equals(this.coord) && this.local_addr.equals(this.coord)) {
            this.discard_requests = true;
            this.startReconciliationTask();
        }
    }

    protected Owner getOwner() {
        return new Owner(this.local_addr, Thread.currentThread().getId());
    }

    protected void sendRequest(Address dest, Request req) {
        try {
            ByteArray buffer = COUNTER.requestToBuffer(req);
            Message msg = new BytesMessage(dest, buffer).putHeader(this.id, new CounterHeader());
            if (this.bypass_bundling) {
                msg.setFlag(Message.Flag.DONT_BUNDLE);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("[" + this.local_addr + "] --> [" + (Comparable)(dest == null ? "ALL" : dest) + "] " + req);
            }
            this.down_prot.down(msg);
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSending") + req + " request: " + ex);
        }
    }

    protected void sendResponse(Address dest, Response rsp) {
        try {
            ByteArray buffer = COUNTER.responseToBuffer(rsp);
            Message rsp_msg = new BytesMessage(dest, buffer).putHeader(this.id, new CounterHeader());
            if (this.bypass_bundling) {
                rsp_msg.setFlag(Message.Flag.DONT_BUNDLE);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("[" + this.local_addr + "] --> [" + dest + "] " + rsp);
            }
            this.down_prot.down(rsp_msg);
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSending") + rsp + " message to " + dest + ": " + ex);
        }
    }

    protected void updateBackups(String name, long value, long version) {
        UpdateRequest req = new UpdateRequest(name, value, version);
        try {
            ByteArray buffer = COUNTER.requestToBuffer(req);
            if (this.backup_coords != null && !this.backup_coords.isEmpty()) {
                for (Address backup_coord : this.backup_coords) {
                    this.send(backup_coord, buffer);
                }
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSending") + req + " to backup coordinator(s):" + ex);
        }
    }

    protected void send(Address dest, ByteArray buffer) {
        try {
            Message rsp_msg = new BytesMessage(dest, buffer).putHeader(this.id, new CounterHeader());
            if (this.bypass_bundling) {
                rsp_msg.setFlag(Message.Flag.DONT_BUNDLE);
            }
            this.down_prot.down(rsp_msg);
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedSendingMessageTo") + dest + ": " + ex);
        }
    }

    protected void sendCounterNotFoundExceptionResponse(Address dest, Owner owner, String counter_name) {
        ExceptionResponse rsp = new ExceptionResponse(owner, "counter \"" + counter_name + "\" not found");
        this.sendResponse(dest, rsp);
    }

    protected static ByteArray requestToBuffer(Request req) throws Exception {
        return COUNTER.streamableToBuffer((byte)1, (byte)COUNTER.requestToRequestType(req).ordinal(), req);
    }

    protected static ByteArray responseToBuffer(Response rsp) throws Exception {
        return COUNTER.streamableToBuffer((byte)2, (byte)COUNTER.responseToResponseType(rsp).ordinal(), rsp);
    }

    protected static ByteArray streamableToBuffer(byte req_or_rsp, byte type, Streamable obj) throws Exception {
        int expected_size = obj instanceof SizeStreamable ? ((SizeStreamable)obj).serializedSize() : 100;
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size);
        out.writeByte(req_or_rsp);
        out.writeByte(type);
        obj.writeTo(out);
        return new ByteArray(out.buffer(), 0, out.position());
    }

    protected static Streamable streamableFromBuffer(byte[] buf, int offset, int length) throws Exception {
        switch (buf[offset]) {
            case 1: {
                return COUNTER.requestFromBuffer(buf, offset + 1, length - 1);
            }
            case 2: {
                return COUNTER.responseFromBuffer(buf, offset + 1, length - 1);
            }
        }
        throw new IllegalArgumentException("type " + buf[offset] + " is invalid (expected Request (1) or RESPONSE (2)");
    }

    protected static final Request requestFromBuffer(byte[] buf, int offset, int length) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(buf, offset, length);
        DataInputStream in = new DataInputStream(input);
        RequestType type = RequestType.values()[in.readByte()];
        Request retval = COUNTER.createRequest(type);
        retval.readFrom(in);
        return retval;
    }

    protected static Request createRequest(RequestType type) {
        switch (type) {
            case COMPARE_AND_SET: {
                return new CompareAndSetRequest();
            }
            case ADD_AND_GET: {
                return new AddAndGetRequest();
            }
            case UPDATE: {
                return new UpdateRequest();
            }
            case GET_OR_CREATE: {
                return new GetOrCreateRequest();
            }
            case DELETE: {
                return new DeleteRequest();
            }
            case SET: {
                return new SetRequest();
            }
            case RECONCILE: {
                return new ReconcileRequest();
            }
            case RESEND_PENDING_REQUESTS: {
                return new ResendPendingRequests();
            }
        }
        throw new IllegalArgumentException("failed creating a request from " + type);
    }

    protected static final Response responseFromBuffer(byte[] buf, int offset, int length) throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream(buf, offset, length);
        DataInputStream in = new DataInputStream(input);
        ResponseType type = ResponseType.values()[in.readByte()];
        Response retval = COUNTER.createResponse(type);
        retval.readFrom(in);
        return retval;
    }

    protected static Response createResponse(ResponseType type) {
        switch (type) {
            case VOID: {
                return new SimpleResponse();
            }
            case GET_OR_CREATE: {
                return new GetOrCreateResponse();
            }
            case BOOLEAN: {
                return new BooleanResponse();
            }
            case VALUE: {
                return new ValueResponse();
            }
            case EXCEPTION: {
                return new ExceptionResponse();
            }
            case RECONCILE: {
                return new ReconcileResponse();
            }
        }
        throw new IllegalArgumentException("failed creating a response from " + type);
    }

    protected synchronized void startReconciliationTask() {
        if (this.reconciliation_task_future == null || this.reconciliation_task_future.isDone()) {
            this.reconciliation_task = new ReconciliationTask();
            this.reconciliation_task_future = this.getTransport().getTimer().schedule(this.reconciliation_task, 0L, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopReconciliationTask() {
        if (this.reconciliation_task_future != null) {
            this.reconciliation_task_future.cancel(true);
            if (this.reconciliation_task != null) {
                this.reconciliation_task.cancel();
            }
            this.reconciliation_task_future = null;
        }
    }

    protected static void writeReconciliation(DataOutput out, String[] names, long[] values, long[] versions) throws IOException {
        if (names == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(names.length);
        for (String name : names) {
            Bits.writeString(name, out);
        }
        for (long value : values) {
            Bits.writeLongCompressed(value, out);
        }
        for (long version : versions) {
            Bits.writeLongCompressed(version, out);
        }
    }

    protected static String[] readReconciliationNames(DataInput in, int len) throws IOException {
        String[] retval = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            retval[i2] = Bits.readString(in);
        }
        return retval;
    }

    protected static long[] readReconciliationLongs(DataInput in, int len) throws IOException {
        long[] retval = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            retval[i2] = Bits.readLongCompressed(in);
        }
        return retval;
    }

    protected static String dump(String[] names, long[] values, long[] versions) {
        StringBuilder sb = new StringBuilder();
        if (names != null) {
            for (int i2 = 0; i2 < names.length; ++i2) {
                sb.append(names[i2]).append(": ").append(values[i2]).append(" (").append(versions[i2]).append(")\n");
            }
        }
        return sb.toString();
    }

    protected class ReconciliationTask
    implements Runnable {
        protected ResponseCollector<ReconcileResponse> responses;

        protected ReconciliationTask() {
        }

        @Override
        public void run() {
            try {
                this._run();
            }
            finally {
                COUNTER.this.discard_requests = false;
            }
            ResendPendingRequests req = new ResendPendingRequests();
            COUNTER.this.sendRequest(null, req);
        }

        protected void _run() {
            HashMap<String, VersionedValue> copy = new HashMap<String, VersionedValue>(COUNTER.this.counters);
            int len = copy.size();
            String[] names = new String[len];
            long[] values = new long[len];
            long[] versions = new long[len];
            int index = 0;
            for (Map.Entry entry : copy.entrySet()) {
                names[index] = (String)entry.getKey();
                values[index] = ((VersionedValue)entry.getValue()).value;
                versions[index] = ((VersionedValue)entry.getValue()).version;
                ++index;
            }
            ArrayList<Address> targets = new ArrayList<Address>(COUNTER.this.view.getMembers());
            targets.remove(COUNTER.this.local_addr);
            this.responses = new ResponseCollector(targets);
            ReconcileRequest req = new ReconcileRequest(names, values, versions);
            COUNTER.this.sendRequest(null, req);
            this.responses.waitForAllResponses(COUNTER.this.reconciliation_timeout);
            Map<Address, ReconcileResponse> reconcile_results = this.responses.getResults();
            for (Map.Entry<Address, ReconcileResponse> entry : reconcile_results.entrySet()) {
                ReconcileResponse rsp;
                if (entry.getKey().equals(COUNTER.this.local_addr) || (rsp = entry.getValue()) == null || rsp.names == null) continue;
                for (int i2 = 0; i2 < rsp.names.length; ++i2) {
                    String counter_name = rsp.names[i2];
                    long version = rsp.versions[i2];
                    long value = rsp.values[i2];
                    VersionedValue my_value = (VersionedValue)COUNTER.this.counters.get(counter_name);
                    if (my_value == null) {
                        COUNTER.this.counters.put(counter_name, new VersionedValue(value, version));
                        continue;
                    }
                    if (my_value.version >= version) continue;
                    my_value.updateIfBigger(value, version);
                }
            }
        }

        public void add(ReconcileResponse rsp, Address sender) {
            if (this.responses != null) {
                this.responses.add(sender, rsp);
            }
        }

        protected void cancel() {
            if (this.responses != null) {
                this.responses.reset();
            }
        }

        public String toString() {
            return COUNTER.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    protected static class VersionedValue {
        protected long value;
        protected long version = 1L;

        protected VersionedValue(long value) {
            this.value = value;
        }

        protected VersionedValue(long value, long version) {
            this.value = value;
            this.version = version;
        }

        protected synchronized long[] addAndGet(long num) {
            long[] lArray;
            if (num == 0L) {
                long[] lArray2 = new long[2];
                lArray2[0] = this.value;
                lArray = lArray2;
                lArray2[1] = this.version;
            } else {
                long[] lArray3 = new long[2];
                lArray3[0] = this.value += num;
                lArray = lArray3;
                lArray3[1] = ++this.version;
            }
            return lArray;
        }

        protected synchronized long[] set(long value) {
            this.value = value;
            return new long[]{this.value, ++this.version};
        }

        protected synchronized long[] compareAndSet(long expected, long update) {
            if (this.value == expected) {
                this.value = update;
                return new long[]{this.value, ++this.version};
            }
            return null;
        }

        protected synchronized void updateIfBigger(long value, long version) {
            if (version > this.version) {
                this.version = version;
                this.value = value;
            }
        }

        public String toString() {
            return this.value + " (version=" + this.version + ")";
        }
    }

    public static class CounterHeader
    extends Header {
        @Override
        public Supplier<? extends Header> create() {
            return CounterHeader::new;
        }

        @Override
        public short getMagicId() {
            return 74;
        }

        @Override
        public int serializedSize() {
            return 0;
        }

        @Override
        public void writeTo(DataOutput out) {
        }

        @Override
        public void readFrom(DataInput in) {
        }
    }

    protected static class ReconcileResponse
    implements Response {
        protected String[] names;
        protected long[] values;
        protected long[] versions;

        protected ReconcileResponse() {
        }

        protected ReconcileResponse(String[] names, long[] values, long[] versions) {
            this.names = names;
            this.values = values;
            this.versions = versions;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            COUNTER.writeReconciliation(out, this.names, this.values, this.versions);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            this.names = COUNTER.readReconciliationNames(in, len);
            this.values = COUNTER.readReconciliationLongs(in, len);
            this.versions = COUNTER.readReconciliationLongs(in, len);
        }

        public String toString() {
            int num = this.names != null ? this.names.length : 0;
            return "ReconcileResponse (" + num + ") entries";
        }
    }

    protected static class ExceptionResponse
    extends SimpleResponse {
        protected String error_message;

        protected ExceptionResponse() {
        }

        protected ExceptionResponse(Owner owner, String error_message) {
            super(owner, 0L);
            this.error_message = error_message;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.error_message = Bits.readString(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeString(this.error_message, out);
        }

        @Override
        public String toString() {
            return "ExceptionResponse: " + super.toString();
        }
    }

    protected static class GetOrCreateResponse
    extends ValueResponse {
        protected GetOrCreateResponse() {
        }

        protected GetOrCreateResponse(Owner owner, long result, long version) {
            super(owner, result, version);
        }

        @Override
        public String toString() {
            return "GetOrCreateResponse(" + this.result + ")";
        }
    }

    protected static class ValueResponse
    extends SimpleResponse {
        protected long result;

        protected ValueResponse() {
        }

        protected ValueResponse(Owner owner, long result, long version) {
            super(owner, version);
            this.result = result;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.result = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.result, out);
        }

        @Override
        public String toString() {
            return "ValueResponse(" + this.result + ")";
        }
    }

    protected static class BooleanResponse
    extends SimpleResponse {
        protected boolean result;

        protected BooleanResponse() {
        }

        protected BooleanResponse(Owner owner, long version, boolean result) {
            super(owner, version);
            this.result = result;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.result = in.readBoolean();
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.result);
        }

        @Override
        public String toString() {
            return "BooleanResponse(" + this.result + ")";
        }
    }

    protected static class SimpleResponse
    implements Response {
        protected Owner owner;
        protected long version;

        protected SimpleResponse() {
        }

        protected SimpleResponse(Owner owner, long version) {
            this.owner = owner;
            this.version = version;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.owner = new Owner();
            this.owner.readFrom(in);
            this.version = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            this.owner.writeTo(out);
            Bits.writeLongCompressed(this.version, out);
        }

        public String toString() {
            return "Response";
        }
    }

    protected static interface Response
    extends Streamable {
    }

    protected static class UpdateRequest
    implements Request {
        protected String name;
        protected long value;
        protected long version;

        protected UpdateRequest() {
        }

        protected UpdateRequest(String name, long value, long version) {
            this.name = name;
            this.value = value;
            this.version = version;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeString(this.name, out);
            Bits.writeLongCompressed(this.value, out);
            Bits.writeLongCompressed(this.version, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.name = Bits.readString(in);
            this.value = Bits.readLongCompressed(in);
            this.version = Bits.readLongCompressed(in);
        }

        public String toString() {
            return "UpdateRequest(" + this.name + ": " + this.value + " (" + this.version + ")";
        }
    }

    protected static class ReconcileRequest
    implements Request {
        protected String[] names;
        protected long[] values;
        protected long[] versions;

        protected ReconcileRequest() {
        }

        protected ReconcileRequest(String[] names, long[] values, long[] versions) {
            this.names = names;
            this.values = values;
            this.versions = versions;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            COUNTER.writeReconciliation(out, this.names, this.values, this.versions);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            int len = in.readInt();
            this.names = COUNTER.readReconciliationNames(in, len);
            this.values = COUNTER.readReconciliationLongs(in, len);
            this.versions = COUNTER.readReconciliationLongs(in, len);
        }

        public String toString() {
            return "ReconcileRequest (" + this.names.length + ") entries";
        }
    }

    protected static class CompareAndSetRequest
    extends SimpleRequest {
        protected long expected;
        protected long update;

        protected CompareAndSetRequest() {
        }

        protected CompareAndSetRequest(Owner owner, String name, long expected, long update) {
            super(owner, name);
            this.expected = expected;
            this.update = update;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.expected = Bits.readLongCompressed(in);
            this.update = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.expected, out);
            Bits.writeLongCompressed(this.update, out);
        }

        @Override
        public String toString() {
            return super.toString() + ", expected=" + this.expected + ", update=" + this.update;
        }
    }

    protected static class SetRequest
    extends SimpleRequest {
        protected long value;

        protected SetRequest() {
        }

        protected SetRequest(Owner owner, String name, long value) {
            super(owner, name);
            this.value = value;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.value = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.value, out);
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.value;
        }
    }

    protected static class AddAndGetRequest
    extends SetRequest {
        protected AddAndGetRequest() {
        }

        protected AddAndGetRequest(Owner owner, String name, long value) {
            super(owner, name, value);
        }

        @Override
        public String toString() {
            return "AddAndGetRequest: " + super.toString();
        }
    }

    protected static class DeleteRequest
    extends SimpleRequest {
        protected DeleteRequest() {
        }

        protected DeleteRequest(Owner owner, String name) {
            super(owner, name);
        }

        @Override
        public String toString() {
            return "DeleteRequest: " + super.toString();
        }
    }

    protected static class GetOrCreateRequest
    extends SimpleRequest {
        protected long initial_value;

        protected GetOrCreateRequest() {
        }

        GetOrCreateRequest(Owner owner, String name, long initial_value) {
            super(owner, name);
            this.initial_value = initial_value;
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.initial_value = Bits.readLongCompressed(in);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Bits.writeLongCompressed(this.initial_value, out);
        }
    }

    protected static class ResendPendingRequests
    implements Request {
        protected ResendPendingRequests() {
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
        }

        public String toString() {
            return "ResendPendingRequests";
        }
    }

    protected static class SimpleRequest
    implements Request {
        protected Owner owner;
        protected String name;

        protected SimpleRequest() {
        }

        protected SimpleRequest(Owner owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            this.owner.writeTo(out);
            Bits.writeString(this.name, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.owner = new Owner();
            this.owner.readFrom(in);
            this.name = Bits.readString(in);
        }

        public String toString() {
            return this.owner + " [" + this.name + "]";
        }
    }

    protected static interface Request
    extends Streamable {
    }

    protected class CounterImpl
    implements Counter {
        protected final String name;

        protected CounterImpl(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long get() {
            return this.addAndGet(0L);
        }

        @Override
        public void set(long new_value) {
            if (COUNTER.this.local_addr.equals(COUNTER.this.coord)) {
                VersionedValue val = COUNTER.this.getCounter(this.name);
                val.set(new_value);
                if (COUNTER.this.backup_coords != null) {
                    COUNTER.this.updateBackups(this.name, val.value, val.version);
                }
                return;
            }
            Owner owner = COUNTER.this.getOwner();
            SetRequest req = new SetRequest(owner, this.name, new_value);
            Promise promise = new Promise();
            COUNTER.this.pending_requests.put(owner, new Tuple(req, promise));
            COUNTER.this.sendRequest(COUNTER.this.coord, req);
            Object obj = null;
            try {
                obj = promise.getResultWithTimeout(COUNTER.this.timeout);
                if (obj instanceof Throwable) {
                    throw new IllegalStateException(obj);
                }
                long[] result = obj;
                long value = result[0];
                long version = result[1];
                if (!COUNTER.this.coord.equals(COUNTER.this.local_addr)) {
                    COUNTER.this.counters.put(this.name, new VersionedValue(value, version));
                }
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean compareAndSet(long expect, long update) {
            if (COUNTER.this.local_addr.equals(COUNTER.this.coord)) {
                boolean retval;
                VersionedValue val = COUNTER.this.getCounter(this.name);
                boolean bl = retval = val.compareAndSet(expect, update) != null;
                if (COUNTER.this.backup_coords != null) {
                    COUNTER.this.updateBackups(this.name, val.value, val.version);
                }
                return retval;
            }
            Owner owner = COUNTER.this.getOwner();
            CompareAndSetRequest req = new CompareAndSetRequest(owner, this.name, expect, update);
            Promise promise = new Promise();
            COUNTER.this.pending_requests.put(owner, new Tuple(req, promise));
            COUNTER.this.sendRequest(COUNTER.this.coord, req);
            Object obj = null;
            try {
                obj = promise.getResultWithTimeout(COUNTER.this.timeout);
                if (obj instanceof Throwable) {
                    throw new IllegalStateException(obj);
                }
                if (obj == null) {
                    return false;
                }
                long[] result = obj;
                long value = result[0];
                long version = result[1];
                if (!COUNTER.this.coord.equals(COUNTER.this.local_addr)) {
                    COUNTER.this.counters.put(this.name, new VersionedValue(value, version));
                }
                return true;
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long incrementAndGet() {
            return this.addAndGet(1L);
        }

        @Override
        public long decrementAndGet() {
            return this.addAndGet(-1L);
        }

        @Override
        public long addAndGet(long delta) {
            if (COUNTER.this.local_addr.equals(COUNTER.this.coord)) {
                VersionedValue val = COUNTER.this.getCounter(this.name);
                long retval = val.addAndGet(delta)[0];
                if (COUNTER.this.backup_coords != null) {
                    COUNTER.this.updateBackups(this.name, val.value, val.version);
                }
                return retval;
            }
            Owner owner = COUNTER.this.getOwner();
            AddAndGetRequest req = new AddAndGetRequest(owner, this.name, delta);
            Promise promise = new Promise();
            COUNTER.this.pending_requests.put(owner, new Tuple(req, promise));
            COUNTER.this.sendRequest(COUNTER.this.coord, req);
            Object obj = null;
            try {
                obj = promise.getResultWithTimeout(COUNTER.this.timeout);
                if (obj instanceof Throwable) {
                    throw new IllegalStateException(obj);
                }
                long[] result = obj;
                long value = result[0];
                long version = result[1];
                if (!COUNTER.this.coord.equals(COUNTER.this.local_addr)) {
                    COUNTER.this.counters.put(this.name, new VersionedValue(value, version));
                }
                return value;
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            VersionedValue val = (VersionedValue)COUNTER.this.counters.get(this.name);
            return val != null ? val.toString() : "n/a";
        }
    }

    protected static enum ResponseType {
        VOID,
        GET_OR_CREATE,
        BOOLEAN,
        VALUE,
        EXCEPTION,
        RECONCILE;

    }

    protected static enum RequestType {
        GET_OR_CREATE,
        DELETE,
        SET,
        COMPARE_AND_SET,
        ADD_AND_GET,
        UPDATE,
        RECONCILE,
        RESEND_PENDING_REQUESTS;

    }
}

