/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jgroups.annotations.Experimental;
import org.jgroups.blocks.GridFile;
import org.jgroups.blocks.GridInputStream;
import org.jgroups.blocks.GridOutputStream;
import org.jgroups.blocks.ReplCache;

@Experimental
public class GridFilesystem {
    protected final ReplCache<String, byte[]> data;
    protected final ReplCache<String, GridFile.Metadata> metadata;
    protected final int default_chunk_size;
    protected final short default_repl_count;

    public GridFilesystem(ReplCache<String, byte[]> data, ReplCache<String, GridFile.Metadata> metadata, short default_repl_count, int default_chunk_size) {
        this.data = data;
        this.metadata = metadata;
        this.default_chunk_size = default_chunk_size;
        this.default_repl_count = default_repl_count;
    }

    public GridFilesystem(ReplCache<String, byte[]> data, ReplCache<String, GridFile.Metadata> metadata) {
        this(data, metadata, 1, 8000);
    }

    public File getFile(String pathname) {
        return this.getFile(pathname, this.default_chunk_size);
    }

    public File getFile(String pathname, int chunk_size) {
        return new GridFile(pathname, this.metadata, chunk_size, this);
    }

    public File getFile(String parent, String child) {
        return this.getFile(parent, child, this.default_chunk_size);
    }

    public File getFile(String parent, String child, int chunk_size) {
        return new GridFile(parent, child, this.metadata, chunk_size, this);
    }

    public File getFile(File parent, String child) {
        return this.getFile(parent, child, this.default_chunk_size);
    }

    public File getFile(File parent, String child, int chunk_size) {
        return new GridFile(parent, child, this.metadata, chunk_size, this);
    }

    public OutputStream getOutput(String pathname) throws IOException {
        return this.getOutput(pathname, false, this.default_repl_count, this.default_chunk_size);
    }

    public OutputStream getOutput(String pathname, boolean append) throws IOException {
        return this.getOutput(pathname, append, this.default_repl_count, this.default_chunk_size);
    }

    public OutputStream getOutput(String pathname, boolean append, short repl_count, int chunk_size) throws IOException {
        GridFile file = (GridFile)this.getFile(pathname, chunk_size);
        if (!file.createNewFile()) {
            throw new IOException("creation of " + pathname + " failed");
        }
        return new GridOutputStream(file, append, this.data, repl_count, chunk_size);
    }

    public OutputStream getOutput(GridFile file) throws IOException {
        if (!file.createNewFile()) {
            throw new IOException("creation of " + file + " failed");
        }
        return new GridOutputStream(file, false, this.data, this.default_repl_count, this.default_chunk_size);
    }

    public InputStream getInput(String pathname) throws FileNotFoundException {
        GridFile file = (GridFile)this.getFile(pathname);
        if (!file.exists()) {
            throw new FileNotFoundException(pathname);
        }
        return new GridInputStream(file, this.data, this.default_chunk_size);
    }

    public InputStream getInput(File pathname) throws FileNotFoundException {
        return pathname != null ? this.getInput(pathname.getPath()) : null;
    }

    public void remove(String path, boolean synchronous) {
        if (path == null) {
            return;
        }
        GridFile.Metadata md = this.metadata.get(path);
        if (md == null) {
            return;
        }
        int num_chunks = md.getLength() / md.getChunkSize() + 1;
        for (int i2 = 0; i2 < num_chunks; ++i2) {
            this.data.remove(path + ".#" + i2, synchronous);
        }
    }
}

