/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakEventListenerList
implements Serializable {
    protected transient List<WeakReference<? extends EventListener>> weakReferences;
    protected transient List<Class<? extends EventListener>> classes;

    public Object[] getListenerList() {
        List listeners = this.cleanReferences();
        Object[] result = new Object[listeners.size() * 2];
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            result[2 * i2 + 1] = listeners.get(i2);
            result[2 * i2] = this.getClasses().get(i2);
        }
        return result;
    }

    private synchronized <T extends EventListener> List<T> cleanReferences() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        for (int i2 = this.getReferences().size() - 1; i2 >= 0; --i2) {
            Object listener = this.getReferences().get(i2).get();
            if (listener == null) {
                this.getReferences().remove(i2);
                this.getClasses().remove(i2);
                continue;
            }
            listeners.add(0, (EventListener)listener);
        }
        return listeners;
    }

    private List<WeakReference<? extends EventListener>> getReferences() {
        if (this.weakReferences == null) {
            this.weakReferences = new ArrayList<WeakReference<? extends EventListener>>();
        }
        return this.weakReferences;
    }

    private List<Class<? extends EventListener>> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<Class<? extends EventListener>>();
        }
        return this.classes;
    }

    public <T extends EventListener> T[] getListeners(Class<T> t) {
        List<T> liveListeners = this.cleanReferences();
        ArrayList<T> listeners = new ArrayList<T>();
        for (int i2 = 0; i2 < liveListeners.size(); ++i2) {
            if (this.getClasses().get(i2) != t) continue;
            listeners.add(liveListeners.get(i2));
        }
        EventListener[] result = (EventListener[])Array.newInstance(t, listeners.size());
        return listeners.toArray(result);
    }

    public synchronized <T extends EventListener> void add(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        this.cleanReferences();
        this.getReferences().add(new WeakReference<T>(l));
        this.getClasses().add(t);
    }

    public synchronized <T extends EventListener> void remove(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        for (int i2 = 0; i2 < this.getReferences().size(); ++i2) {
            if (!l.equals(this.getReferences().get(i2).get()) || t != this.getClasses().get(i2)) continue;
            this.getReferences().remove(i2);
            this.getClasses().remove(i2);
            break;
        }
    }
}

