/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

public class Types {
    public ParameterizedType findParameterizedType(Class<?> klass, Class<?> parameterizedClass) {
        return new ParameterizedTypeImpl((Type)parameterizedClass, this.resolveArgumentTypes(klass, parameterizedClass));
    }

    public Class<?> findParamType(ParameterizedType type, Class<?> expectedWrapper) {
        if (type.getActualTypeArguments().length != 1) {
            return null;
        }
        Class<?> asClass = this.asClass(type.getRawType());
        if (asClass == null || !expectedWrapper.isAssignableFrom(asClass)) {
            return null;
        }
        return this.asClass(type.getActualTypeArguments()[0]);
    }

    public Class<?> asClass(Type type) {
        return Class.class.isInstance(type) ? (Class)Class.class.cast(type) : null;
    }

    private Type[] resolveArgumentTypes(Type type, Class<?> parameterizedClass) {
        if (type instanceof Class) {
            return this.resolveArgumentTypes((Class)type, parameterizedClass);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveArgumentTypes((ParameterizedType)type, parameterizedClass);
        }
        throw new IllegalArgumentException("Cannot resolve argument types from " + type.getClass().getSimpleName());
    }

    private Type[] resolveArgumentTypes(Class<?> type, Class<?> parameterizedClass) {
        if (parameterizedClass.equals(type)) {
            return (Type[])Arrays.copyOf(type.getTypeParameters(), parameterizedClass.getTypeParameters().length, Type[].class);
        }
        if (type.getSuperclass() != null && parameterizedClass.isAssignableFrom(type.getSuperclass())) {
            return this.resolveArgumentTypes(type.getGenericSuperclass(), parameterizedClass);
        }
        Class<?>[] interfaces = type.getInterfaces();
        Type[] genericInterfaces = type.getGenericInterfaces();
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            if (!parameterizedClass.isAssignableFrom(interfaces[i2])) continue;
            return this.resolveArgumentTypes(genericInterfaces[i2], parameterizedClass);
        }
        throw new IllegalArgumentException(String.format("%s is not assignable from %s", type, parameterizedClass));
    }

    private Type[] resolveArgumentTypes(ParameterizedType type, Class<?> parameterizedClass) {
        Class rawType = (Class)type.getRawType();
        TypeVariable<Class<T>>[] typeVariables = rawType.getTypeParameters();
        Type[] types = this.resolveArgumentTypes(rawType, parameterizedClass);
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (!(types[i2] instanceof TypeVariable)) continue;
            TypeVariable typeVariable = (TypeVariable)types[i2];
            for (int j = 0; j < typeVariables.length; ++j) {
                if (!typeVariables[j].getName().equals(typeVariable.getName())) continue;
                types[i2] = type.getActualTypeArguments()[j];
            }
        }
        return types;
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] arguments;

        private ParameterizedTypeImpl(Type rawType, Type ... arguments) {
            this.rawType = rawType;
            this.arguments = arguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.arguments;
        }

        public int hashCode() {
            return Arrays.hashCode(this.arguments) ^ (this.rawType == null ? 0 : this.rawType.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ParameterizedType) {
                ParameterizedType that = (ParameterizedType)obj;
                Type thatRawType = that.getRawType();
                return that.getOwnerType() == null && (this.rawType == null ? thatRawType == null : this.rawType.equals(thatRawType)) && Arrays.equals(this.arguments, that.getActualTypeArguments());
            }
            return false;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(((Class)this.rawType).getSimpleName());
            Type[] actualTypes = this.getActualTypeArguments();
            if (actualTypes.length > 0) {
                buffer.append("<");
                int length = actualTypes.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    buffer.append(actualTypes[i2].toString());
                    if (i2 == actualTypes.length - 1) continue;
                    buffer.append(",");
                }
                buffer.append(">");
            }
            return buffer.toString();
        }
    }
}

