/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.serverLocator;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.uri.schema.connector.TCPTransportConfigurationSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.ConnectionOptions;
import org.apache.activemq.artemis.utils.IPV6Util;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class TCPServerLocatorSchema
extends AbstractServerLocatorSchema {
    @Override
    public String getSchemaName() {
        return "tcp";
    }

    @Override
    protected ServerLocator internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        List<TransportConfiguration> configurations = TCPTransportConfigurationSchema.getTransportConfigurations(uri, query2, TransportConstants.ALLOWABLE_CONNECTOR_KEYS, name, NettyConnectorFactory.class.getName());
        TransportConfiguration[] tcs = new TransportConfiguration[configurations.size()];
        configurations.toArray(tcs);
        BeanSupport.stripPasswords(query2);
        ConnectionOptions options = this.newConnectionOptions(uri, query2);
        if (options.isHa()) {
            return BeanSupport.setData(uri, ActiveMQClient.createServerLocatorWithHA(tcs), query2);
        }
        return BeanSupport.setData(uri, ActiveMQClient.createServerLocatorWithoutHA(tcs), query2);
    }

    @Override
    protected URI internalNewURI(ServerLocator bean2) throws Exception {
        String query2 = BeanSupport.getData(null, bean2);
        TransportConfiguration[] staticConnectors = bean2.getStaticTransportConfigurations();
        return TCPServerLocatorSchema.getURI(query2, staticConnectors);
    }

    public static URI getURI(String query2, TransportConfiguration[] staticConnectors) throws Exception {
        if (staticConnectors == null || staticConnectors.length < 1) {
            throw new Exception();
        }
        StringBuilder fragment = new StringBuilder();
        for (int i2 = 1; i2 < staticConnectors.length; ++i2) {
            TransportConfiguration connector = staticConnectors[i2];
            Map<String, Object> params = TCPServerLocatorSchema.escapeIPv6Host(connector.getParams());
            URI extraUri = new URI("tcp", null, TCPServerLocatorSchema.getHost(params), TCPServerLocatorSchema.getPort(params), null, TCPServerLocatorSchema.createQuery(params, null), null);
            if (i2 > 1) {
                fragment.append(",");
            }
            fragment.append(extraUri.toASCIIString());
        }
        Map<String, Object> params = TCPServerLocatorSchema.escapeIPv6Host(staticConnectors[0].getParams());
        return new URI("tcp", null, TCPServerLocatorSchema.getHost(params), TCPServerLocatorSchema.getPort(params), null, TCPServerLocatorSchema.createQuery(params, query2), fragment.toString());
    }

    private static Map<String, Object> escapeIPv6Host(Map<String, Object> params) {
        String newHost;
        String host = (String)params.get("host");
        if (host != (newHost = IPV6Util.encloseHost(host))) {
            params.put("host", "[" + host + "]");
        }
        return params;
    }

    private static int getPort(Map<String, Object> params) {
        Object port = params.get("port");
        if (port instanceof String) {
            return Integer.valueOf((String)port);
        }
        return port != null ? (Integer)port : 61616;
    }

    private static String getHost(Map<String, Object> params) {
        return params.get("host") != null ? (String)params.get("host") : "localhost";
    }

    private static String createQuery(Map<String, Object> params, String query2) throws Exception {
        boolean empty;
        StringBuilder cb;
        if (query2 == null) {
            cb = new StringBuilder();
            empty = true;
        } else {
            cb = new StringBuilder(query2);
            empty = false;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            if (!empty) {
                cb.append("&");
            } else {
                empty = false;
            }
            cb.append(BeanSupport.encodeURI(entry.getKey()));
            cb.append("=");
            cb.append(BeanSupport.encodeURI(entry.getValue().toString()));
        }
        return cb.toString();
    }
}

