/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing.pools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.core.cluster.DiscoveryEntry;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.server.balancing.pools.DiscoveryService;

public class DiscoveryGroupService
extends DiscoveryService
implements DiscoveryListener {
    private final DiscoveryGroup discoveryGroup;
    private final Map<String, DiscoveryService.Entry> entries = new ConcurrentHashMap<String, DiscoveryService.Entry>();

    public DiscoveryGroupService(DiscoveryGroup discoveryGroup) {
        this.discoveryGroup = discoveryGroup;
    }

    @Override
    public void start() throws Exception {
        this.discoveryGroup.registerListener(this);
        this.discoveryGroup.start();
    }

    @Override
    public void stop() throws Exception {
        this.discoveryGroup.unregisterListener(this);
        this.discoveryGroup.stop();
        this.entries.clear();
    }

    @Override
    public boolean isStarted() {
        return this.discoveryGroup.isStarted();
    }

    @Override
    public void connectorsChanged(List<DiscoveryEntry> newEntries) {
        HashMap<String, DiscoveryService.Entry> oldEntries = new HashMap<String, DiscoveryService.Entry>(this.entries);
        for (DiscoveryEntry newEntry : newEntries) {
            DiscoveryService.Entry oldEntry = (DiscoveryService.Entry)oldEntries.remove(newEntry.getNodeID());
            if (oldEntry == null) {
                DiscoveryService.Entry addingEntry = new DiscoveryService.Entry(this, newEntry.getNodeID(), newEntry.getConnector());
                this.entries.put(addingEntry.getNodeID(), addingEntry);
                this.fireEntryAddedEvent(addingEntry);
                continue;
            }
            if (newEntry.getConnector().equals(oldEntry.getConnector())) continue;
            DiscoveryService.Entry updatingEntry = new DiscoveryService.Entry(this, newEntry.getNodeID(), newEntry.getConnector());
            this.entries.put(updatingEntry.getNodeID(), updatingEntry);
            this.fireEntryUpdatedEvent(oldEntry, updatingEntry);
        }
        oldEntries.forEach((nodeID, entry) -> {
            this.entries.remove(nodeID);
            this.fireEntryRemovedEvent((DiscoveryService.Entry)entry);
        });
    }
}

