/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageCursorProvider;
import org.apache.activemq.artemis.core.paging.cursor.impl.LivePageCacheImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageSyncTimer;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.impl.MessageReferenceImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnable;
import org.jboss.logging.Logger;

public class PagingStoreImpl
implements PagingStore {
    private static final Logger logger = Logger.getLogger(PagingStoreImpl.class);
    private final SimpleString address;
    private final StorageManager storageManager;
    private final DecimalFormat format = new DecimalFormat("000000000");
    private int currentPageSize = 0;
    private final SimpleString storeName;
    private volatile SequentialFileFactory fileFactory;
    private final PagingStoreFactory storeFactory;
    private final PageSyncTimer syncTimer;
    private long maxSize;
    private int pageSize;
    private volatile AddressFullMessagePolicy addressFullMessagePolicy;
    private boolean printedDropMessagesWarning;
    private final PagingManager pagingManager;
    private final boolean usingGlobalMaxSize;
    private final ArtemisExecutor executor;
    private final AtomicLong sizeInBytes = new AtomicLong();
    private int numberOfPages;
    private int firstPageId;
    private volatile int currentPageId;
    private volatile Page currentPage;
    private volatile boolean paging = false;
    private final PageCursorProvider cursorProvider;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean running = false;
    private final boolean syncNonTransactional;
    private volatile boolean blocking = false;
    private long rejectThreshold;
    private final java.util.Queue<Runnable> onMemoryFreedRunnables = new ConcurrentLinkedQueue<Runnable>();

    public PagingStoreImpl(SimpleString address, ScheduledExecutorService scheduledExecutor, long syncTimeout, PagingManager pagingManager, StorageManager storageManager, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, ArtemisExecutor executor, boolean syncNonTransactional) {
        this(address, scheduledExecutor, syncTimeout, pagingManager, storageManager, fileFactory, storeFactory, storeName, addressSettings, executor, executor, syncNonTransactional);
    }

    public PagingStoreImpl(SimpleString address, ScheduledExecutorService scheduledExecutor, long syncTimeout, PagingManager pagingManager, StorageManager storageManager, SequentialFileFactory fileFactory, PagingStoreFactory storeFactory, SimpleString storeName, AddressSettings addressSettings, ArtemisExecutor executor, ArtemisExecutor ioExecutor, boolean syncNonTransactional) {
        if (pagingManager == null) {
            throw new IllegalStateException("Paging Manager can't be null");
        }
        this.address = address;
        this.storageManager = storageManager;
        this.storeName = storeName;
        this.applySetting(addressSettings);
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE && this.maxSize != -1L && (long)this.pageSize >= this.maxSize) {
            throw new IllegalStateException("pageSize for address " + address + " >= maxSize. Normally pageSize should be significantly smaller than maxSize, ms: " + this.maxSize + " ps " + this.pageSize);
        }
        this.executor = executor;
        this.pagingManager = pagingManager;
        this.fileFactory = fileFactory;
        this.storeFactory = storeFactory;
        this.syncNonTransactional = syncNonTransactional;
        this.syncTimer = scheduledExecutor != null && syncTimeout > 0L ? new PageSyncTimer(this, scheduledExecutor, ioExecutor, syncTimeout) : null;
        this.cursorProvider = storeFactory.newCursorProvider(this, this.storageManager, addressSettings, executor);
        this.usingGlobalMaxSize = pagingManager.isUsingGlobalSize();
    }

    @Override
    public void applySetting(AddressSettings addressSettings) {
        this.maxSize = addressSettings.getMaxSizeBytes();
        this.pageSize = addressSettings.getPageSizeBytes();
        this.addressFullMessagePolicy = addressSettings.getAddressFullMessagePolicy();
        this.rejectThreshold = addressSettings.getMaxSizeBytesRejectThreshold();
        if (this.cursorProvider != null) {
            this.cursorProvider.setCacheMaxSize(addressSettings.getPageCacheMaxSize());
        }
    }

    public String toString() {
        return "PagingStoreImpl(" + this.address + ")";
    }

    @Override
    public boolean lock(long timeout) {
        if (timeout == -1L) {
            this.lock.writeLock().lock();
            return true;
        }
        try {
            return this.lock.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void unlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public PageCursorProvider getCursorProvider() {
        return this.cursorProvider;
    }

    @Override
    public long getFirstPage() {
        return this.firstPageId;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getAddressSize() {
        return this.sizeInBytes.get();
    }

    @Override
    public long getMaxSize() {
        if (this.maxSize < 0L) {
            return this.pageSize * 2;
        }
        return this.maxSize;
    }

    @Override
    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    @Override
    public int getPageSizeBytes() {
        return this.pageSize;
    }

    @Override
    public File getFolder() {
        SequentialFileFactory factoryUsed = this.fileFactory;
        if (factoryUsed != null) {
            return factoryUsed.getDirectory();
        }
        return null;
    }

    @Override
    public boolean isPaging() {
        AddressFullMessagePolicy policy = this.addressFullMessagePolicy;
        if (policy == AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        if (policy == AddressFullMessagePolicy.FAIL) {
            return this.isFull();
        }
        if (policy == AddressFullMessagePolicy.DROP) {
            return this.isFull();
        }
        return this.paging;
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    @Override
    public int getCurrentWritingPage() {
        return this.currentPageId;
    }

    @Override
    public SimpleString getStoreName() {
        return this.storeName;
    }

    @Override
    public void sync() throws Exception {
        if (this.syncTimer != null) {
            this.syncTimer.addSync(this.storageManager.getContext());
        } else {
            this.ioSync();
        }
    }

    @Override
    public void ioSync() throws Exception {
        this.lock.readLock().lock();
        try {
            Page page = this.currentPage;
            if (page != null) {
                page.sync();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void processReload() throws Exception {
        this.cursorProvider.processReload();
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.running) {
            this.cursorProvider.flushExecutors();
            this.cursorProvider.stop();
            ArrayList pendingTasks = new ArrayList();
            int pendingTasksWhileShuttingDown = this.executor.shutdownNow(pendingTasks::add, 30, TimeUnit.SECONDS);
            if (pendingTasksWhileShuttingDown > 0) {
                logger.tracef("Try executing %d pending tasks on stop", pendingTasksWhileShuttingDown);
                for (Runnable pendingTask : pendingTasks) {
                    try {
                        pendingTask.run();
                    }
                    catch (Throwable t) {
                        logger.warn((Object)"Error while executing a pending task on shutdown", t);
                    }
                }
            }
            this.running = false;
            Page page = this.currentPage;
            if (page != null) {
                page.close(false);
                this.currentPage = null;
            }
        }
    }

    @Override
    public void flushExecutors() {
        this.cursorProvider.flushExecutors();
        FutureLatch future = new FutureLatch();
        this.executor.execute(future);
        if (!future.await(60000L)) {
            ActiveMQServerLogger.LOGGER.pageStoreTimeout(this.address);
        }
    }

    public int getNumberOfFiles() throws Exception {
        SequentialFileFactory fileFactory = this.fileFactory;
        if (fileFactory != null) {
            List<String> files = fileFactory.listFiles("page");
            return files.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.lock.writeLock().lock();
        try {
            if (this.running) {
                return;
            }
            this.running = true;
            this.firstPageId = Integer.MAX_VALUE;
            SequentialFileFactory fileFactory = this.fileFactory;
            if (fileFactory != null) {
                Page page;
                int pageId;
                this.currentPageId = pageId = 0;
                Page oldPage = this.currentPage;
                if (oldPage != null) {
                    oldPage.close(false);
                }
                this.currentPage = null;
                List<String> files = fileFactory.listFiles("page");
                this.numberOfPages = files.size();
                for (String fileName : files) {
                    int fileId = PagingStoreImpl.getPageIdFromFileName(fileName);
                    if (fileId > pageId) {
                        pageId = fileId;
                    }
                    if (fileId >= this.firstPageId) continue;
                    this.firstPageId = fileId;
                }
                this.currentPageId = pageId;
                if (pageId != 0) {
                    this.reloadLivePage(pageId);
                }
                if ((page = this.currentPage) != null && (this.numberOfPages != 1 || page.getSize() != 0)) {
                    this.startPaging();
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void reloadLivePage(int pageId) throws Exception {
        Page page = this.createPage(pageId);
        page.open();
        List<PagedMessage> messages = page.read(this.storageManager);
        PagedMessage[] initialMessages = messages.toArray(new PagedMessage[messages.size()]);
        LivePageCacheImpl pageCache = new LivePageCacheImpl(pageId, initialMessages);
        page.setLiveCache(pageCache);
        this.currentPageSize = page.getSize();
        this.currentPage = page;
        this.cursorProvider.addLivePageCache(pageCache);
        if ((long)page.getSize() != page.getFile().size()) {
            this.openNewPage();
        }
    }

    @Override
    public void stopPaging() {
        this.lock.writeLock().lock();
        try {
            boolean isPaging = this.paging;
            if (isPaging) {
                this.paging = false;
                ActiveMQServerLogger.LOGGER.pageStoreStop(this.storeName, this.sizeInBytes.get(), this.maxSize, this.pagingManager.getGlobalSize());
            }
            this.cursorProvider.onPageModeCleared();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean startPaging() {
        if (!this.running) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            if (this.paging) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.paging) {
                boolean bl = false;
                return bl;
            }
            if (this.currentPage == null) {
                try {
                    this.openNewPage();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.pageStoreStartIOError(e);
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
            }
            this.paging = true;
            ActiveMQServerLogger.LOGGER.pageStoreStart(this.storeName, this.sizeInBytes.get(), this.maxSize, this.pagingManager.getGlobalSize());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Page getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean checkPageFileExists(int pageNumber) {
        String fileName = this.createFileName(pageNumber);
        SequentialFileFactory factory = null;
        try {
            factory = this.checkFileFactory();
            SequentialFile file = factory.createSequentialFile(fileName);
            return file.exists() && file.size() > 0L;
        }
        catch (Exception ignored) {
            logger.warn((Object)"PagingStoreFactory::checkPageFileExists never-throws assumption failed.", ignored);
            return true;
        }
    }

    @Override
    public Page createPage(int pageNumber) throws Exception {
        String fileName = this.createFileName(pageNumber);
        SequentialFileFactory factory = this.checkFileFactory();
        SequentialFile file = factory.createSequentialFile(fileName);
        Page page = new Page(this.storeName, this.storageManager, factory, file, pageNumber);
        file.open();
        file.position(0L);
        file.close(false, false);
        return page;
    }

    private SequentialFileFactory checkFileFactory() throws Exception {
        SequentialFileFactory factory = this.fileFactory;
        if (factory == null) {
            this.fileFactory = factory = this.storeFactory.newFileFactory(this.getStoreName());
        }
        return factory;
    }

    @Override
    public void forceAnotherPage() throws Exception {
        this.openNewPage();
    }

    @Override
    public Page depage() throws Exception {
        this.lock.writeLock().lock();
        try {
            Page returnPage;
            if (!this.running) {
                Page page = null;
                return page;
            }
            if (this.numberOfPages == 0) {
                Page page = null;
                return page;
            }
            --this.numberOfPages;
            if (this.currentPageId == this.firstPageId) {
                this.firstPageId = Integer.MAX_VALUE;
                if (this.currentPage == null) {
                    throw new IllegalStateException("CurrentPage is null");
                }
                Page returnPage2 = this.currentPage;
                returnPage2.close(false);
                this.currentPage = null;
                if (returnPage2.getNumberOfMessages() == 0) {
                    this.stopPaging();
                    returnPage2.open();
                    returnPage2.delete(null);
                    Page page = null;
                    return page;
                }
                this.openNewPage();
                Page page = returnPage2;
                return page;
            }
            Page page = returnPage = this.createPage(this.firstPageId++);
            return page;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void memoryReleased() {
        Runnable runnable;
        while ((runnable = this.onMemoryFreedRunnables.poll()) != null) {
            runnable.run();
        }
    }

    @Override
    public boolean checkMemory(Runnable runWhenAvailable) {
        return this.checkMemory(true, runWhenAvailable, null);
    }

    @Override
    public boolean checkMemory(boolean runOnFailure, Runnable runWhenAvailable, Runnable runWhenBlocking) {
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL && (this.maxSize != -1L || this.usingGlobalMaxSize || this.pagingManager.isDiskFull())) {
            if (this.isFull()) {
                if (runOnFailure && runWhenAvailable != null) {
                    this.onMemoryFreedRunnables.add(AtomicRunnable.checkAtomic(runWhenAvailable));
                }
                return false;
            }
        } else if ((this.pagingManager.isDiskFull() || this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK && (this.maxSize != -1L || this.usingGlobalMaxSize)) && (this.pagingManager.isDiskFull() || this.maxSize > 0L && this.sizeInBytes.get() >= this.maxSize || this.pagingManager.isGlobalFull())) {
            if (runWhenBlocking != null) {
                runWhenBlocking.run();
            }
            this.onMemoryFreedRunnables.add(AtomicRunnable.checkAtomic(runWhenAvailable));
            if (!(this.pagingManager.isGlobalFull() || this.sizeInBytes.get() > this.maxSize && this.maxSize >= 0L)) {
                runWhenAvailable.run();
            } else {
                if (this.usingGlobalMaxSize || this.pagingManager.isDiskFull()) {
                    this.pagingManager.addBlockedStore(this);
                }
                if (!this.blocking) {
                    if (this.pagingManager.isDiskFull()) {
                        ActiveMQServerLogger.LOGGER.blockingDiskFull(this.address);
                    } else {
                        ActiveMQServerLogger.LOGGER.blockingMessageProduction(this.address, this.sizeInBytes.get(), this.maxSize, this.pagingManager.getGlobalSize());
                    }
                    this.blocking = true;
                }
            }
            return true;
        }
        if (runWhenAvailable != null) {
            runWhenAvailable.run();
        }
        return true;
    }

    @Override
    public void addSize(int size) {
        boolean globalFull = this.pagingManager.addSize(size).isGlobalFull();
        long newSize = this.sizeInBytes.addAndGet(size);
        if (newSize < 0L) {
            ActiveMQServerLogger.LOGGER.negativeAddressSize(newSize, this.address.toString());
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK || this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
            if (this.usingGlobalMaxSize && !globalFull || this.maxSize != -1L) {
                this.checkReleaseMemory(globalFull, newSize);
            }
            return;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.PAGE) {
            if (size > 0 && (this.maxSize != -1L && newSize > this.maxSize || globalFull)) {
                this.startPaging();
            }
            return;
        }
    }

    @Override
    public boolean checkReleasedMemory() {
        return this.checkReleaseMemory(this.pagingManager.isGlobalFull(), this.sizeInBytes.get());
    }

    public boolean checkReleaseMemory(boolean globalOversized, long newSize) {
        if (!(globalOversized || newSize > this.maxSize && this.maxSize >= 0L || this.onMemoryFreedRunnables.isEmpty())) {
            this.executor.execute(this::memoryReleased);
            if (this.blocking) {
                ActiveMQServerLogger.LOGGER.unblockingMessageProduction(this.address, this.sizeInBytes.get(), this.maxSize);
                this.blocking = false;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean page(Message message, Transaction tx, RouteContextList listCtx, ReentrantReadWriteLock.ReadLock managerLock) throws Exception {
        if (!this.running) {
            return false;
        }
        boolean full = this.isFull();
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.DROP || this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
            if (full) {
                if (!this.printedDropMessagesWarning) {
                    this.printedDropMessagesWarning = true;
                    ActiveMQServerLogger.LOGGER.pageStoreDropMessages(this.storeName, this.sizeInBytes.get(), this.maxSize, this.pagingManager.getGlobalSize());
                }
                if (message.isLargeMessage()) {
                    ((LargeServerMessage)((Object)message)).deleteFile();
                }
                if (this.addressFullMessagePolicy == AddressFullMessagePolicy.FAIL) {
                    throw ActiveMQMessageBundle.BUNDLE.addressIsFull(this.address.toString());
                }
                return true;
            }
            return false;
        }
        if (this.addressFullMessagePolicy == AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        this.lock.readLock().lock();
        try {
            if (!this.paging) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (managerLock != null) {
            managerLock.lock();
        }
        try {
            block27: {
                this.lock.writeLock().lock();
                try {
                    if (this.paging) break block27;
                    boolean bl = false;
                    this.lock.writeLock().unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    this.lock.writeLock().unlock();
                    throw throwable;
                }
            }
            long transactionID = tx == null ? -1L : tx.getID();
            PagedMessageImpl pagedMessage = new PagedMessageImpl(message, this.routeQueues(tx, listCtx), transactionID);
            if (message.isLargeMessage()) {
                ((LargeServerMessage)((Object)message)).setPaged();
            }
            int bytesToWrite = pagedMessage.getEncodeSize() + 6;
            this.currentPageSize += bytesToWrite;
            if (this.currentPageSize > this.pageSize && this.currentPage.getNumberOfMessages() > 0) {
                this.openNewPage();
                this.currentPageSize += bytesToWrite;
            }
            if (tx != null) {
                this.installPageTransaction(tx, listCtx);
            }
            long persistentSize = pagedMessage.getPersistentSize() > 0L ? pagedMessage.getPersistentSize() : 0L;
            Page page = this.currentPage;
            this.applyPageCounters(tx, page, listCtx, persistentSize);
            page.write(pagedMessage);
            if (tx == null && this.syncNonTransactional && message.isDurable()) {
                this.sync();
            }
            if (logger.isTraceEnabled()) {
                logger.tracef("Paging message %s on pageStore %s pageNr=%d", (Object)pagedMessage, (Object)this.getStoreName(), (Object)page.getPageId());
            }
            boolean bl = true;
            this.lock.writeLock().unlock();
            return bl;
        }
        finally {
            if (managerLock != null) {
                managerLock.unlock();
            }
        }
    }

    @Override
    public void disableCleanup() {
        this.getCursorProvider().disableCleanup();
    }

    @Override
    public void enableCleanup() {
        this.getCursorProvider().resumeCleanup();
    }

    private long[] routeQueues(Transaction tx, RouteContextList ctx) throws Exception {
        List<Queue> durableQueues = ctx.getDurableQueues();
        List<Queue> nonDurableQueues = ctx.getNonDurableQueues();
        long[] ids = new long[durableQueues.size() + nonDurableQueues.size()];
        int i2 = 0;
        for (Queue q : durableQueues) {
            q.getPageSubscription().notEmpty();
            ids[i2++] = q.getID();
        }
        for (Queue q : nonDurableQueues) {
            q.getPageSubscription().notEmpty();
            ids[i2++] = q.getID();
        }
        return ids;
    }

    private void applyPageCounters(Transaction tx, Page page, RouteContextList ctx, long size) throws Exception {
        List<Queue> durableQueues = ctx.getDurableQueues();
        List<Queue> nonDurableQueues = ctx.getNonDurableQueues();
        for (Queue q : durableQueues) {
            if (tx == null) {
                q.getPageSubscription().getCounter().pendingCounter(page, 1, size);
                continue;
            }
            q.getPageSubscription().getCounter().increment(tx, 1, size);
        }
        for (Queue q : nonDurableQueues) {
            q.getPageSubscription().getCounter().increment(tx, 1, size);
        }
    }

    @Override
    public void durableDown(Message message, int durableCount) {
        this.refDown(message, durableCount);
    }

    @Override
    public void durableUp(Message message, int durableCount) {
        this.refUp(message, durableCount);
    }

    @Override
    public void refUp(Message message, int count) {
        this.addSize(MessageReferenceImpl.getMemoryEstimate());
    }

    @Override
    public void refDown(Message message, int count) {
        if (count < 0) {
            return;
        }
        this.addSize(-MessageReferenceImpl.getMemoryEstimate());
    }

    private void installPageTransaction(Transaction tx, RouteContextList listCtx) throws Exception {
        FinishPageMessageOperation pgOper = (FinishPageMessageOperation)tx.getProperty(5);
        if (pgOper == null) {
            PageTransactionInfoImpl pgTX = new PageTransactionInfoImpl(tx.getID());
            this.pagingManager.addTransaction(pgTX);
            pgOper = new FinishPageMessageOperation(pgTX, this.storageManager, this.pagingManager);
            tx.putProperty(5, pgOper);
            tx.addOperation(pgOper);
        }
        pgOper.addStore(this);
        pgOper.pageTransaction.increment(listCtx.getNumberOfDurableQueues(), listCtx.getNumberOfNonDurableQueues());
    }

    @Override
    public void destroy() throws Exception {
        SequentialFileFactory factory = this.fileFactory;
        if (factory != null) {
            this.storeFactory.removeFileFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewPage() throws Exception {
        this.lock.writeLock().lock();
        try {
            Page newPage;
            Page oldPage;
            ++this.numberOfPages;
            int newPageId = this.currentPageId + 1;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("new pageNr=" + newPageId), new Exception("trace"));
            }
            if ((oldPage = this.currentPage) != null) {
                oldPage.close(true);
            }
            this.currentPage = newPage = this.createPage(newPageId);
            LivePageCacheImpl pageCache = new LivePageCacheImpl(newPageId);
            newPage.setLiveCache(pageCache);
            this.cursorProvider.addLivePageCache(pageCache);
            this.currentPageSize = 0;
            newPage.open();
            this.currentPageId = newPageId;
            if (newPageId < this.firstPageId) {
                this.firstPageId = newPageId;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFileName(int pageID) {
        DecimalFormat decimalFormat = this.format;
        synchronized (decimalFormat) {
            return this.format.format(pageID) + ".page";
        }
    }

    private static int getPageIdFromFileName(String fileName) {
        return Integer.parseInt(fileName.substring(0, fileName.indexOf(46)));
    }

    @Override
    public boolean isFull() {
        return this.maxSize > 0L && this.getAddressSize() > this.maxSize || this.pagingManager.isGlobalFull();
    }

    @Override
    public boolean isRejectingMessages() {
        if (this.addressFullMessagePolicy != AddressFullMessagePolicy.BLOCK) {
            return false;
        }
        return this.rejectThreshold != -1L && this.getAddressSize() > this.rejectThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getCurrentIds() throws Exception {
        this.lock.readLock().lock();
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            SequentialFileFactory factory = this.fileFactory;
            if (factory != null) {
                for (String fileName : factory.listFiles("page")) {
                    ids.add(PagingStoreImpl.getPageIdFromFileName(fileName));
                }
            }
            ArrayList<Integer> arrayList = ids;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void sendPages(ReplicationManager replicator, Collection<Integer> pageIds) throws Exception {
        SequentialFileFactory factory = this.fileFactory;
        for (Integer id : pageIds) {
            SequentialFile sFile = factory.createSequentialFile(this.createFileName(id));
            if (!sFile.exists()) continue;
            ActiveMQServerLogger.LOGGER.replicaSyncFile(sFile, sFile.size());
            replicator.syncPages(sFile, id.intValue(), this.getAddress());
        }
    }

    private static class FinishPageMessageOperation
    implements TransactionOperation {
        private final PageTransactionInfo pageTransaction;
        private final StorageManager storageManager;
        private final PagingManager pagingManager;
        private final Set<PagingStore> usedStores = new HashSet<PagingStore>();
        private boolean stored = false;

        public void addStore(PagingStore store) {
            this.usedStores.add(store);
        }

        private FinishPageMessageOperation(PageTransactionInfo pageTransaction, StorageManager storageManager, PagingManager pagingManager) {
            this.pageTransaction = pageTransaction;
            this.storageManager = storageManager;
            this.pagingManager = pagingManager;
        }

        @Override
        public void afterCommit(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.commit();
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void afterRollback(Transaction tx) {
            if (this.pageTransaction != null) {
                this.pageTransaction.rollback();
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            this.syncStore();
            this.storePageTX(tx);
        }

        private void syncStore() throws Exception {
            for (PagingStore store : this.usedStores) {
                store.sync();
            }
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
            this.syncStore();
            this.storePageTX(tx);
        }

        private void storePageTX(Transaction tx) throws Exception {
            if (!this.stored) {
                tx.setContainsPersistent();
                this.pageTransaction.store(this.storageManager, this.pagingManager, tx);
                this.stored = true;
            }
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }

        @Override
        public List<MessageReference> getListOnConsumer(long consumerID) {
            return Collections.emptyList();
        }
    }
}

