/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;

public class PagedMessageImpl
implements PagedMessage {
    private byte[] largeMessageLazyData;
    private Message message;
    private long[] queueIDs;
    private long transactionID = 0L;
    private final int storedSize;
    private final StorageManager storageManager;

    public PagedMessageImpl(Message message, long[] queueIDs, long transactionID) {
        this(message, queueIDs);
        this.transactionID = transactionID;
    }

    public PagedMessageImpl(Message message, long[] queueIDs) {
        this.storageManager = null;
        this.queueIDs = queueIDs;
        this.message = message;
        this.storedSize = 0;
    }

    public PagedMessageImpl(int storedSize, StorageManager storageManager) {
        this.storageManager = storageManager;
        this.storedSize = storedSize;
    }

    @Override
    public int getStoredSize() {
        if (this.storedSize <= 0) {
            return this.getEncodeSize();
        }
        return this.storedSize;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public void initMessage(StorageManager storage) {
        if (this.largeMessageLazyData != null) {
            LargeServerMessage lgMessage = storage.createLargeMessage();
            ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer(this.largeMessageLazyData);
            lgMessage = LargeMessagePersister.getInstance().decode(buffer, lgMessage, (CoreMessageObjectPools)null);
            if (lgMessage.toMessage() instanceof LargeServerMessage) {
                ((LargeServerMessage)((Object)lgMessage.toMessage())).setStorageManager(storage);
            }
            lgMessage.toMessage().usageUp();
            lgMessage.setPaged();
            this.message = lgMessage.toMessage();
            this.largeMessageLazyData = null;
        } else if (this.message != null && this.message instanceof LargeServerMessage) {
            ((LargeServerMessage)((Object)this.message)).setStorageManager(this.storageManager);
        }
    }

    @Override
    public long getTransactionID() {
        return this.transactionID;
    }

    @Override
    public long[] getQueueIDs() {
        return this.queueIDs;
    }

    public static boolean isLargeMessage(ActiveMQBuffer buffer) {
        return LargeMessageType.isLargeMessage(buffer.getByte(buffer.readerIndex() + 8));
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.transactionID = buffer.readLong();
        boolean isCoreLargeMessage = LargeMessageType.isCoreLargeMessageType(buffer.readByte());
        if (isCoreLargeMessage) {
            int largeMessageHeaderSize = buffer.readInt();
            if (this.storageManager == null) {
                this.largeMessageLazyData = new byte[largeMessageHeaderSize];
                buffer.readBytes(this.largeMessageLazyData);
            } else {
                this.message = this.storageManager.createLargeMessage().toMessage();
                LargeMessagePersister.getInstance().decode(buffer, (LargeServerMessage)((Object)this.message), (CoreMessageObjectPools)null);
                ((LargeServerMessage)((Object)this.message)).setStorageManager(this.storageManager);
                ((LargeServerMessage)((Object)this.message)).toMessage().usageUp();
            }
        } else {
            this.message = MessagePersister.getInstance().decode(buffer, null, null, this.storageManager);
            if (this.message.isLargeMessage()) {
                this.message.usageUp();
            }
        }
        int queueIDsSize = buffer.readInt();
        this.queueIDs = new long[queueIDsSize];
        for (int i2 = 0; i2 < queueIDsSize; ++i2) {
            this.queueIDs[i2] = buffer.readLong();
        }
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.transactionID);
        byte largeMessageType = LargeMessageType.valueOf(this.message);
        buffer.writeByte(largeMessageType);
        if (LargeMessageType.isCoreLargeMessageType(largeMessageType)) {
            buffer.writeInt(LargeMessagePersister.getInstance().getEncodeSize((LargeServerMessage)((Object)this.message)));
            LargeMessagePersister.getInstance().encode(buffer, (LargeServerMessage)((Object)this.message));
        } else {
            this.message.getPersister().encode(buffer, this.message);
        }
        buffer.writeInt(this.queueIDs.length);
        for (long queueID : this.queueIDs) {
            buffer.writeLong(queueID);
        }
    }

    @Override
    public int getEncodeSize() {
        if (LargeMessageType.isCoreLargeMessage(this.message)) {
            return 13 + LargeMessagePersister.getInstance().getEncodeSize((LargeServerMessage)((Object)this.message)) + 4 + this.queueIDs.length * 8;
        }
        return 9 + this.message.getPersister().getEncodeSize(this.message) + 4 + this.queueIDs.length * 8;
    }

    public String toString() {
        return "PagedMessageImpl [queueIDs=" + Arrays.toString(this.queueIDs) + ", transactionID=" + this.transactionID + ", message=" + this.message + "]";
    }

    @Override
    public long getPersistentSize() throws ActiveMQException {
        return this.message.getPersistentSize();
    }

    private static final class LargeMessageType {
        private static final byte NONE = 0;
        private static final byte CORE = 1;
        private static final byte OLD_CORE = -1;
        private static final byte NOT_CORE = 2;

        private LargeMessageType() {
        }

        public static boolean isLargeMessage(byte encodedValue) {
            switch (encodedValue) {
                case 0: {
                    return false;
                }
                case -1: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            throw new IllegalStateException("This largeMessageType isn't supported: " + encodedValue);
        }

        public static boolean isCoreLargeMessage(Message message) {
            return message.isLargeMessage() && message instanceof ICoreMessage;
        }

        public static boolean isCoreLargeMessageType(byte encodedValue) {
            return encodedValue == 1 || encodedValue == -1;
        }

        public static byte valueOf(Message message) {
            if (!message.isLargeMessage()) {
                return 0;
            }
            if (message instanceof ICoreMessage) {
                return 1;
            }
            return 2;
        }
    }
}

