/*
 * Decompiled with CFR 0.152.
 */
package mslinks.data;

import io.ByteReader;
import io.ByteWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.CNRLinkFlags;

public class CNRLink
implements Serializable {
    public static final int WNNC_NET_AVID = 106496;
    public static final int WNNC_NET_DOCUSPACE = 110592;
    public static final int WNNC_NET_MANGOSOFT = 114688;
    public static final int WNNC_NET_SERNET = 118784;
    public static final int WNNC_NET_RIVERFRONT1 = 122880;
    public static final int WNNC_NET_RIVERFRONT2 = 126976;
    public static final int WNNC_NET_DECORB = 131072;
    public static final int WNNC_NET_PROTSTOR = 135168;
    public static final int WNNC_NET_FJ_REDIR = 139264;
    public static final int WNNC_NET_DISTINCT = 143360;
    public static final int WNNC_NET_TWINS = 147456;
    public static final int WNNC_NET_RDR2SAMPLE = 151552;
    public static final int WNNC_NET_CSC = 155648;
    public static final int WNNC_NET_3IN1 = 159744;
    public static final int WNNC_NET_EXTENDNET = 167936;
    public static final int WNNC_NET_STAC = 172032;
    public static final int WNNC_NET_FOXBAT = 176128;
    public static final int WNNC_NET_YAHOO = 180224;
    public static final int WNNC_NET_EXIFS = 184320;
    public static final int WNNC_NET_DAV = 188416;
    public static final int WNNC_NET_KNOWARE = 192512;
    public static final int WNNC_NET_OBJECT_DIRE = 196608;
    public static final int WNNC_NET_MASFAX = 200704;
    public static final int WNNC_NET_HOB_NFS = 204800;
    public static final int WNNC_NET_SHIVA = 208896;
    public static final int WNNC_NET_IBMAL = 212992;
    public static final int WNNC_NET_LOCK = 217088;
    public static final int WNNC_NET_TERMSRV = 221184;
    public static final int WNNC_NET_SRT = 225280;
    public static final int WNNC_NET_QUINCY = 229376;
    public static final int WNNC_NET_OPENAFS = 233472;
    public static final int WNNC_NET_AVID1 = 237568;
    public static final int WNNC_NET_DFS = 241664;
    public static final int WNNC_NET_KWNP = 245760;
    public static final int WNNC_NET_ZENWORKS = 249856;
    public static final int WNNC_NET_DRIVEONWEB = 253952;
    public static final int WNNC_NET_VMWARE = 258048;
    public static final int WNNC_NET_RSFX = 262144;
    public static final int WNNC_NET_MFILES = 266240;
    public static final int WNNC_NET_MS_NFS = 270336;
    public static final int WNNC_NET_GOOGLE = 274432;
    private CNRLinkFlags flags;
    private int nptype;
    private String netname;
    private String devname;

    public CNRLink() {
        this.flags = new CNRLinkFlags(0).setValidNetType();
        this.nptype = 131072;
        this.netname = "";
    }

    public CNRLink(ByteReader data) throws ShellLinkException, IOException {
        int pos = data.getPosition();
        int size = (int)data.read4bytes();
        if (size < 20) {
            throw new ShellLinkException();
        }
        this.flags = new CNRLinkFlags(data);
        int nnoffset = (int)data.read4bytes();
        int dnoffset = (int)data.read4bytes();
        if (!this.flags.isValidDevice()) {
            dnoffset = 0;
        }
        this.nptype = (int)data.read4bytes();
        if (this.flags.isValidNetType()) {
            this.checkNptype(this.nptype);
        } else {
            this.nptype = 0;
        }
        int nnoffset_u = 0;
        int dnoffset_u = 0;
        if (nnoffset > 20) {
            nnoffset_u = (int)data.read4bytes();
            dnoffset_u = (int)data.read4bytes();
        }
        data.seek(pos + nnoffset - data.getPosition());
        this.netname = data.readString(pos + size - data.getPosition());
        if (dnoffset != 0) {
            data.seek(pos + dnoffset - data.getPosition());
            this.devname = data.readString(pos + size - data.getPosition());
        }
        if (nnoffset_u != 0) {
            this.netname = data.readUnicodeString(pos + size - data.getPosition() >> 1);
        }
        if (dnoffset_u != 0) {
            this.devname = data.readUnicodeString(pos + size - data.getPosition() >> 1);
        }
    }

    private void checkNptype(int type) throws ShellLinkException {
        int mod = 25;
        for (Field f : this.getClass().getFields()) {
            try {
                if ((f.getModifiers() & mod) != mod || type != (Integer)f.get(null)) continue;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ShellLinkException("incorrect network type");
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        int size = 20;
        boolean u = false;
        CharsetEncoder ce = Charset.defaultCharset().newEncoder();
        boolean bl = u = !ce.canEncode(this.netname) || this.devname != null && !ce.canEncode(this.devname);
        if (u) {
            size += 8;
        }
        byte[] netname_b = null;
        byte[] devname_b = null;
        netname_b = this.netname.getBytes();
        if (this.devname != null) {
            devname_b = this.devname.getBytes();
        }
        size += netname_b.length + 1;
        if (devname_b != null) {
            size += devname_b.length + 1;
        }
        if (u) {
            size += this.netname.length() * 2 + 2;
            if (this.devname != null) {
                size += this.devname.length() * 2 + 2;
            }
        }
        bw.write4bytes(size);
        this.flags.serialize(bw);
        int off = 20;
        if (u) {
            off += 8;
        }
        bw.write4bytes(off);
        off += netname_b.length + 1;
        if (devname_b != null) {
            bw.write4bytes(off);
            off += devname_b.length + 1;
        } else {
            bw.write4bytes(0L);
        }
        bw.write4bytes(this.nptype);
        if (u) {
            bw.write4bytes(off);
            off += this.netname.length() * 2 + 2;
            if (this.devname != null) {
                bw.write4bytes(off);
                off += this.devname.length() * 2 + 2;
            } else {
                bw.write4bytes(0L);
            }
        }
        bw.writeBytes(netname_b);
        bw.write(0);
        if (devname_b != null) {
            bw.writeBytes(devname_b);
            bw.write(0);
        }
        if (u) {
            int i2;
            for (i2 = 0; i2 < this.netname.length(); ++i2) {
                bw.write2bytes(this.netname.charAt(i2));
            }
            bw.write2bytes(0L);
            if (this.devname != null) {
                for (i2 = 0; i2 < this.devname.length(); ++i2) {
                    bw.write2bytes(this.devname.charAt(i2));
                }
                bw.write2bytes(0L);
            }
        }
    }

    public int getNetworkType() {
        return this.nptype;
    }

    public CNRLink setNetworkType(int n) throws ShellLinkException {
        if (n == 0) {
            this.flags.clearValidNetType();
            this.nptype = n;
        } else {
            this.checkNptype(n);
            this.flags.setValidNetType();
            this.nptype = n;
        }
        return this;
    }

    public String getNetName() {
        return this.netname;
    }

    public CNRLink setNetName(String s2) {
        if (s2 != null) {
            this.netname = s2;
        }
        return this;
    }

    public String getDeviceName() {
        return this.devname;
    }

    public CNRLink setDeviceName(String s2) {
        if (s2 == null) {
            this.devname = null;
            this.flags.clearValidDevice();
        } else {
            this.devname = s2;
            this.flags.setValidDevice();
        }
        return this;
    }
}

