/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import io.ByteWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.CNRLink;
import mslinks.data.LinkInfoFlags;
import mslinks.data.VolumeID;

public class LinkInfo
implements Serializable {
    private LinkInfoFlags lif;
    private VolumeID vid;
    private String localBasePath;
    private CNRLink cnrlink;
    private String commonPathSuffix;

    public LinkInfo() {
        this.lif = new LinkInfoFlags(0);
    }

    public LinkInfo(ByteReader data) throws IOException, ShellLinkException {
        int pos = data.getPosition();
        int size = (int)data.read4bytes();
        int hsize = (int)data.read4bytes();
        this.lif = new LinkInfoFlags(data);
        int vidoffset = (int)data.read4bytes();
        int lbpoffset = (int)data.read4bytes();
        int cnrloffset = (int)data.read4bytes();
        int cpsoffset = (int)data.read4bytes();
        int lbpoffset_u = 0;
        int cpfoffset_u = 0;
        if (hsize >= 36) {
            lbpoffset_u = (int)data.read4bytes();
            cpfoffset_u = (int)data.read4bytes();
        }
        if (this.lif.hasVolumeIDAndLocalBasePath()) {
            data.seek(pos + vidoffset - data.getPosition());
            this.vid = new VolumeID(data);
            data.seek(pos + lbpoffset - data.getPosition());
            this.localBasePath = data.readString(pos + size - data.getPosition());
        }
        if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix()) {
            data.seek(pos + cnrloffset - data.getPosition());
            this.cnrlink = new CNRLink(data);
            data.seek(pos + cpsoffset - data.getPosition());
            this.commonPathSuffix = data.readString(pos + size - data.getPosition());
        }
        if (this.lif.hasVolumeIDAndLocalBasePath() && lbpoffset_u != 0) {
            data.seek(pos + lbpoffset_u - data.getPosition());
            this.localBasePath = data.readUnicodeString(pos + size - data.getPosition() >> 1);
        }
        if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix() && cpfoffset_u != 0) {
            data.seek(pos + cpfoffset_u - data.getPosition());
            this.commonPathSuffix = data.readUnicodeString(pos + size - data.getPosition() >> 1);
        }
        data.seek(pos + size - data.getPosition());
    }

    @Override
    public void serialize(ByteWriter bw) throws IOException {
        int pos = bw.getPosition();
        int hsize = 28;
        CharsetEncoder ce = Charset.defaultCharset().newEncoder();
        if (this.localBasePath != null && !ce.canEncode(this.localBasePath) || this.commonPathSuffix != null && !ce.canEncode(this.commonPathSuffix)) {
            hsize += 8;
        }
        byte[] vid_b = null;
        byte[] localBasePath_b = null;
        byte[] cnrlink_b = null;
        byte[] commonPathSuffix_b = null;
        if (this.lif.hasVolumeIDAndLocalBasePath()) {
            vid_b = this.toByteArray(this.vid);
            localBasePath_b = this.localBasePath.getBytes();
            commonPathSuffix_b = new byte[]{};
        }
        if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix()) {
            cnrlink_b = this.toByteArray(this.cnrlink);
            commonPathSuffix_b = this.commonPathSuffix.getBytes();
        }
        int size = hsize + (vid_b == null ? 0 : vid_b.length) + (localBasePath_b == null ? 0 : localBasePath_b.length + 1) + (cnrlink_b == null ? 0 : cnrlink_b.length) + commonPathSuffix_b.length + 1;
        if (hsize > 28) {
            if (this.lif.hasVolumeIDAndLocalBasePath()) {
                size += this.localBasePath.length() * 2 + 2;
                ++size;
            }
            if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix()) {
                size += this.commonPathSuffix.length() * 2;
            }
            size += 2;
        }
        bw.write4bytes(size);
        bw.write4bytes(hsize);
        this.lif.serialize(bw);
        int off = hsize;
        if (this.lif.hasVolumeIDAndLocalBasePath()) {
            bw.write4bytes(off);
            bw.write4bytes(off += vid_b.length);
            off += localBasePath_b.length + 1;
        } else {
            bw.write4bytes(0L);
            bw.write4bytes(0L);
        }
        if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix()) {
            bw.write4bytes(off);
            bw.write4bytes(off += cnrlink_b.length);
            off += commonPathSuffix_b.length + 1;
        } else {
            bw.write4bytes(0L);
            bw.write4bytes(size - (hsize > 28 ? 4 : 1));
        }
        if (hsize > 28) {
            if (this.lif.hasVolumeIDAndLocalBasePath()) {
                bw.write4bytes(off);
                off += this.localBasePath.length() * 2 + 2;
                bw.write4bytes(size - 2);
            } else {
                bw.write4bytes(0L);
                bw.write4bytes(off);
                off += this.commonPathSuffix.length() * 2 + 2;
            }
        }
        if (this.lif.hasVolumeIDAndLocalBasePath()) {
            bw.writeBytes(vid_b);
            bw.writeBytes(localBasePath_b);
            bw.write(0);
        }
        if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix()) {
            bw.writeBytes(cnrlink_b);
            bw.writeBytes(commonPathSuffix_b);
            bw.write(0);
        }
        if (hsize > 28) {
            int i2;
            if (this.lif.hasVolumeIDAndLocalBasePath()) {
                for (i2 = 0; i2 < this.localBasePath.length(); ++i2) {
                    bw.write2bytes(this.localBasePath.charAt(i2));
                }
                bw.write2bytes(0L);
            }
            if (this.lif.hasCommonNetworkRelativeLinkAndPathSuffix()) {
                for (i2 = 0; i2 < this.commonPathSuffix.length(); ++i2) {
                    bw.write2bytes(this.commonPathSuffix.charAt(i2));
                }
                bw.write2bytes(0L);
            }
        }
        while (bw.getPosition() < pos + size) {
            bw.write(0);
        }
    }

    private byte[] toByteArray(Serializable o) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ByteWriter bt = new ByteWriter(arr);
        o.serialize(bt);
        return arr.toByteArray();
    }

    public VolumeID getVolumeID() {
        return this.vid;
    }

    public VolumeID createVolumeID() {
        this.vid = new VolumeID();
        this.localBasePath = "";
        this.lif.setVolumeIDAndLocalBasePath();
        return this.vid;
    }

    public String getLocalBasePath() {
        return this.localBasePath;
    }

    public LinkInfo setLocalBasePath(String s2) {
        if (s2 == null) {
            return this;
        }
        this.localBasePath = s2;
        if (this.vid == null) {
            this.vid = new VolumeID();
        }
        this.lif.setVolumeIDAndLocalBasePath();
        return this;
    }

    public CNRLink getCommonNetworkRelativeLink() {
        return this.cnrlink;
    }

    public CNRLink createCommonNetworkRelativeLink() {
        this.cnrlink = new CNRLink();
        this.commonPathSuffix = "";
        this.lif.setCommonNetworkRelativeLinkAndPathSuffix();
        return this.cnrlink;
    }

    public String getCommonPathSuffix() {
        return this.commonPathSuffix;
    }

    public LinkInfo setCommonPathSuffix(String s2) {
        if (s2 == null) {
            return this;
        }
        this.commonPathSuffix = s2;
        if (this.cnrlink == null) {
            this.cnrlink = new CNRLink();
        }
        this.lif.setCommonNetworkRelativeLinkAndPathSuffix();
        return this;
    }
}

