/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.shadows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.Objects;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.MaterialDrawingUtils;

public class RoundedCornerBorder
extends AbstractBorder {
    protected int arch = 12;
    protected Color colorLine;
    protected float withBorder = 1.2f;

    public RoundedCornerBorder() {
        this.colorLine = MaterialColors.LIGHT_BLUE_400;
    }

    public RoundedCornerBorder(Color colorLine) {
        this.colorLine = colorLine;
    }

    public RoundedCornerBorder(Color colorLine, int arch) {
        this.colorLine = colorLine;
        this.arch = arch;
    }

    public RoundedCornerBorder(int arch, Color colorLine, float withBorder) {
        this.arch = arch;
        this.colorLine = colorLine;
        this.withBorder = withBorder;
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        g2 = MaterialDrawingUtils.getAliasedGraphics(g2);
        Graphics2D g22 = (Graphics2D)g2.create();
        g22.setStroke(new BasicStroke(this.withBorder));
        int r = this.arch;
        int w = width - 1;
        int h2 = height - 1;
        Area round = new Area(new RoundRectangle2D.Double(x, y, w, h2, r, r));
        if (c instanceof JPopupMenu) {
            g22.setPaint(c.getBackground());
            g22.fill(round);
        } else {
            Container parent = c.getParent();
            if (Objects.nonNull(parent)) {
                g22.setPaint(parent.getBackground());
                Area corner = new Area(new RoundRectangle2D.Float(x, y, width, height, r, r));
                corner.subtract(round);
                g22.fill(corner);
            }
        }
        g22.setPaint(this.colorLine);
        g22.draw(round);
        g22.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(4, 8, 4, 8);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(4, 8, 4, 8);
        return insets;
    }
}

