/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.password;

import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.View;
import mdlaf.components.textfield.MaterialComponentField;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialPasswordFieldUI
extends MaterialComponentField {
    protected static final String ProprietyPrefix = "PasswordField";
    protected BasicPasswordFieldUI basicPasswordFieldUI = new BasicPasswordFieldUI();

    public MaterialPasswordFieldUI() {
        this(true);
    }

    public MaterialPasswordFieldUI(boolean drawLine) {
        this.drawLine = drawLine;
    }

    public static ComponentUI createUI(JComponent c) {
        return new MaterialPasswordFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return ProprietyPrefix;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.basicPasswordFieldUI.installUI(c);
        JPasswordField passwordField = (JPasswordField)c;
        passwordField.setEchoChar(((Character)UIManager.get("PasswordField.echoChar")).charValue());
        this.installMyDefaults(passwordField);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setCursor(Cursor.getDefaultCursor());
        this.basicPasswordFieldUI.uninstallUI(c);
        this.textComponent = null;
        super.uninstallUI(c);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().setBorder(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this.focusListenerColorLine);
        this.getComponent().addPropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListenerColorLine);
        this.getComponent().removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics g2) {
        super.paintBackground(MaterialDrawingUtils.getAliasedGraphics(g2));
    }

    @Override
    public void paintSafely(Graphics g2) {
        super.paintSafely(g2);
        this.changeColorOnFocus(g2);
        this.paintLine(g2);
    }

    @Override
    public View create(Element elem) {
        return new MaterialPasswordView(elem);
    }

    protected class MaterialPasswordView
    extends PasswordView {
        private MaterialPasswordView(Element elem) {
            super(elem);
        }

        @Override
        protected int drawEchoCharacter(Graphics g2, int x, int y, char c) {
            Graphics2D g22 = (Graphics2D)g2.create();
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = g22.getFontMetrics();
            int r = fm.charWidth(c) - 2;
            g22.fillOval(x + 1, y + 5 - fm.getAscent(), r, r);
            g22.dispose();
            return x + fm.charWidth(c);
        }
    }
}

