/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.Type;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;

public class MinecraftServer {
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private final URL MANIFEST_URL;
    private final String VERSION;
    private final Type TYPE;
    private JsonNode serverJson = null;

    protected MinecraftServer(String mcVersion, Type mcType, URL mcUrl) {
        this.MANIFEST_URL = mcUrl;
        this.VERSION = mcVersion;
        this.TYPE = mcType;
    }

    private void setServerJson() {
        try {
            this.serverJson = this.OBJECT_MAPPER.readTree(this.MANIFEST_URL.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String version() {
        return this.VERSION;
    }

    public Type type() {
        return this.TYPE;
    }

    public Optional<URL> url() {
        if (this.serverJson == null) {
            this.setServerJson();
        }
        try {
            return Optional.of(new URL(this.serverJson.get("downloads").get("server").get("url").asText()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<Byte> javaVersion() {
        if (this.serverJson == null) {
            this.setServerJson();
        }
        try {
            return Optional.of(Byte.parseByte(this.serverJson.get("javaVersion").get("majorVersion").asText()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

