/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.versionmeta.Type;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftClient;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftClientMeta {
    private static final Logger LOG = LogManager.getLogger(MinecraftClientMeta.class);
    private final ObjectMapper OBJECTMAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private final ForgeMeta FORGE_META;
    private final File MINECRAFT_MANIFEST;
    private final List<MinecraftClient> RELEASES = new ArrayList<MinecraftClient>();
    private final List<MinecraftClient> SNAPSHOTS = new ArrayList<MinecraftClient>();
    private MinecraftClient latestRelease;
    private MinecraftClient latestSnapshot;
    private HashMap<String, MinecraftClient> meta = new HashMap();

    protected MinecraftClientMeta(File minecraftManifest, ForgeMeta injectedForgeMeta) {
        this.MINECRAFT_MANIFEST = minecraftManifest;
        this.FORGE_META = injectedForgeMeta;
    }

    protected MinecraftClientMeta update() throws IOException {
        this.RELEASES.clear();
        this.SNAPSHOTS.clear();
        this.meta = new HashMap();
        JsonNode minecraftManifest = this.OBJECTMAPPER.readTree(this.MINECRAFT_MANIFEST);
        minecraftManifest.get("versions").forEach(minecraftVersion -> {
            if (minecraftVersion.get("type").asText().equalsIgnoreCase("release")) {
                try {
                    this.RELEASES.add(new MinecraftClient(minecraftVersion.get("id").asText(), Type.RELEASE, new URL(minecraftVersion.get("url").asText()), this.FORGE_META));
                }
                catch (IOException ex) {
                    LOG.debug("No server available for MinecraftClient version " + minecraftVersion.get("id").asText(), (Throwable)ex);
                }
            } else if (minecraftVersion.get("type").asText().equalsIgnoreCase("snapshot")) {
                try {
                    this.SNAPSHOTS.add(new MinecraftClient(minecraftVersion.get("id").asText(), Type.SNAPSHOT, new URL(minecraftVersion.get("url").asText()), this.FORGE_META));
                }
                catch (IOException ex) {
                    LOG.debug("No server available for MinecraftClient version " + minecraftVersion.get("id").asText(), (Throwable)ex);
                }
            }
        });
        this.RELEASES.forEach(minecraftClient -> this.meta.put(minecraftClient.version(), (MinecraftClient)minecraftClient));
        this.SNAPSHOTS.forEach(minecraftClient -> this.meta.put(minecraftClient.version(), (MinecraftClient)minecraftClient));
        this.latestRelease = new MinecraftClient(minecraftManifest.get("latest").get("release").asText(), Type.RELEASE, this.meta.get(minecraftManifest.get("latest").get("release").asText()).url(), this.meta.get(minecraftManifest.get("latest").get("release").asText()).server(), this.FORGE_META);
        this.latestSnapshot = new MinecraftClient(minecraftManifest.get("latest").get("snapshot").asText(), Type.SNAPSHOT, this.meta.get(minecraftManifest.get("latest").get("snapshot").asText()).url(), this.meta.get(minecraftManifest.get("latest").get("snapshot").asText()).server(), this.FORGE_META);
        return this;
    }

    protected List<MinecraftClient> releases() {
        return this.RELEASES;
    }

    protected List<MinecraftClient> snapshots() {
        return this.SNAPSHOTS;
    }

    protected MinecraftClient latestRelease() {
        return this.latestRelease;
    }

    protected MinecraftClient latestSnapshot() {
        return this.latestSnapshot;
    }

    protected HashMap<String, MinecraftClient> meta() {
        return this.meta;
    }
}

