/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import de.griefed.serverpackcreator.versionmeta.Type;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeInstance;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftServer;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftClient {
    private static final Logger LOG = LogManager.getLogger(MinecraftClient.class);
    private final String VERSION;
    private final Type TYPE;
    private final URL URL;
    private final MinecraftServer MINECRAFT_SERVER;
    private ForgeMeta FORGE_META;

    protected MinecraftClient(String version, Type type, URL url, ForgeMeta forgeMeta) {
        this.VERSION = version;
        this.TYPE = type;
        this.URL = url;
        this.FORGE_META = forgeMeta;
        this.MINECRAFT_SERVER = new MinecraftServer(version, type, url);
    }

    protected MinecraftClient(String version, Type type, URL url, MinecraftServer server, ForgeMeta forgeMeta) {
        this.VERSION = version;
        this.TYPE = type;
        this.URL = url;
        this.MINECRAFT_SERVER = server;
        this.FORGE_META = forgeMeta;
    }

    public String version() {
        return this.VERSION;
    }

    public Type type() {
        return this.TYPE;
    }

    public URL url() {
        return this.URL;
    }

    public MinecraftServer server() {
        return this.MINECRAFT_SERVER;
    }

    public Optional<List<ForgeInstance>> forge() {
        return this.FORGE_META.getForgeInstances(this.VERSION);
    }
}

